/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.Expression;
import org.geotools.filter.function.ClassificationFunction;

public class EqualIntervalFunction
extends ClassificationFunction {
    FeatureCollection fc = null;
    double min = 0.0;
    double max = 0.0;

    public String getName() {
        return "EqualInterval";
    }

    private void calculateMinAndMax() {
        FeatureIterator it = this.fc.features();
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        while (it.hasNext()) {
            Feature f = it.next();
            double value = ((Number)this.expr.getValue(f)).doubleValue();
            if (value > this.max) {
                this.max = value;
            }
            if (!(value < this.min)) continue;
            this.min = value;
        }
    }

    public void setNumberOfClasses(int i) {
        this.classNum = i;
    }

    protected int calculateSlot(double val) {
        if (val >= this.max) {
            return this.classNum - 1;
        }
        double slotWidth = (this.max - this.min) / (double)this.classNum;
        return (int)Math.floor((val - this.min) / slotWidth);
    }

    public Object getValue(Feature feature) {
        FeatureCollection coll = feature.getParent();
        if (!coll.equals(this.fc)) {
            this.fc = coll;
            this.calculateMinAndMax();
        }
        int slot = this.calculateSlot(((Number)this.expr.getValue(feature)).doubleValue());
        return new Integer(slot);
    }

    public void setExpression(Expression e) {
        super.setExpression(e);
        if (this.fc != null) {
            this.calculateMinAndMax();
        }
    }
}

