/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.util.CheckedArrayList;
import org.geotools.util.CheckedHashSet;

public class MetadataEntity
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5730550742604669102L;
    protected static final Logger LOGGER;
    private transient MetadataEntity unmodifiable;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected MetadataEntity() {
    }

    public boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public synchronized MetadataEntity unmodifiable() {
        if (this.unmodifiable == null) {
            try {
                this.unmodifiable = (MetadataEntity)this.clone();
            }
            catch (CloneNotSupportedException exception) {
                LOGGER.warning("Cant't clone the medata. Assumes it is immutable.");
                return this;
            }
            this.unmodifiable.freeze();
        }
        return this.unmodifiable;
    }

    protected static Object unmodifiable(Object object) {
        if (object instanceof MetadataEntity) {
            return ((MetadataEntity)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (collection.isEmpty()) {
                return null;
            }
            if (collection instanceof org.opengis.util.Cloneable) {
                ArrayList<Object> buffer = (collection = (Collection)((org.opengis.util.Cloneable)collection).clone()) instanceof List ? (ArrayList<Object>)collection : new ArrayList<Object>(collection.size());
                int index = 0;
                boolean refill = false;
                Iterator it = collection.iterator();
                while (it.hasNext()) {
                    Object copy;
                    boolean changed;
                    Object original = it.next();
                    boolean bl = changed = original != (copy = MetadataEntity.unmodifiable(original));
                    if (buffer == collection) {
                        if (changed) {
                            buffer.set(index, copy);
                        }
                    } else {
                        buffer.add(copy);
                        refill |= changed;
                    }
                    ++index;
                }
                if (refill) {
                    collection.clear();
                    collection.addAll(buffer);
                }
                if (collection instanceof List) {
                    return Collections.unmodifiableList((List)collection);
                }
                if (collection instanceof Set) {
                    return Collections.unmodifiableSet((Set)collection);
                }
                return Collections.unmodifiableCollection(collection);
            }
            return collection;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.isEmpty()) {
                return null;
            }
            if (map instanceof org.opengis.util.Cloneable) {
                Map copy = (Map)((org.opengis.util.Cloneable)map).clone();
                copy.clear();
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    copy.put(MetadataEntity.unmodifiable(entry.getKey()), MetadataEntity.unmodifiable(entry.getValue()));
                }
                return Collections.unmodifiableMap(copy);
            }
            return map;
        }
        return object;
    }

    protected void freeze() {
        this.unmodifiable = this;
    }

    protected void checkWritePermission() throws UnsupportedOperationException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.unmodifiable == this) {
            throw new UnsupportedOperationException("Unmodifiable metadata");
        }
        this.unmodifiable = null;
    }

    protected final Collection copyCollection(Collection source, Collection target, Class elementType) {
        this.checkWritePermission();
        if (source == null) {
            if (target != null) {
                target.clear();
            }
        } else {
            boolean isList = source instanceof List;
            if (target == null || target instanceof List != isList) {
                target = isList ? new CheckedArrayList(elementType) : new CheckedHashSet(elementType);
            } else {
                target.clear();
            }
            target.addAll(source);
        }
        return target;
    }

    protected final Collection nonNullCollection(Collection c, Class elementType) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (c != null) {
            return c;
        }
        if (this.isModifiable()) {
            return new CheckedHashSet(elementType);
        }
        return Collections.EMPTY_SET;
    }

    protected static void appendLineSeparator(StringBuffer buffer) {
        if (buffer.length() != 0) {
            buffer.append(System.getProperty("line.separator", "\n"));
        }
    }

    static {
        $assertionsDisabled = !MetadataEntity.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger("org.geotools.metadata");
    }
}

