/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.distribution;

import java.util.Collection;
import javax.units.Unit;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.distribution.Medium;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.metadata.distribution.MediumName;
import org.opengis.util.InternationalString;

public class MediumImpl
extends MetadataEntity
implements Medium {
    private static final long serialVersionUID = -2838122926367921673L;
    private MediumName name;
    private Collection densities;
    private Unit densityUnits;
    private Integer volumes;
    private Collection mediumFormats;
    private InternationalString mediumNote;

    public MediumName getName() {
        return this.name;
    }

    public synchronized void setName(MediumName newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    public Unit getDensityUnits() {
        return this.densityUnits;
    }

    public synchronized void setDensityUnits(Unit newValue) {
        this.checkWritePermission();
        this.densityUnits = newValue;
    }

    public Integer getVolumes() {
        return this.volumes;
    }

    public synchronized void setVolumes(Integer newValue) {
        this.checkWritePermission();
        this.volumes = newValue;
    }

    public synchronized Collection getMediumFormats() {
        this.mediumFormats = this.nonNullCollection(this.mediumFormats, MediumFormat.class);
        return this.mediumFormats;
    }

    public synchronized void setMediumFormat(Collection newValues) {
        this.mediumFormats = this.copyCollection(newValues, this.mediumFormats, MediumFormat.class);
    }

    public InternationalString getMediumNote() {
        return this.mediumNote;
    }

    public synchronized void setMediumNote(InternationalString newValue) {
        this.checkWritePermission();
        this.mediumNote = newValue;
    }

    public synchronized Collection getDensities() {
        this.densities = this.nonNullCollection(this.densities, Number.class);
        return this.densities;
    }

    public synchronized void setDensities(Collection newValues) {
        this.densities = this.copyCollection(newValues, this.densities, Number.class);
    }

    protected void freeze() {
        super.freeze();
        this.densities = (Collection)MediumImpl.unmodifiable(this.densities);
        this.densityUnits = (Unit)MediumImpl.unmodifiable(this.densityUnits);
        this.mediumFormats = (Collection)MediumImpl.unmodifiable(this.mediumFormats);
        this.mediumNote = (InternationalString)MediumImpl.unmodifiable(this.mediumNote);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            MediumImpl that = (MediumImpl)object;
            return Utilities.equals(this.name, that.name) && Utilities.equals(this.densities, that.densities) && Utilities.equals(this.densityUnits, that.densityUnits) && Utilities.equals(this.volumes, that.volumes) && Utilities.equals(this.mediumFormats, that.mediumFormats) && Utilities.equals(this.mediumNote, that.mediumNote);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1223862775;
        if (this.name != null) {
            code ^= this.name.hashCode();
        }
        if (this.densities != null) {
            code ^= ((Object)this.densities).hashCode();
        }
        if (this.densityUnits != null) {
            code ^= this.densityUnits.hashCode();
        }
        if (this.volumes != null) {
            code ^= this.volumes.hashCode();
        }
        if (this.mediumFormats != null) {
            code ^= ((Object)this.mediumFormats).hashCode();
        }
        if (this.mediumNote != null) {
            code ^= this.mediumNote.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.name);
    }
}

