/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.rsc.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;

public abstract class AbstractParameterDescriptor
extends AbstractIdentifiedObject
implements GeneralParameterDescriptor {
    private static final long serialVersionUID = -2630644278783845276L;
    private final int minimumOccurs;

    protected AbstractParameterDescriptor(Map properties, int minimumOccurs, int maximumOccurs) {
        super(properties);
        this.minimumOccurs = minimumOccurs;
        if (minimumOccurs < 0 || maximumOccurs < minimumOccurs) {
            throw new IllegalArgumentException(Resources.format(1, new Integer(minimumOccurs), new Integer(maximumOccurs)));
        }
    }

    public abstract GeneralParameterValue createValue();

    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    public abstract int getMaximumOccurs();

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractParameterDescriptor that = (AbstractParameterDescriptor)object;
            return this.minimumOccurs == that.minimumOccurs;
        }
        return false;
    }

    public int hashCode() {
        return 0x58ACDC64 ^ this.minimumOccurs;
    }

    protected String formatWKT(Formatter formatter) {
        formatter.setInvalidWKT();
        return "PARAMETER";
    }
}

