/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.Properties;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.NameFactory;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.ScopedName;

public class AbstractIdentifiedObject
extends Formattable
implements IdentifiedObject,
Serializable {
    private static final long serialVersionUID = -5173281694258483264L;
    public static final Identifier[] EMPTY_IDENTIFIER_ARRAY;
    public static final GenericName[] EMPTY_ALIAS_ARRAY;
    public static final String NAME_PROPERTY = "name";
    public static final String ALIAS_PROPERTY = "alias";
    public static final String IDENTIFIERS_PROPERTY = "identifiers";
    public static final String REMARKS_PROPERTY = "remarks";
    public static final Comparator NAME_COMPARATOR;
    public static final Comparator IDENTIFIER_COMPARATOR;
    public static final Comparator REMARKS_COMPARATOR;
    private final Identifier name;
    private final Collection alias;
    private final Set identifiers;
    private final InternationalString remarks;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractIdentifiedObject(IdentifiedObject object) {
        this.name = object.getName();
        this.alias = object.getAlias();
        this.identifiers = object.getIdentifiers();
        this.remarks = object.getRemarks();
    }

    public AbstractIdentifiedObject(Map properties) throws IllegalArgumentException {
        this(properties, null, null);
    }

    protected AbstractIdentifiedObject(Map properties, Map subProperties, String[] localizables) throws IllegalArgumentException {
        AbstractIdentifiedObject.ensureNonNull("properties", properties);
        Object name = null;
        Object[] alias = null;
        Object[] identifiers = null;
        GrowableInternationalString remarks = null;
        GrowableInternationalString growable = null;
        GrowableInternationalString[] subGrowables = null;
        Iterator it = properties.entrySet().iterator();
        block14: while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = ((String)entry.getKey()).trim().toLowerCase();
            Object value = entry.getValue();
            switch (key.hashCode()) {
                case -1528693765: {
                    if (!key.equalsIgnoreCase("anchorPoint")) break;
                    key = "anchorPoint";
                    break;
                }
                case -1805658881: {
                    if (!key.equalsIgnoreCase("bursaWolf")) break;
                    key = "bursaWolf";
                    break;
                }
                case 109688209: {
                    if (!key.equalsIgnoreCase("operationVersion")) break;
                    key = "operationVersion";
                    break;
                }
                case 1126917133: {
                    if (!key.equalsIgnoreCase("positionalAccuracy")) break;
                    key = "positionalAccuracy";
                    break;
                }
                case 1127093059: {
                    if (!key.equalsIgnoreCase("realizationEpoch")) break;
                    key = "realizationEpoch";
                    break;
                }
                case -1109785975: {
                    if (!key.equalsIgnoreCase("validArea")) break;
                    key = "validArea";
                    break;
                }
                case 3373707: {
                    if (!key.equals(NAME_PROPERTY)) break;
                    if (value instanceof String) {
                        name = new NamedIdentifier(properties, false);
                        if (!$assertionsDisabled && !value.equals(((Identifier)name).getCode())) {
                            throw new AssertionError(name);
                        }
                        continue block14;
                    }
                    name = value;
                    continue block14;
                }
                case 92902992: {
                    if (!key.equals(ALIAS_PROPERTY)) break;
                    alias = NameFactory.toArray(value);
                    continue block14;
                }
                case 1368189162: {
                    if (!key.equals(IDENTIFIERS_PROPERTY)) break;
                    if (value == null) continue block14;
                    if (value instanceof Identifier) {
                        identifiers = new Identifier[]{(Identifier)value};
                        continue block14;
                    }
                    identifiers = (Object[])value;
                    continue block14;
                }
                case 1091415283: {
                    if (!key.equals(REMARKS_PROPERTY) || !(value instanceof InternationalString)) break;
                    remarks = value;
                    continue block14;
                }
            }
            if (value instanceof String) {
                if (growable == null) {
                    growable = remarks instanceof GrowableInternationalString ? remarks : new GrowableInternationalString();
                }
                if (growable.add(REMARKS_PROPERTY, key, value.toString())) continue;
            }
            if (subProperties == null) continue;
            if (localizables != null) {
                String prefix;
                for (int i = 0; !(i >= localizables.length || key.equals(prefix = localizables[i]) && value instanceof InternationalString); ++i) {
                    if (!(value instanceof String)) continue;
                    if (subGrowables == null) {
                        subGrowables = new GrowableInternationalString[localizables.length];
                    }
                    if (subGrowables[i] == null) {
                        Object previous = subProperties.get(prefix);
                        subGrowables[i] = previous instanceof GrowableInternationalString ? (GrowableInternationalString)previous : new GrowableInternationalString();
                    }
                    if (subGrowables[i].add(prefix, key, value.toString())) continue block14;
                }
            }
            subProperties.put(key, value);
        }
        if (growable != null && !growable.getLocales().isEmpty()) {
            if (remarks == null) {
                remarks = growable;
            } else {
                Logger.getLogger("org.geotools.referencing").warning(Resources.format(128));
            }
        }
        if (subProperties != null && subGrowables != null) {
            for (int i = 0; i < subGrowables.length; ++i) {
                if (subGrowables[i] == null || subGrowables[i].getLocales().isEmpty()) continue;
                String prefix = localizables[i];
                if (subProperties.get(prefix) == null) {
                    subProperties.put(prefix, subGrowables[i]);
                    continue;
                }
                Logger.getLogger("org.geotools.referencing").warning(Resources.format(128));
            }
        }
        String key = null;
        Object value = null;
        try {
            key = NAME_PROPERTY;
            value = name;
            this.name = (Identifier)name;
            key = ALIAS_PROPERTY;
            value = alias;
            this.alias = AbstractIdentifiedObject.asSet(alias);
            key = IDENTIFIERS_PROPERTY;
            value = identifiers;
            this.identifiers = AbstractIdentifiedObject.asSet(identifiers);
            key = REMARKS_PROPERTY;
            value = remarks;
            this.remarks = (InternationalString)value;
        }
        catch (ClassCastException exception) {
            InvalidParameterValueException e = new InvalidParameterValueException(Resources.format(82, key, value), key, value);
            e.initCause((Throwable)exception);
            throw e;
        }
        AbstractIdentifiedObject.ensureNonNull(NAME_PROPERTY, name);
        AbstractIdentifiedObject.ensureNonNull(NAME_PROPERTY, name.toString());
    }

    public Identifier getName() {
        return this.name;
    }

    public Collection getAlias() {
        return this.alias != null ? this.alias : Collections.EMPTY_SET;
    }

    public Set getIdentifiers() {
        return this.identifiers != null ? this.identifiers : Collections.EMPTY_SET;
    }

    public InternationalString getRemarks() {
        return this.remarks;
    }

    public static Map getProperties(IdentifiedObject info) {
        return new Properties(info);
    }

    public int hashCode() {
        return 0x52B12FC0 ^ this.getClass().hashCode();
    }

    public boolean nameMatches(String name) {
        return AbstractIdentifiedObject.nameMatches(this, this.alias, name);
    }

    public static boolean nameMatches(IdentifiedObject object, String name) {
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).nameMatches(name);
        }
        return AbstractIdentifiedObject.nameMatches(object, object.getAlias(), name);
    }

    private static boolean nameMatches(IdentifiedObject object, Collection alias, String name) {
        if ((name = name.trim()).equalsIgnoreCase(object.getName().getCode().trim())) {
            return true;
        }
        if (alias != null) {
            Iterator it = alias.iterator();
            while (it.hasNext()) {
                GenericName asName = (GenericName)it.next();
                ScopedName asScoped = asName.asScopedName();
                if (asScoped != null && name.equalsIgnoreCase(asScoped.toString().trim())) {
                    return true;
                }
                if (!name.equalsIgnoreCase(asName.asLocalName().toString().trim())) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        return object instanceof AbstractIdentifiedObject && this.equals((AbstractIdentifiedObject)object, true);
    }

    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object != null && object.getClass().equals(this.getClass())) {
            if (!compareMetadata) {
                return true;
            }
            return Utilities.equals(this.name, object.name) && Utilities.equals(this.alias, object.alias) && Utilities.equals(this.identifiers, object.identifiers) && Utilities.equals(this.remarks, object.remarks);
        }
        return false;
    }

    static boolean equals(AbstractIdentifiedObject object1, AbstractIdentifiedObject object2, boolean compareMetadata) {
        return object1 == object2 || object1 != null && object1.equals(object2, compareMetadata);
    }

    protected static boolean equals(IdentifiedObject object1, IdentifiedObject object2, boolean compareMetadata) {
        if (!(object1 instanceof AbstractIdentifiedObject)) {
            return Utilities.equals(object1, object2);
        }
        if (!(object2 instanceof AbstractIdentifiedObject)) {
            return Utilities.equals(object2, object1);
        }
        return AbstractIdentifiedObject.equals((AbstractIdentifiedObject)object1, (AbstractIdentifiedObject)object2, compareMetadata);
    }

    protected static boolean equals(IdentifiedObject[] array1, IdentifiedObject[] array2, boolean compareMetadata) {
        if (array1 != array2) {
            if (array1 == null || array2 == null || array1.length != array2.length) {
                return false;
            }
            int i = array1.length;
            while (--i >= 0) {
                if (AbstractIdentifiedObject.equals(array1[i], array2[i], compareMetadata)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean equals(Collection collection1, Collection collection2, boolean compareMetadata) {
        if (collection1 == collection2) {
            return true;
        }
        if (collection1 == null || collection2 == null) {
            return false;
        }
        Iterator it1 = collection1.iterator();
        Iterator it2 = collection2.iterator();
        while (it1.hasNext()) {
            if (it2.hasNext() && AbstractIdentifiedObject.equals((IdentifiedObject)it1.next(), (IdentifiedObject)it2.next(), compareMetadata)) continue;
            return false;
        }
        return !it2.hasNext();
    }

    private static int doCompare(Comparable c1, Comparable c2) {
        if (c1 == null) {
            return c2 == null ? 0 : -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    protected static Set asSet(Object[] array) {
        if (array == null) {
            return null;
        }
        switch (array.length) {
            case 0: {
                return null;
            }
            case 1: {
                return Collections.singleton(array[0]);
            }
        }
        return Collections.unmodifiableSet(new LinkedHashSet<Object>(Arrays.asList(array)));
    }

    protected static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new InvalidParameterValueException(Resources.format(115, name), name, object);
        }
    }

    protected static void ensureNonNull(String name, Object[] array, int index) throws IllegalArgumentException {
        if (array[index] == null) {
            throw new InvalidParameterValueException(Resources.format(115, name + '[' + index + ']'), name, (Object)array);
        }
    }

    protected static void ensureTimeUnit(Unit unit) throws IllegalArgumentException {
        if (!SI.SECOND.isCompatible(unit)) {
            throw new IllegalArgumentException(Resources.format(105, unit));
        }
    }

    protected static void ensureLinearUnit(Unit unit) throws IllegalArgumentException {
        if (!SI.METER.isCompatible(unit)) {
            throw new IllegalArgumentException(Resources.format(104, unit));
        }
    }

    protected static void ensureAngularUnit(Unit unit) throws IllegalArgumentException {
        if (!SI.RADIAN.isCompatible(unit) && !Unit.ONE.equals((Object)unit)) {
            throw new IllegalArgumentException(Resources.format(103, unit));
        }
    }

    static {
        $assertionsDisabled = !AbstractIdentifiedObject.class.desiredAssertionStatus();
        EMPTY_IDENTIFIER_ARRAY = new Identifier[0];
        EMPTY_ALIAS_ARRAY = new GenericName[0];
        NAME_COMPARATOR = new NameComparator();
        IDENTIFIER_COMPARATOR = new IdentifierComparator();
        REMARKS_COMPARATOR = new RemarksComparator();
    }

    private static final class RemarksComparator
    implements Comparator,
    Serializable {
        private RemarksComparator() {
        }

        public int compare(Object o1, Object o2) {
            return AbstractIdentifiedObject.doCompare((Comparable)((IdentifiedObject)o1).getRemarks(), (Comparable)((IdentifiedObject)o2).getRemarks());
        }

        protected Object readResolve() throws ObjectStreamException {
            return REMARKS_COMPARATOR;
        }
    }

    private static final class IdentifierComparator
    implements Comparator,
    Serializable {
        private IdentifierComparator() {
        }

        public int compare(Object o1, Object o2) {
            Set a1 = ((IdentifiedObject)o1).getIdentifiers();
            Set a2 = ((IdentifiedObject)o2).getIdentifiers();
            return AbstractIdentifiedObject.doCompare(a1 != null && !a1.isEmpty() ? ((Identifier)a1.iterator().next()).getCode() : null, a2 != null && !a2.isEmpty() ? ((Identifier)a2.iterator().next()).getCode() : null);
        }

        protected Object readResolve() throws ObjectStreamException {
            return IDENTIFIER_COMPARATOR;
        }
    }

    private static final class NameComparator
    implements Comparator,
    Serializable {
        private NameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return AbstractIdentifiedObject.doCompare((Comparable)((Object)((IdentifiedObject)o1).getName().getCode()), (Comparable)((Object)((IdentifiedObject)o2).getName().getCode()));
        }

        protected Object readResolve() throws ObjectStreamException {
            return NAME_COMPARATOR;
        }
    }
}

