/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;

public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    public static final String OPERATION_VERSION_PROPERTY = "operationVersion";
    public static final String POSITIONAL_ACCURACY_PROPERTY = "positionalAccuracy";
    public static final String VALID_AREA_PROPERTY = "validArea";
    public static final String SCOPE_PROPERTY = "scope";
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection positionalAccuracy;
    protected final Extent validArea;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super((IdentifiedObject)definition);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.operationVersion = definition.getOperationVersion();
        this.positionalAccuracy = definition.getPositionalAccuracy();
        this.validArea = definition.getValidArea();
        this.scope = definition.getScope();
        this.transform = transform;
    }

    public AbstractCoordinateOperation(Map properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        this(properties, new HashMap(), sourceCRS, targetCRS, transform);
    }

    private AbstractCoordinateOperation(Map properties, Map subProperties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(properties, subProperties, LOCALIZABLES);
        this.validArea = (Extent)subProperties.get(VALID_AREA_PROPERTY);
        this.scope = (InternationalString)subProperties.get(SCOPE_PROPERTY);
        this.operationVersion = (String)subProperties.get(OPERATION_VERSION_PROPERTY);
        Object[] positionalAccuracy = (PositionalAccuracy[])subProperties.get(POSITIONAL_ACCURACY_PROPERTY);
        if (positionalAccuracy == null || positionalAccuracy.length == 0) {
            positionalAccuracy = null;
        } else {
            positionalAccuracy = (PositionalAccuracy[])positionalAccuracy.clone();
            for (int i = 0; i < positionalAccuracy.length; ++i) {
                AbstractCoordinateOperation.ensureNonNull(POSITIONAL_ACCURACY_PROPERTY, positionalAccuracy, i);
            }
        }
        this.positionalAccuracy = AbstractCoordinateOperation.asSet(positionalAccuracy);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.transform = transform;
        if (!(this instanceof Conversion) || transform != null || sourceCRS != null || targetCRS != null) {
            AbstractCoordinateOperation.ensureNonNull("sourceCRS", transform);
            AbstractCoordinateOperation.ensureNonNull("targetCRS", transform);
            AbstractCoordinateOperation.ensureNonNull("transform", transform);
            AbstractCoordinateOperation.checkDimension("sourceCRS", sourceCRS, transform.getSourceDimensions());
            AbstractCoordinateOperation.checkDimension("targetCRS", targetCRS, transform.getTargetDimensions());
        }
    }

    private static void checkDimension(String name, CoordinateReferenceSystem crs, int expected) {
        int actual;
        if (crs != null && (actual = crs.getCoordinateSystem().getDimension()) != expected) {
            throw new IllegalArgumentException(Resources.format(99, name, new Integer(actual), new Integer(expected)));
        }
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public String getOperationVersion() {
        return this.operationVersion;
    }

    public Collection getPositionalAccuracy() {
        return this.positionalAccuracy != null ? this.positionalAccuracy : Collections.EMPTY_SET;
    }

    public Extent getValidArea() {
        return this.validArea;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class getType(CoordinateOperation object) {
        if (object instanceof Transformation) {
            return Transformation.class;
        }
        if (object instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (object instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (object instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (object instanceof Projection) {
            return Projection.class;
        }
        if (object instanceof Conversion) {
            return Conversion.class;
        }
        if (object instanceof Operation) {
            return Operation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCoordinateOperation that = (AbstractCoordinateOperation)object;
            if (AbstractCoordinateOperation.equals((IdentifiedObject)this.sourceCRS, (IdentifiedObject)that.sourceCRS, compareMetadata) && Utilities.equals(this.transform, that.transform)) {
                if (!(!compareMetadata || Utilities.equals(this.validArea, that.validArea) && Utilities.equals(this.scope, that.scope) && Utilities.equals(this.positionalAccuracy, that.positionalAccuracy))) {
                    return false;
                }
                Class clazz = AbstractDerivedCRS.class;
                synchronized (clazz) {
                    boolean bl;
                    if (AbstractDerivedCRS._COMPARING != null) {
                        return true;
                    }
                    try {
                        AbstractDerivedCRS._COMPARING = this;
                        bl = AbstractCoordinateOperation.equals((IdentifiedObject)this.targetCRS, (IdentifiedObject)that.targetCRS, compareMetadata);
                        AbstractDerivedCRS._COMPARING = null;
                    }
                    catch (Throwable throwable) {
                        AbstractDerivedCRS._COMPARING = null;
                        throw throwable;
                    }
                    return bl;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int code = -598790243;
        if (this.sourceCRS != null) {
            code ^= this.sourceCRS.hashCode();
        }
        if (this.targetCRS != null) {
            code ^= this.targetCRS.hashCode();
        }
        if (this.transform != null) {
            code ^= this.transform.hashCode();
        }
        return code;
    }

    protected String formatWKT(Formatter formatter) {
        if (this.sourceCRS != null) {
            formatter.append(this.sourceCRS.getName().getCode());
        }
        if (this.targetCRS != null) {
            formatter.append(this.targetCRS.getName().getCode());
        }
        return super.formatWKT(formatter);
    }
}

