/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import javax.units.NonSI;
import org.geotools.measure.Latitude;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public class Mercator
extends MapProjection {
    protected final double standardParallel;
    static /* synthetic */ Class class$org$opengis$referencing$operation$CylindricalProjection;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Mercator(ParameterValueGroup parameters) throws ParameterNotFoundException {
        this(parameters, Mercator.getDescriptor(parameters).descriptors());
    }

    private static ParameterDescriptorGroup getDescriptor(ParameterValueGroup parameters) {
        try {
            parameters.parameter(Provider2SP.STANDARD_PARALLEL.getName().getCode());
            return Provider2SP.PARAMETERS;
        }
        catch (ParameterNotFoundException ignore) {
            return Provider1SP.PARAMETERS;
        }
    }

    Mercator(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
        super(parameters, expected);
        if (expected.contains(Provider2SP.STANDARD_PARALLEL)) {
            this.standardParallel = Math.abs(Mercator.doubleValue(expected, Provider2SP.STANDARD_PARALLEL, parameters));
            Mercator.ensureLatitudeInRange(Provider2SP.STANDARD_PARALLEL, this.standardParallel, false);
            this.scaleFactor = this.isSpherical ? (this.scaleFactor *= Math.cos(this.standardParallel)) : (this.scaleFactor *= this.msfn(Math.sin(this.standardParallel), Math.cos(this.standardParallel)));
            this.globalScale = this.scaleFactor * this.semiMajor;
        } else {
            this.standardParallel = Double.NaN;
        }
        if (!$assertionsDisabled && this.latitudeOfOrigin != 0.0) {
            throw new AssertionError(this.latitudeOfOrigin);
        }
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Double.isNaN(this.standardParallel) ? Provider1SP.PARAMETERS : Provider2SP.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        if (!Double.isNaN(this.standardParallel)) {
            List expected = this.getParameterDescriptors().descriptors();
            Mercator.set(expected, Provider2SP.STANDARD_PARALLEL, values, this.standardParallel);
        }
        return values;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y) > 1.5707953267948966) {
            throw new ProjectionException(Resources.format(119, new Latitude(Math.toDegrees(y))));
        }
        y = -Math.log(this.tsfn(y, Math.sin(y)));
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        y = Math.exp(-y);
        y = this.cphi2(y);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.standardParallel);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Mercator that = (Mercator)object;
            return Mercator.equals(this.standardParallel, that.standardParallel);
        }
        return false;
    }

    static {
        $assertionsDisabled = !Mercator.class.desiredAssertionStatus();
    }

    private static final class Spherical
    extends Mercator {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Spherical(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
            super(parameters, expected);
            if (!$assertionsDisabled && !this.isSpherical) {
                throw new AssertionError();
            }
        }

        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (Math.abs(y) > 1.5707953267948966) {
                throw new ProjectionException(Resources.format(119, new Latitude(Math.toDegrees(y))));
            }
            if (!$assertionsDisabled && (ptDst = super.transformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            y = Math.log(Math.tan(0.7853981633974483 + 0.5 * y));
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6 * this.globalScale)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            if (!$assertionsDisabled && (ptDst = super.inverseTransformNormalized(x, y, ptDst)) == null) {
                throw new AssertionError();
            }
            y = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-y));
            if (!$assertionsDisabled && !(Math.abs(ptDst.getX() - x) <= 1.0E-6)) {
                throw new AssertionError(x);
            }
            if (!$assertionsDisabled && !(Math.abs(ptDst.getY() - y) <= 1.0E-6)) {
                throw new AssertionError(y);
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        static {
            $assertionsDisabled = !(class$org$geotools$referencing$operation$projection$Mercator == null ? (class$org$geotools$referencing$operation$projection$Mercator = Mercator.class$("org.geotools.referencing.operation.projection.Mercator")) : class$org$geotools$referencing$operation$projection$Mercator).desiredAssertionStatus();
        }
    }

    public static final class Provider2SP
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor STANDARD_PARALLEL = Provider2SP.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "standard_parallel_1"), new NamedIdentifier(CitationImpl.EPSG, "Latitude of 1st standard parallel"), new NamedIdentifier(CitationImpl.GEOTIFF, "StdParallel1")}, 0.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = Provider2SP.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Mercator_2SP"), new NamedIdentifier(CitationImpl.EPSG, "Mercator (2SP)"), new NamedIdentifier(CitationImpl.EPSG, "9805"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_Mercator"), new NamedIdentifier(CitationImpl.ESRI, "Mercator"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(10))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public Provider2SP() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = Mercator.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider2SP.isSpherical(parameters)) {
                return new Spherical(parameters, descriptors);
            }
            return new Mercator(parameters, descriptors);
        }
    }

    public static final class Provider1SP
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider1SP.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Mercator_1SP"), new NamedIdentifier(CitationImpl.EPSG, "Mercator (1SP)"), new NamedIdentifier(CitationImpl.EPSG, "9804"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_Mercator"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(10))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider1SP() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$CylindricalProjection == null ? (class$org$opengis$referencing$operation$CylindricalProjection = Mercator.class$("org.opengis.referencing.operation.CylindricalProjection")) : class$org$opengis$referencing$operation$CylindricalProjection;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            if (Provider1SP.isSpherical(parameters)) {
                return new Spherical(parameters, descriptors);
            }
            return new Mercator(parameters, descriptors);
        }
    }
}

