/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.OrthographicEquatorial;
import org.geotools.referencing.operation.projection.OrthographicOblique;
import org.geotools.referencing.operation.projection.OrthographicPolar;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;

public abstract class Orthographic
extends MapProjection {
    static /* synthetic */ Class class$org$opengis$referencing$operation$PlanarProjection;

    Orthographic(ParameterValueGroup parameters, Collection expected) throws ParameterNotFoundException {
        super(parameters, expected);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object);
    }

    public static final class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.OGC, "Orthographic"), new NamedIdentifier(CitationImpl.GEOTIFF, "CT_Orthographic"), new NamedIdentifier(CitationImpl.ESRI, "Orthographic"), new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(45))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$PlanarProjection == null ? (class$org$opengis$referencing$operation$PlanarProjection = Orthographic.class$("org.opengis.referencing.operation.PlanarProjection")) : class$org$opengis$referencing$operation$PlanarProjection;
        }

        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            List descriptors = PARAMETERS.descriptors();
            double latitudeOfOrigin = Math.abs(MapProjection.doubleValue(descriptors, LATITUDE_OF_ORIGIN, parameters));
            if (Provider.isSpherical(parameters)) {
                if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                    return new OrthographicPolar(parameters, descriptors);
                }
                if (latitudeOfOrigin < 1.0E-6) {
                    return new OrthographicEquatorial(parameters, descriptors);
                }
                return new OrthographicOblique(parameters, descriptors);
            }
            throw new UnsupportedOperationException(Resources.format(76));
        }
    }
}

