/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.vecmath.GMatrix;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.GeneralMatrix;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.resources.geometry.ShapeUtilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public abstract class AbstractMathTransform
extends Formattable
implements MathTransform {
    protected AbstractMathTransform() {
    }

    public final int getDimSource() {
        return this.getSourceDimensions();
    }

    public abstract int getSourceDimensions();

    public final int getDimTarget() {
        return this.getTargetDimensions();
    }

    public abstract int getTargetDimensions();

    public ParameterDescriptorGroup getParameterDescriptors() {
        return null;
    }

    public ParameterValueGroup getParameterValues() {
        return null;
    }

    public boolean isIdentity() {
        return false;
    }

    private static String constructMessage(String argument, int dimension, int expected) {
        return Resources.format(99, argument, new Integer(dimension), new Integer(expected));
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        int dim = this.getSourceDimensions();
        if (dim != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptSrc", 2, dim));
        }
        dim = this.getTargetDimensions();
        if (dim != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptDst", 2, dim));
        }
        double[] ord = new double[]{ptSrc.getX(), ptSrc.getY()};
        this.transform(ord, 0, ord, 0, 1);
        if (ptDst != null) {
            ptDst.setLocation(ord[0], ord[1]);
            return ptDst;
        }
        return new Point2D.Double(ord[0], ord[1]);
    }

    public DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) throws TransformException {
        int dimPoint = ptSrc.getDimension();
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        if (dimPoint != dimSource) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptSrc", dimPoint, dimSource));
        }
        if (ptDst != null) {
            int i;
            double[] array;
            dimPoint = ptDst.getDimension();
            if (dimPoint != dimTarget) {
                throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptDst", dimPoint, dimTarget));
            }
            if (dimSource >= dimTarget) {
                array = ptSrc.getCoordinates();
            } else {
                array = new double[dimTarget];
                i = dimSource;
                while (--i >= 0) {
                    array[i] = ptSrc.getOrdinate(i);
                }
            }
            this.transform(array, 0, array, 0, 1);
            i = dimTarget;
            while (--i >= 0) {
                ptDst.setOrdinate(i, array[i]);
            }
        } else {
            double[] source;
            GeneralDirectPosition destination = new GeneralDirectPosition(dimTarget);
            ptDst = destination;
            if (dimSource <= dimTarget) {
                source = destination.ordinates;
                int i = dimSource;
                while (--i >= 0) {
                    source[i] = ptSrc.getOrdinate(i);
                }
            } else {
                source = ptSrc.getCoordinates();
            }
            this.transform(source, 0, destination.ordinates, 0, 1);
        }
        return ptDst;
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        double[] tmpPts = new double[numPts * Math.max(dimSource, dimTarget)];
        int i = numPts * dimSource;
        while (--i >= 0) {
            tmpPts[i] = srcPts[srcOff + i];
        }
        this.transform(tmpPts, 0, tmpPts, 0, numPts);
        i = numPts * dimTarget;
        while (--i >= 0) {
            dstPts[dstOff + i] = (float)tmpPts[i];
        }
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        return this.isIdentity() ? shape : this.createTransformedShape(shape, null, null, 0);
    }

    final Shape createTransformedShape(Shape shape, AffineTransform preTr, AffineTransform postTr, int quadDir) throws TransformException {
        int dim = this.getSourceDimensions();
        if (dim != 2 || (dim = this.getTargetDimensions()) != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("shape", 2, dim));
        }
        PathIterator it = shape.getPathIterator(preTr);
        GeneralPath path = new GeneralPath(it.getWindingRule());
        Point2D.Float ctrl = new Point2D.Float();
        double[] buffer = new double[6];
        double ax = 0.0;
        double ay = 0.0;
        double px = 0.0;
        double py = 0.0;
        int indexCtrlPt = 0;
        int indexLastPt = 0;
        while (!it.isDone()) {
            block12: {
                switch (it.currentSegment(buffer)) {
                    default: {
                        throw new IllegalPathStateException();
                    }
                    case 4: {
                        path.closePath();
                        break block12;
                    }
                    case 0: {
                        ax = buffer[0];
                        ay = buffer[1];
                        this.transform(buffer, 0, buffer, 0, 1);
                        px = buffer[0];
                        py = buffer[1];
                        path.moveTo((float)px, (float)py);
                        break block12;
                    }
                    case 1: {
                        indexLastPt = 0;
                        indexCtrlPt = 2;
                        double d = ax;
                        ax = buffer[0];
                        buffer[2] = 0.5 * (d + ax);
                        double d2 = ay;
                        ay = buffer[1];
                        buffer[3] = 0.5 * (d2 + ay);
                        break;
                    }
                    case 2: {
                        indexLastPt = 2;
                        indexCtrlPt = 0;
                        double d = ax;
                        ax = buffer[2];
                        buffer[0] = 0.5 * (buffer[0] + 0.5 * (d + ax));
                        double d3 = ay;
                        ay = buffer[3];
                        buffer[1] = 0.5 * (buffer[1] + 0.5 * (d3 + ay));
                        break;
                    }
                    case 3: {
                        indexLastPt = 4;
                        indexCtrlPt = 0;
                        double d = ax;
                        ax = buffer[4];
                        buffer[0] = 0.25 * (1.5 * (buffer[0] + buffer[2]) + 0.5 * (d + ax));
                        double d4 = ay;
                        ay = buffer[5];
                        buffer[1] = 0.25 * (1.5 * (buffer[1] + buffer[3]) + 0.5 * (d4 + ay));
                    }
                }
                this.transform(buffer, 0, buffer, 0, 2);
                if (ShapeUtilities.parabolicControlPoint(px, py, buffer[indexCtrlPt], buffer[indexCtrlPt + 1], buffer[indexLastPt], buffer[indexLastPt + 1], quadDir, ctrl) != null) {
                    px = buffer[indexLastPt + 0];
                    py = buffer[indexLastPt + 1];
                    path.quadTo(ctrl.x, ctrl.y, (float)px, (float)py);
                } else {
                    px = buffer[indexLastPt + 0];
                    py = buffer[indexLastPt + 1];
                    path.lineTo((float)px, (float)py);
                }
            }
            it.next();
        }
        if (postTr != null) {
            path.transform(postTr);
        }
        return ShapeUtilities.toPrimitive(path);
    }

    public Matrix derivative(Point2D point) throws TransformException {
        int dimSource = this.getSourceDimensions();
        if (dimSource != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("point", 2, dimSource));
        }
        throw new TransformException(Resources.format(70));
    }

    public Matrix derivative(DirectPosition point) throws TransformException {
        int dimSource = this.getSourceDimensions();
        if (point == null) {
            if (dimSource == 2) {
                return this.derivative((Point2D)null);
            }
        } else {
            int dimPoint = point.getDimension();
            if (dimPoint != dimSource) {
                throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("point", dimPoint, dimSource));
            }
            if (dimSource == 2) {
                if (point instanceof Point2D) {
                    return this.derivative((Point2D)point);
                }
                return this.derivative(new Point2D.Double(point.getOrdinate(0), point.getOrdinate(1)));
            }
            if (this instanceof MathTransform1D) {
                return new GeneralMatrix(1, 1, new double[]{((MathTransform1D)this).derivative(point.getOrdinate(0))});
            }
        }
        throw new TransformException(Resources.format(70));
    }

    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        throw new NoninvertibleTransformException(Resources.format(102));
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        return null;
    }

    public int hashCode() {
        return this.getSourceDimensions() + 37 * this.getTargetDimensions();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            AbstractMathTransform that = (AbstractMathTransform)object;
            return Utilities.equals(this.getParameterDescriptors(), that.getParameterDescriptors());
        }
        return false;
    }

    protected String formatWKT(Formatter formatter) {
        ParameterValueGroup parameters = this.getParameterValues();
        if (parameters != null) {
            formatter.append(formatter.getName((IdentifiedObject)parameters.getDescriptor()));
            formatter.append((GeneralParameterValue)parameters);
        }
        return "PARAM_MT";
    }

    protected static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new InvalidParameterValueException(Resources.format(115, name), name, object);
        }
    }

    protected static boolean needCopy(int srcOff, int dimSource, int dstOff, int dimTarget, int numPts) {
        if (numPts <= 1 || srcOff >= dstOff && dimSource >= dimTarget) {
            return false;
        }
        return srcOff < dstOff + numPts * dimTarget && dstOff < srcOff + numPts * dimSource;
    }

    protected static double rollLongitude(double x) {
        return x - Math.PI * 2 * Math.floor(x / (Math.PI * 2) + 0.5);
    }

    static GeneralMatrix wrap(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return (GeneralMatrix)matrix;
        }
        return new GeneralMatrix(matrix);
    }

    static Matrix invert(Matrix matrix) throws NoninvertibleTransformException {
        try {
            ((GMatrix)matrix).invert();
            return matrix;
        }
        catch (RuntimeException exception) {
            NoninvertibleTransformException e = new NoninvertibleTransformException(Resources.format(102));
            e.initCause((Throwable)exception);
            throw e;
        }
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = 3528274816628012283L;

        protected Inverse() {
        }

        public int getSourceDimensions() {
            return AbstractMathTransform.this.getTargetDimensions();
        }

        public int getTargetDimensions() {
            return AbstractMathTransform.this.getSourceDimensions();
        }

        public Matrix derivative(Point2D point) throws TransformException {
            return Inverse.invert(AbstractMathTransform.this.derivative(this.transform(point, null)));
        }

        public Matrix derivative(DirectPosition point) throws TransformException {
            return Inverse.invert(AbstractMathTransform.this.derivative(this.transform(point, null)));
        }

        public final MathTransform inverse() {
            return AbstractMathTransform.this;
        }

        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        public int hashCode() {
            return ~AbstractMathTransform.this.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Inverse) {
                Inverse that = (Inverse)object;
                return Utilities.equals(this.inverse(), that.inverse());
            }
            return false;
        }

        protected String formatWKT(Formatter formatter) {
            ParameterValueGroup parameters = this.getParameterValues();
            if (parameters != null) {
                formatter.append(formatter.getName((IdentifiedObject)parameters.getDescriptor()));
                formatter.append((GeneralParameterValue)parameters);
                return "PARAM_MT";
            }
            formatter.append(AbstractMathTransform.this);
            return "INVERSE_MT";
        }
    }
}

