/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import javax.units.Unit;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ExponentialTransform1D;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.cts.Resources;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;

public class LogarithmicTransform1D
extends AbstractMathTransform
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = 1535101265352133948L;
    public final double base;
    final double lnBase;
    public final double offset;
    private MathTransform inverse;
    static /* synthetic */ Class class$org$opengis$referencing$operation$Conversion;

    LogarithmicTransform1D(ExponentialTransform1D inverse) {
        this.base = inverse.base;
        this.lnBase = inverse.lnBase;
        this.offset = -Math.log(inverse.scale) / this.lnBase;
        this.inverse = inverse;
    }

    protected LogarithmicTransform1D(double base, double offset) {
        this.base = base;
        this.offset = offset;
        this.lnBase = Math.log(base);
    }

    public static MathTransform1D create(double base, double offset) {
        if (base == Double.POSITIVE_INFINITY || base == 0.0) {
            return LinearTransform1D.create(0.0, offset);
        }
        return new LogarithmicTransform1D(base, offset);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])new ParameterValue[]{new FloatParameter(Provider.BASE, this.base), new FloatParameter(Provider.OFFSET, this.offset)});
    }

    public int getSourceDimensions() {
        return 1;
    }

    public int getTargetDimensions() {
        return 1;
    }

    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new ExponentialTransform1D(this);
        }
        return this.inverse;
    }

    public double derivative(double value) {
        return 1.0 / (this.lnBase * value);
    }

    public double transform(double value) {
        return Math.log(value) / this.lnBase + this.offset;
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(Math.log(srcPts[srcOff++]) / this.lnBase + this.offset);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(Math.log(srcPts[srcOff++]) / this.lnBase + this.offset);
            }
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = Math.log(srcPts[srcOff++]) / this.lnBase + this.offset;
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = Math.log(srcPts[srcOff++]) / this.lnBase + this.offset;
            }
        }
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        if (other instanceof LinearTransform) {
            LinearTransform1D linear = (LinearTransform1D)other;
            if (applyOtherFirst) {
                if (linear.offset == 0.0 && linear.scale > 0.0) {
                    return LogarithmicTransform1D.create(this.base, Math.log(linear.scale) / this.lnBase + this.offset);
                }
            } else {
                double newBase = Math.pow(this.base, 1.0 / linear.scale);
                if (!Double.isNaN(newBase)) {
                    return LogarithmicTransform1D.create(newBase, linear.scale * this.offset + linear.offset);
                }
            }
        } else if (other instanceof ExponentialTransform1D) {
            return ((ExponentialTransform1D)other).concatenateLog(this, !applyOtherFirst);
        }
        return super.concatenate(other, applyOtherFirst);
    }

    public int hashCode() {
        long code = 1535101265352133948L + Double.doubleToLongBits(this.base);
        code = code * 37L + Double.doubleToLongBits(this.offset);
        return (int)(code >>> 32) ^ (int)code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LogarithmicTransform1D that = (LogarithmicTransform1D)object;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(that.base) && Double.doubleToLongBits(this.offset) == Double.doubleToLongBits(that.offset);
        }
        return false;
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -7235097164208708484L;
        public static final ParameterDescriptor BASE = new DefaultParameterDescriptor("base", 10.0, 0.0, Double.POSITIVE_INFINITY, Unit.ONE);
        public static final ParameterDescriptor OFFSET = new DefaultParameterDescriptor("offset", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Unit.ONE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(CitationImpl.GEOTOOLS, Resources.formatInternational(38))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{BASE, OFFSET});

        public Provider() {
            super(1, 1, PARAMETERS);
        }

        protected Class getOperationType() {
            return class$org$opengis$referencing$operation$Conversion == null ? (class$org$opengis$referencing$operation$Conversion = LogarithmicTransform1D.class$("org.opengis.referencing.operation.Conversion")) : class$org$opengis$referencing$operation$Conversion;
        }

        public MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            return LogarithmicTransform1D.create(Provider.doubleValue(BASE, values), Provider.doubleValue(OFFSET, values));
        }
    }
}

