/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.media.jai.util.Range;
import org.geotools.feature.Feature;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.LabelCacheItem;
import org.geotools.renderer.lite.LiteShape2;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.TextSymbolizer;

public class LabelCacheDefault
implements LabelCache {
    protected Map labelCache = new HashMap();
    protected SLDStyleFactory styleFactory = new SLDStyleFactory();
    boolean stop = false;

    public void stop() {
        this.stop = true;
    }

    public void start() {
        this.stop = false;
    }

    public void startLayer() {
    }

    public void put(TextSymbolizer symbolizer, Feature feature, LiteShape2 shape, Range scaleRange) {
        try {
            TextStyle2D textStyle = (TextStyle2D)this.styleFactory.createStyle(feature, symbolizer, scaleRange);
            if (!this.labelCache.containsKey(textStyle.getLabel())) {
                this.labelCache.put(textStyle.getLabel(), new LabelCacheItem(textStyle, shape));
            } else {
                LabelCacheItem item = (LabelCacheItem)this.labelCache.get(textStyle.getLabel());
                item.getGeoms().add(shape.getGeometry());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void endLayer(Graphics2D graphics, Rectangle displayArea) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Graphics2D graphics, Rectangle displayArea) {
        ArrayList<Rectangle> glyphs = new ArrayList<Rectangle>();
        Iterator labelIter = this.labelCache.keySet().iterator();
        while (labelIter.hasNext()) {
            if (this.stop) {
                return;
            }
            try {
                LabelCacheItem labelItem = (LabelCacheItem)this.labelCache.get(labelIter.next());
                GeometryFactory factory = new GeometryFactory();
                Geometry displayGeom = factory.toGeometry(new Envelope(displayArea.getMinX(), displayArea.getMaxX(), displayArea.getMinY(), displayArea.getMaxY()));
                AffineTransform oldTransform = graphics.getTransform();
                AffineTransform tempTransform = new AffineTransform(oldTransform);
                GlyphVector glyphVector = labelItem.getTextStyle().getTextGlyphVector(graphics);
                if (labelItem.getGeometry() instanceof Point || labelItem.getGeometry() instanceof MultiPoint) {
                    this.paintPointLabel(glyphVector, labelItem, tempTransform, displayGeom);
                }
                if (labelItem.getGeometry() instanceof LineString && !(labelItem.getGeometry() instanceof LinearRing) || labelItem.getGeometry() instanceof MultiLineString) {
                    this.paintLineLabel(glyphVector, labelItem, tempTransform, displayGeom);
                }
                if (labelItem.getGeometry() instanceof Polygon || labelItem.getGeometry() instanceof MultiPolygon || labelItem.getGeometry() instanceof LinearRing) {
                    this.paintPolygonLabel(glyphVector, labelItem, tempTransform, displayGeom);
                }
                if (this.overlappingItems(glyphVector, tempTransform, glyphs)) continue;
                try {
                    graphics.setTransform(tempTransform);
                    if (labelItem.getTextStyle().getHaloFill() != null) {
                        graphics.setPaint(labelItem.getTextStyle().getHaloFill());
                        graphics.setComposite(labelItem.getTextStyle().getHaloComposite());
                        graphics.fill(labelItem.getTextStyle().getHaloShape(graphics));
                    }
                    Paint fill = labelItem.getTextStyle().getFill();
                    Composite comp = labelItem.getTextStyle().getComposite();
                    if (fill == null) {
                        fill = Color.BLACK;
                        comp = AlphaComposite.getInstance(3, 1.0f);
                    }
                    if (fill == null) continue;
                    graphics.setPaint(fill);
                    graphics.setComposite(comp);
                    graphics.drawGlyphVector(glyphVector, 0.0f, 0.0f);
                    glyphs.add(glyphVector.getPixelBounds(new FontRenderContext(tempTransform, true, false), 0.0f, 0.0f));
                }
                finally {
                    graphics.setTransform(oldTransform);
                }
            }
            catch (Exception e) {}
        }
        this.labelCache.clear();
    }

    private boolean overlappingItems(GlyphVector glyphVector, AffineTransform tempTransform, List glyphs) {
        Iterator iter = glyphs.iterator();
        while (iter.hasNext()) {
            Rectangle oldBounds = (Rectangle)iter.next();
            if (!oldBounds.intersects(glyphVector.getPixelBounds(new FontRenderContext(tempTransform, true, false), 0.0f, 0.0f))) continue;
            return true;
        }
        return false;
    }

    private void paintLineLabel(GlyphVector glyphVector, LabelCacheItem labelItem, AffineTransform tempTransform, Geometry displayGeom) {
        LineString line = this.getLineSetRepresentativeLocation(labelItem.getGeoms(), displayGeom);
        if (line == null) {
            return;
        }
        TextStyle2D textStyle = labelItem.getTextStyle();
        this.paintLineStringLabel(glyphVector, line, textStyle, tempTransform);
    }

    private void paintLineStringLabel(GlyphVector glyphVector, LineString line, TextStyle2D textStyle, AffineTransform tempTransform) {
        double theta;
        Point start = line.getStartPoint();
        Point end = line.getEndPoint();
        double dx = end.getX() - start.getX();
        double dy = end.getY() - start.getY();
        double slope = dy / dx;
        double rotation = theta = Math.atan(slope);
        Rectangle2D textBounds = glyphVector.getVisualBounds();
        Point centroid = this.middleLine(line, 0.5);
        tempTransform.translate(centroid.getX(), centroid.getY());
        double displacementX = 0.0;
        double displacementY = 0.0;
        if (textStyle.isAbsoluteLineDisplacement()) {
            double offset = textStyle.getDisplacementY();
            displacementY = offset > 0.0 ? -offset : (offset < 0.0 ? -offset + textBounds.getHeight() : textBounds.getHeight() / 2.0);
            displacementX = -textBounds.getWidth() / 2.0;
        } else {
            displacementX = textStyle.getAnchorX() + -textBounds.getWidth() / 2.0 + textStyle.getDisplacementX();
            displacementY = textStyle.getAnchorY() + textBounds.getHeight() / 2.0 + textStyle.getDisplacementY();
        }
        tempTransform.rotate(rotation);
        tempTransform.translate(displacementX, displacementY);
    }

    private void paintPointLabel(GlyphVector glyphVector, LabelCacheItem labelItem, AffineTransform tempTransform, Geometry displayGeom) {
        Point point = this.getPointSetRepresentativeLocation(labelItem.getGeoms(), displayGeom);
        if (point == null) {
            return;
        }
        TextStyle2D textStyle = labelItem.getTextStyle();
        Rectangle2D textBounds = glyphVector.getVisualBounds();
        tempTransform.translate(point.getX(), point.getY());
        double displacementX = 0.0;
        double displacementY = 0.0;
        if (textStyle.isAbsoluteLineDisplacement()) {
            double offset = textStyle.getDisplacementY();
            displacementY = offset > 0.0 ? -offset : (offset < 0.0 ? -offset + textBounds.getHeight() : textBounds.getHeight() / 2.0);
            displacementX = -textBounds.getWidth() / 2.0;
        } else {
            displacementX = textStyle.getAnchorX() * -textBounds.getWidth() + textStyle.getDisplacementX();
            displacementY = textStyle.getAnchorY() * textBounds.getHeight() + textStyle.getDisplacementY();
        }
        tempTransform.rotate(textStyle.getRotation());
        tempTransform.translate(displacementX, displacementY);
    }

    private void paintPolygonLabel(GlyphVector glyphVector, LabelCacheItem labelItem, AffineTransform tempTransform, Geometry displayGeom) {
        Point centroid;
        Polygon geom = this.getPolySetRepresentativeLocation(labelItem.getGeoms(), displayGeom);
        if (geom == null) {
            return;
        }
        try {
            centroid = geom.getCentroid();
        }
        catch (Exception e) {
            try {
                centroid = geom.getExteriorRing().getCentroid();
            }
            catch (Exception ee) {
                try {
                    centroid = geom.getFactory().createPoint(geom.getCoordinate());
                }
                catch (Exception eee) {
                    return;
                }
            }
        }
        TextStyle2D textStyle = labelItem.getTextStyle();
        Rectangle2D textBounds = glyphVector.getVisualBounds();
        tempTransform.translate(centroid.getX(), centroid.getY());
        double displacementX = 0.0;
        double displacementY = 0.0;
        if (textStyle.isAbsoluteLineDisplacement()) {
            double offset = textStyle.getDisplacementY();
            displacementY = offset > 0.0 ? -offset : (offset < 0.0 ? -offset + textBounds.getHeight() : textBounds.getHeight() / 2.0);
            displacementX = -textBounds.getWidth() / 2.0;
        } else {
            displacementX = textStyle.getAnchorX() + -textBounds.getWidth() / 2.0 + textStyle.getDisplacementX();
            displacementY = textStyle.getAnchorY() + textBounds.getHeight() / 2.0 + textStyle.getDisplacementY();
        }
        tempTransform.rotate(textStyle.getRotation());
        tempTransform.translate(displacementX, displacementY);
    }

    Point getPointSetRepresentativeLocation(List geoms, Geometry displayGeometry) {
        ArrayList<Object> pts = new ArrayList<Object>();
        Iterator it = geoms.iterator();
        while (it.hasNext()) {
            Geometry g = (Geometry)it.next();
            if (!(g instanceof Point) && !(g instanceof MultiPoint)) {
                g = g.getCentroid();
            }
            if (g instanceof Point) {
                if (!displayGeometry.intersects(g)) continue;
                pts.add(g);
                continue;
            }
            if (!(g instanceof MultiPoint)) continue;
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Point gg = (Point)g.getGeometryN(t);
                if (!displayGeometry.intersects((Geometry)gg)) continue;
                pts.add(gg);
            }
        }
        if (pts.size() == 0) {
            return null;
        }
        return (Point)pts.get(0);
    }

    LineString getLineSetRepresentativeLocation(List geoms, Geometry displayGeometry) {
        ArrayList<Object> lines = new ArrayList<Object>();
        Iterator it = geoms.iterator();
        while (it.hasNext()) {
            Geometry g = (Geometry)it.next();
            if (!(g instanceof LineString) && !(g instanceof MultiLineString) && !(g instanceof Polygon) && !(g instanceof MultiPolygon) || (g instanceof Polygon || g instanceof MultiPolygon) && !((g = g.getBoundary()) instanceof LineString) && !(g instanceof MultiLineString)) continue;
            if (g instanceof LineString) {
                lines.add(g);
                continue;
            }
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                LineString gg = (LineString)g.getGeometryN(t);
                lines.add(gg);
            }
        }
        if (lines.size() == 0) {
            return null;
        }
        Collection merged = this.mergeLines(lines);
        ArrayList<Geometry> clippedLines = new ArrayList<Geometry>();
        it = merged.iterator();
        while (it.hasNext()) {
            LineString l = (LineString)it.next();
            MultiLineString ll = this.clipLineString(l, (Polygon)displayGeometry);
            if (ll == null || ll.isEmpty()) continue;
            for (int t = 0; t < ll.getNumGeometries(); ++t) {
                clippedLines.add(ll.getGeometryN(t));
            }
        }
        if (clippedLines.size() == 0) {
            return null;
        }
        double maxLen = -1.0;
        LineString maxLine = null;
        for (int t = 0; t < clippedLines.size(); ++t) {
            LineString cline = (LineString)clippedLines.get(t);
            if (!(cline.getLength() > maxLen)) continue;
            maxLine = cline;
            maxLen = cline.getLength();
        }
        return maxLine;
    }

    public MultiLineString clipLineString(LineString line, Polygon bbox) {
        LineString clip = line;
        try {
            clip = EnhancedPrecisionOp.intersection((Geometry)line, (Geometry)bbox);
        }
        catch (Exception e) {
            clip = line;
        }
        if (clip instanceof MultiLineString) {
            return (MultiLineString)clip;
        }
        if (clip instanceof LineString) {
            LineString[] lns = new LineString[]{clip};
            return line.getFactory().createMultiLineString(lns);
        }
        if (clip instanceof Point) {
            return null;
        }
        if (clip instanceof MultiPoint) {
            return null;
        }
        GeometryCollection gc = (GeometryCollection)clip;
        ArrayList<Geometry> lns = new ArrayList<Geometry>();
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry g = gc.getGeometryN(t);
            if (!(g instanceof LineString)) continue;
            lns.add(g);
        }
        if (lns.size() == 0) {
            return null;
        }
        return line.getFactory().createMultiLineString(lns.toArray(new LineString[1]));
    }

    Polygon getPolySetRepresentativeLocation(List geoms, Geometry displayGeometry) {
        ArrayList<Object> polys = new ArrayList<Object>();
        Iterator it = geoms.iterator();
        while (it.hasNext()) {
            Geometry g = (Geometry)it.next();
            if (!(g instanceof Polygon) && !(g instanceof MultiPolygon)) continue;
            if (g instanceof Polygon) {
                polys.add(g);
                continue;
            }
            for (int t = 0; t < g.getNumGeometries(); ++t) {
                Polygon gg = (Polygon)g.getGeometryN(t);
                polys.add(gg);
            }
        }
        if (polys.size() == 0) {
            return null;
        }
        ArrayList<Geometry> clippedPolys = new ArrayList<Geometry>();
        it = polys.iterator();
        while (it.hasNext()) {
            Polygon p = (Polygon)it.next();
            MultiPolygon pp = this.clipPolygon(p, (Polygon)displayGeometry);
            if (pp == null || pp.isEmpty()) continue;
            for (int t = 0; t < pp.getNumGeometries(); ++t) {
                clippedPolys.add(pp.getGeometryN(t));
            }
        }
        if (clippedPolys.size() == 0) {
            return null;
        }
        double maxSize = -1.0;
        Polygon maxPoly = null;
        for (int t = 0; t < clippedPolys.size(); ++t) {
            Polygon cpoly = (Polygon)clippedPolys.get(t);
            if (!(cpoly.getArea() > maxSize)) continue;
            maxPoly = cpoly;
            maxSize = cpoly.getArea();
        }
        return maxPoly;
    }

    public MultiPolygon clipPolygon(Polygon poly, Polygon bbox) {
        Polygon clip = poly;
        try {
            clip = EnhancedPrecisionOp.intersection((Geometry)poly, (Geometry)bbox);
        }
        catch (Exception e) {
            clip = poly;
        }
        if (clip instanceof MultiPolygon) {
            return (MultiPolygon)clip;
        }
        if (clip instanceof Polygon) {
            Polygon[] polys = new Polygon[]{clip};
            return poly.getFactory().createMultiPolygon(polys);
        }
        if (clip instanceof Point) {
            return null;
        }
        if (clip instanceof MultiPoint) {
            return null;
        }
        if (clip instanceof LineString) {
            return null;
        }
        if (clip instanceof MultiLineString) {
            return null;
        }
        GeometryCollection gc = (GeometryCollection)clip;
        ArrayList<Geometry> plys = new ArrayList<Geometry>();
        for (int t = 0; t < gc.getNumGeometries(); ++t) {
            Geometry g = gc.getGeometryN(t);
            if (!(g instanceof Polygon)) continue;
            plys.add(g);
        }
        if (plys.size() == 0) {
            return null;
        }
        return poly.getFactory().createMultiPolygon(plys.toArray(new Polygon[1]));
    }

    Point middleLine(LineString l, double percent) {
        if (percent >= 1.0) {
            percent = 0.99;
        }
        if (percent <= 0.0) {
            percent = 0.01;
        }
        double len = l.getLength();
        double dist = percent * len;
        double running_sum_dist = 0.0;
        Coordinate[] pts = l.getCoordinates();
        for (int i = 0; i < pts.length - 1; ++i) {
            double segmentLen = pts[i].distance(pts[i + 1]);
            if (running_sum_dist + segmentLen >= dist) {
                double r = (dist - running_sum_dist) / segmentLen;
                Coordinate c = new Coordinate(pts[i].x + (pts[i + 1].x - pts[i].x) * r, pts[i].y + (pts[i + 1].y - pts[i].y) * r);
                return l.getFactory().createPoint(c);
            }
            running_sum_dist += segmentLen;
        }
        return l.getEndPoint();
    }

    Collection mergeLines(Collection lines) {
        LineMerger lm = new LineMerger();
        lm.add(lines);
        Collection merged = lm.getMergedLineStrings();
        if (merged.size() == 0) {
            return null;
        }
        if (merged.size() == 1) {
            return merged;
        }
        ArrayList mylines = new ArrayList(merged);
        boolean keep_going = true;
        while (keep_going) {
            keep_going = false;
            Collections.sort(mylines, new LineLengthComparator());
            for (int t = 0; t < mylines.size(); ++t) {
                LineString major = (LineString)mylines.get(t);
                if (major == null) continue;
                for (int i = t + 1; i < mylines.size(); ++i) {
                    LineString merge;
                    LineString minor = (LineString)mylines.get(i);
                    if (minor == null || (merge = this.merge(major, minor)) == null) continue;
                    keep_going = true;
                    mylines.set(i, null);
                    mylines.set(t, merge);
                    major = merge;
                }
            }
            mylines = this.removeNulls(mylines);
        }
        return this.removeNulls(mylines);
    }

    ArrayList removeNulls(List l) {
        ArrayList al = new ArrayList();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null) continue;
            al.add(o);
        }
        return al;
    }

    LineString reverse(LineString l) {
        List<Coordinate> clist = Arrays.asList(l.getCoordinates());
        Collections.reverse(clist);
        return l.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    LineString merge(LineString major, LineString minor) {
        Coordinate major_s = major.getCoordinateN(0);
        Coordinate major_e = major.getCoordinateN(major.getNumPoints() - 1);
        Coordinate minor_s = minor.getCoordinateN(0);
        Coordinate minor_e = minor.getCoordinateN(minor.getNumPoints() - 1);
        if (major_s.equals2D(minor_s)) {
            return this.mergeSimple(this.reverse(minor), major);
        }
        if (major_s.equals2D(minor_e)) {
            return this.mergeSimple(minor, major);
        }
        if (major_e.equals2D(minor_s)) {
            return this.mergeSimple(major, minor);
        }
        if (major_e.equals2D(minor_e)) {
            return this.mergeSimple(major, this.reverse(minor));
        }
        return null;
    }

    private LineString mergeSimple(LineString l1, LineString l2) {
        ArrayList<Coordinate> clist = new ArrayList<Coordinate>(Arrays.asList(l1.getCoordinates()));
        clist.addAll(Arrays.asList(l2.getCoordinates()));
        return l1.getFactory().createLineString(clist.toArray(new Coordinate[1]));
    }

    private class LineLengthComparator
    implements Comparator {
        private LineLengthComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Double.compare(((LineString)o2).getLength(), ((LineString)o1).getLength());
        }
    }
}

