/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterTransformer;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.Displacement;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SLDTransformer
extends TransformerBase {
    static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    static /* synthetic */ Class class$org$geotools$styling$StyleVisitor;

    public Translator createTranslator(ContentHandler handler) {
        return new SLDTranslator(handler);
    }

    public static final void main(String[] args) throws Exception {
        URL url = new File(args[0]).toURL();
        SLDParser s = new SLDParser(StyleFactory.createStyleFactory(), url);
        SLDTransformer transformer = new SLDTransformer();
        transformer.setIndentation(4);
        transformer.transform((Object)s.readXML(), new FileOutputStream(System.getProperty("java.io.tmpdir") + "/junk.eraseme"));
    }

    static class SLDTranslator
    extends TransformerBase.TranslatorSupport
    implements StyleVisitor {
        FilterTransformer.FilterTranslator filterTranslator;

        public SLDTranslator(ContentHandler handler) {
            super(handler, "sld", "http://www.opengis.net/sld");
            this.filterTranslator = new FilterTransformer.FilterTranslator(handler);
            this.addNamespaceDeclarations(this.filterTranslator);
        }

        void element(String element, Expression e) {
            this.start(element);
            this.filterTranslator.encode(e);
            this.end(element);
        }

        void element(String element, Filter f) {
            this.start(element);
            this.filterTranslator.encode(f);
            this.end(element);
        }

        public void visit(PointPlacement pp) {
            this.start("LabelPlacement");
            this.start("PointPlacement");
            pp.getAnchorPoint().accept(this);
            pp.getDisplacement().accept(this);
            this.element("Rotation", pp.getRotation());
            this.end("PointPlacement");
            this.end("LabelPlacement");
        }

        public void visit(Stroke stroke) {
            this.start("Stroke");
            if (stroke.getGraphicFill() != null) {
                stroke.getGraphicFill().accept(this);
            }
            if (stroke.getGraphicStroke() != null) {
                stroke.getGraphicStroke().accept(this);
            }
            this.encodeCssParam("stroke", stroke.getColor());
            this.encodeCssParam("stroke-linecap", stroke.getLineCap());
            this.encodeCssParam("stroke-linejoin", stroke.getLineJoin());
            this.encodeCssParam("stroke-opacity", stroke.getOpacity());
            this.encodeCssParam("stroke-width", stroke.getWidth());
            this.encodeCssParam("stroke-dashoffset", stroke.getDashOffset());
            float[] dash = stroke.getDashArray();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dash.length; ++i) {
                sb.append(dash[i] + " ");
            }
            this.encodeCssParam("stroke-dasharray", sb.toString());
            this.end("Stroke");
        }

        public void visit(LinePlacement lp) {
            this.start("LabelPlacement");
            this.start("LinePlacement");
            this.element("PerpendicularOffset", lp.getPerpendicularOffset());
            this.end("LinePlacement");
            this.end("LabelPlacement");
        }

        public void visit(AnchorPoint ap) {
            this.start("AnchorPoint");
            this.element("AnchorPointX", ap.getAnchorPointX());
            this.element("AnchorPointY", ap.getAnchorPointY());
            this.end("AnchorPoint");
        }

        public void visit(TextSymbolizer text) {
            if (text == null) {
                return;
            }
            this.start("TextSymbolizer");
            if (text.getGeometryPropertyName() != null) {
                this.encodeGeometryProperty(text.getGeometryPropertyName());
            }
            if (text.getLabel() != null) {
                this.element("Label", text.getLabel());
            }
            if (text.getFonts() != null && text.getFonts().length != 0) {
                this.start("Font");
                Font[] fonts = text.getFonts();
                for (int i = 0; i < fonts.length; ++i) {
                    this.encodeCssParam("font-family", fonts[i].getFontFamily());
                }
                this.encodeCssParam("font-size", fonts[0].getFontSize());
                this.encodeCssParam("font-style", fonts[0].getFontStyle());
                this.encodeCssParam("font-weight", fonts[0].getFontWeight());
                this.end("Font");
            }
            if (text.getLabelPlacement() != null) {
                this.start("LabelPlacement");
                text.getLabelPlacement().accept(this);
                this.end("LabelPlacement");
            }
            if (text.getHalo() != null) {
                text.getHalo().accept(this);
            }
            if (text.getFill() != null) {
                text.getFill().accept(this);
            }
            this.end("TextSymbolizer");
        }

        public void visit(RasterSymbolizer raster) {
            if (raster == null) {
                return;
            }
            this.start("RasterSymbolizer");
            if (raster.getGeometryPropertyName() != null) {
                this.encodeGeometryProperty(raster.getGeometryPropertyName());
            }
            if (raster.getOpacity() != null) {
                this.start("Opacity");
                this.filterTranslator.encode(raster.getOpacity());
                this.end("Opacity");
            }
            if (raster.getOverlap() != null) {
                this.start("OverlapBehavior");
                this.filterTranslator.encode(raster.getOverlap());
                this.end("OverlapBehavior");
            }
            if (raster.getColorMap() != null) {
                // empty if block
            }
            this.end("RasterSymbolizer");
        }

        public void visit(Symbolizer sym) {
            try {
                this.contentHandler.startElement("", "!--", "!--", this.NULL_ATTS);
                this.chars("Unidentified Symbolizer " + sym.getClass());
                this.contentHandler.endElement("", "--", "--");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void visit(PolygonSymbolizer poly) {
            this.start("PolygonSymbolizer");
            this.encodeGeometryProperty(poly.getGeometryPropertyName());
            if (poly.getFill() != null) {
                poly.getFill().accept(this);
            }
            if (poly.getStroke() != null) {
                poly.getStroke().accept(this);
            }
            this.end("PolygonSymbolizer");
        }

        public void visit(ExternalGraphic exgr) {
            this.start("ExternalGraphic");
            this.element("Format", exgr.getFormat());
            AttributesImpl atts = new AttributesImpl();
            try {
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "type", "type", "", "simple");
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "xlink", "xlink", "", exgr.getLocation().toString());
            }
            catch (MalformedURLException murle) {
                throw new Error("SOMEONE CODED THE X LINK NAMESPACE WRONG!!");
            }
            this.element("OnlineResource", null, atts);
            this.end("ExternalGraphic");
        }

        public void visit(LineSymbolizer line) {
            this.start("LineSymbolizer");
            this.encodeGeometryProperty(line.getGeometryPropertyName());
            line.getStroke().accept(this);
            this.end("LineSymbolizer");
        }

        public void visit(Fill fill) {
            this.start("Fill");
            if (fill.getGraphicFill() != null) {
                fill.getGraphicFill().accept(this);
            }
            this.encodeCssParam("fill", fill.getColor());
            this.encodeCssParam("fill-opacity", fill.getOpacity());
            this.end("Fill");
        }

        public void visit(Rule rule) {
            this.start("Rule");
            this.element("Name", rule.getName());
            this.element("Abstract", rule.getAbstract());
            this.element("Title", rule.getTitle());
            if (rule.getMaxScaleDenominator() != Double.POSITIVE_INFINITY) {
                this.element("MaxScaleDenominator", rule.getMaxScaleDenominator() + "");
            }
            if (rule.getMinScaleDenominator() != 0.0) {
                this.element("MinScaleDenominator", rule.getMinScaleDenominator() + "");
            }
            if (rule.getFilter() != null) {
                this.filterTranslator.encode(rule.getFilter());
            }
            if (rule.hasElseFilter()) {
                this.start("ElseFilter");
                this.end("ElseFilter");
            }
            Graphic[] gr = rule.getLegendGraphic();
            for (int i = 0; i < gr.length; ++i) {
                gr[i].accept(this);
            }
            Symbolizer[] sym = rule.getSymbolizers();
            for (int i = 0; i < sym.length; ++i) {
                sym[i].accept(this);
            }
            this.end("Rule");
        }

        public void visit(Mark mark) {
            this.start("Mark");
            this.start("WellKnownName");
            this.filterTranslator.encode(mark.getWellKnownName());
            this.end("WellKnownName");
            if (mark.getFill() != null) {
                mark.getFill().accept(this);
            }
            if (mark.getStroke() != null) {
                mark.getStroke().accept(this);
            }
            this.end("Mark");
        }

        public void visit(PointSymbolizer ps) {
            this.start("PointSymbolizer");
            this.encodeGeometryProperty(ps.getGeometryPropertyName());
            ps.getGraphic().accept(this);
            this.end("PointSymbolizer");
        }

        public void visit(Halo halo) {
            this.start("Halo");
            halo.getFill().accept(this);
            this.start("Radius");
            this.filterTranslator.encode(halo.getRadius());
            this.end("Radius");
            this.end("Halo");
        }

        public void visit(Graphic gr) {
            this.start("Graphic");
            this.encodeGeometryProperty(gr.getGeometryPropertyName());
            this.element("Size", gr.getSize());
            this.element("Opacity", gr.getOpacity());
            this.element("Rotation", gr.getRotation());
            Symbol[] symbols = gr.getSymbols();
            for (int i = 0; i < symbols.length; ++i) {
                symbols[i].accept(this);
            }
            this.end("Graphic");
        }

        public void visit(Style style) {
            this.start("NamedLayer");
            this.start("UserStyle");
            this.element("Name", style.getName());
            this.element("Title", style.getTitle());
            this.element("Abstract", style.getAbstract());
            FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
            for (int i = 0; i < fts.length; ++i) {
                this.visit(fts[i]);
            }
            this.end("UserStyle");
            this.end("NamedLayer");
        }

        public void visit(FeatureTypeStyle fts) {
            this.start("FeatureTypeStyle");
            if (fts.getName() != null) {
                this.element("FeatureTypeName", fts.getFeatureTypeName());
            }
            Rule[] rules = fts.getRules();
            for (int i = 0; i < rules.length; ++i) {
                rules[i].accept(this);
            }
            this.end("FeatureTypeStyle");
        }

        public void visit(Displacement dis) {
            this.start("Displacement");
            this.element("DisplacementX", dis.getDisplacementX());
            this.element("DisplacementY", dis.getDisplacementY());
            this.end("Displacement");
        }

        void encodeGeometryProperty(String name) {
            if (name == null || name.trim().length() == 0) {
                return;
            }
            this.start("Geometry");
            this.element("PropertyName", name);
            this.end("Geometry");
        }

        void encodeCssParam(String name, Expression expression) {
            if (expression == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name);
            this.start("CssParameter", atts);
            this.filterTranslator.encode(expression);
            this.end("CssParameter");
        }

        void encodeCssParam(String name, String expression) {
            if (expression.length() == 0) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name);
            this.start("CssParameter", atts);
            this.chars(expression);
            this.end("CssParameter");
        }

        public void encode(Style[] styles) {
            try {
                this.contentHandler.startDocument();
                this.start("StyledLayerDescriptor", this.NULL_ATTS);
                int ii = styles.length;
                for (int i = 0; i < ii; ++i) {
                    styles[i].accept(this);
                }
                this.end("StyledLayerDescriptor");
                this.contentHandler.endDocument();
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (o instanceof Style[]) {
                this.encode((Style[])o);
            } else {
                Class<?> c = o.getClass();
                try {
                    Method m = c.getMethod("accept", class$org$geotools$styling$StyleVisitor == null ? (class$org$geotools$styling$StyleVisitor = SLDTransformer.class$("org.geotools.styling.StyleVisitor")) : class$org$geotools$styling$StyleVisitor);
                    m.invoke(o, this);
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalArgumentException("Cannot encode " + o);
                }
                catch (Exception e) {
                    throw new RuntimeException("Internal transformation exception", e);
                }
            }
        }
    }
}

