/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.xml.XMLElementHandler;
import org.geotools.xml.handlers.DocumentHandler;
import org.geotools.xml.handlers.ElementHandlerFactory;
import org.geotools.xml.handlers.IgnoreHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSAXHandler
extends DefaultHandler {
    protected static final Logger logger = Logger.getLogger("net.refractions.xml.sax");
    protected static Level level = Level.WARNING;
    private Stack handlers = new Stack();
    private Map hints;
    private ElementHandlerFactory ehf = new ElementHandlerFactory(logger);
    private Map schemaProxy = new HashMap();
    private DocumentHandler document = null;
    private Locator locator;
    private URI instanceDocument;

    public InputSource resolveEntity(String pubId, String sysId) throws SAXException {
        if (sysId != null && sysId.endsWith("dtd")) {
            return new InputSource(new StringReader(""));
        }
        try {
            return super.resolveEntity(pubId, sysId);
        }
        catch (IOException e) {
            SAXException se = new SAXException(e.getLocalizedMessage());
            se.initCause(e);
            throw se;
        }
    }

    public XMLSAXHandler(URI intendedDocument, Map hints) {
        this.instanceDocument = intendedDocument;
        this.hints = hints;
        logger.setLevel(level);
    }

    public XMLSAXHandler(Map hints) {
        this.hints = hints;
        logger.setLevel(level);
    }

    public void endDocument() {
        this.document = (DocumentHandler)this.handlers.pop();
    }

    public void startDocument() {
        try {
            this.document = new DocumentHandler(this.ehf);
            this.handlers.push(this.document);
        }
        catch (RuntimeException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            String text = String.copyValueOf(ch, start, length);
            if (text != null && !"".equals(text)) {
                ((XMLElementHandler)this.handlers.peek()).characters(text);
            }
        }
        catch (SAXException e) {
            logger.warning(e.toString());
            throw e;
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        logger.info("END: " + qName);
        try {
            ((XMLElementHandler)this.handlers.pop()).endElement(new URI(namespaceURI), localName, this.hints);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            logger.warning("Line " + this.locator.getLineNumber() + " Col " + this.locator.getColumnNumber());
            throw new SAXException(e);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        logger.info("START: " + qName);
        if (this.schemaProxy.size() != 0) {
            String[] targ2uri;
            logger.info("ADDING NAMESPACES: " + this.schemaProxy.size());
            String t = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            if (t == null || "".equals(t)) {
                t = atts.getValue("", "schemaLocation");
            }
            if (t != null && !"".equals(t) && (targ2uri = t.split("\\s+")) != null) {
                if (targ2uri.length != 0 && targ2uri.length % 2 != 0) {
                    throw new SAXException("Bad Schema location attribute: you must have an even number of terms");
                }
                for (int i = 0; i < targ2uri.length / 2; ++i) {
                    String uri = targ2uri[i * 2 + 1];
                    String targ = targ2uri[i * 2];
                    String prefix = (String)this.schemaProxy.get(targ);
                    URI targUri = null;
                    try {
                        targUri = this.instanceDocument == null ? new URI(uri) : this.instanceDocument.resolve(uri);
                    }
                    catch (URISyntaxException e1) {
                        logger.warning(e1.toString());
                    }
                    this.ehf.startPrefixMapping(prefix, targ, targUri);
                    this.schemaProxy.remove(targ);
                }
            }
            if (this.schemaProxy.size() != 0) {
                Iterator it = this.schemaProxy.keySet().iterator();
                while (it.hasNext()) {
                    String targ = (String)it.next();
                    String prefix = (String)this.schemaProxy.get(targ);
                    this.ehf.startPrefixMapping(prefix, targ);
                    it.remove();
                }
            }
        }
        logger.finest("Moving on to finding the element handler");
        try {
            XMLElementHandler parent = (XMLElementHandler)this.handlers.peek();
            logger.finest("Parent Node = " + parent.getClass().getName() + "  '" + parent.getName() + "'");
            logger.finest("This Node = " + localName + " :: " + namespaceURI);
            XMLElementHandler eh = parent.getHandler(new URI(namespaceURI), localName, this.hints);
            if (eh == null) {
                eh = new IgnoreHandler();
            }
            logger.finest("This Node = " + eh.getClass().getName());
            this.handlers.push(eh);
            eh.startElement(new URI(namespaceURI), localName, atts);
        }
        catch (Exception e) {
            logger.warning(e.toString());
            logger.warning("Line " + this.locator.getLineNumber() + " Col " + this.locator.getColumnNumber());
            throw new SAXException(e);
        }
    }

    public static void setLogLevel(Level l) {
        level = l;
        logger.setLevel(l);
        XMLElementHandler.setLogLevel(l);
    }

    public Object getDocument() throws SAXException {
        return this.document.getValue();
    }

    public void error(SAXParseException exception) {
        logger.severe("ERROR " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        logger.severe("FATAL " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
        throw exception;
    }

    public void warning(SAXParseException exception) {
        logger.warning("WARN " + exception.getMessage());
        logger.severe("col " + this.locator.getColumnNumber() + ", line " + this.locator.getLineNumber());
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    public void endPrefixMapping(String prefix) {
        this.ehf.endPrefixMapping(prefix);
    }

    public void startPrefixMapping(String prefix, String uri) {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(uri)) {
            return;
        }
        this.schemaProxy.put(uri, prefix);
    }
}

