/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilitiesMask;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.GeometryDistanceFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.NullFilter;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.filter.FilterComplexTypes;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterOpsComplexTypes {
    static /* synthetic */ Class class$org$geotools$filter$CompareFilter;
    static /* synthetic */ Class class$org$geotools$filter$GeometryFilter;
    static /* synthetic */ Class class$org$geotools$filter$LogicFilter;
    static /* synthetic */ Class class$org$geotools$filter$Filter;
    static /* synthetic */ Class class$org$geotools$filter$FidFilter;
    static /* synthetic */ Class class$org$geotools$filter$LikeFilter;
    static /* synthetic */ Class class$org$geotools$filter$NullFilter;
    static /* synthetic */ Class class$org$geotools$filter$BetweenFilter;
    static /* synthetic */ Class class$org$geotools$filter$Expression;
    static /* synthetic */ Class class$org$geotools$filter$GeometryDistanceFilter;

    protected static void encodeFilter(Filter filter, PrintHandler output, Map hints) throws OperationNotSupportedException, IOException {
        if (filter instanceof LogicFilter) {
            FilterType.elems[2].getType().encode(FilterType.elems[2], filter, output, hints);
        } else if (filter instanceof CompareFilter) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else if (filter instanceof FidFilter) {
            FilterType.elems[3].getType().encode(FilterType.elems[3], filter, output, hints);
        } else if (filter instanceof GeometryFilter) {
            FilterType.elems[0].getType().encode(FilterType.elems[0], filter, output, hints);
        } else if (filter instanceof LikeFilter) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else if (filter instanceof NullFilter) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        }
    }

    protected static void encodeExpr(Expression expr, PrintHandler output, Map hints) throws OperationNotSupportedException, IOException {
        int i = 0;
        switch (expr.getType()) {
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                i = 36;
                break;
            }
            case 105: {
                i = 29;
                break;
            }
            case 106: {
                i = 30;
                break;
            }
            case 107: {
                i = 31;
                break;
            }
            case 108: {
                i = 32;
                break;
            }
            case 100: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                i = 34;
                break;
            }
            case 114: {
                i = 35;
            }
        }
        if (i != 0) {
            FilterSchema.getInstance().getElements()[i].getType().encode(FilterSchema.getInstance().getElements()[i], expr, output, hints);
        }
    }

    public static class UnaryLogicOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new UnaryLogicOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance())};
        private static Choice choice = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return LogicOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            short type;
            FilterFactory factory = FilterSchema.filterFactory(hints);
            String name = element.getName();
            if ("and".equalsIgnoreCase(name)) {
                type = 2;
            } else if ("or".equalsIgnoreCase(name)) {
                type = 1;
            } else if ("not".equalsIgnoreCase(name)) {
                type = 3;
            } else {
                throw new SAXException("Expected AND or OR logic filter");
            }
            if (value == null || value.length != 1) {
                throw new SAXException("Require a single filter for " + element);
            }
            try {
                LogicFilter filter = factory.createLogicFilter(type);
                filter.addFilter((Filter)value[0].getValue());
                return filter;
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Require a single filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "UnaryLogicOpType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$LogicFilter == null ? (class$org$geotools$filter$LogicFilter = FilterOpsComplexTypes.class$("org.geotools.filter.LogicFilter")) : class$org$geotools$filter$LogicFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x800) != 2048) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LogicFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LogicFilter lf = (LogicFilter)value;
            Iterator i = lf.getFilterIterator();
            output.startElement(element.getNamespace(), element.getName(), null);
            int c = 0;
            while (i.hasNext()) {
                if (c < 1) {
                    Filter f = (Filter)i.next();
                    FilterOpsComplexTypes.encodeFilter(f, output, hints);
                    ++c;
                    continue;
                }
                throw new OperationNotSupportedException("Invalid Not Filter -- more than one child filter.");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinaryLogicOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BinaryLogicOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance())};
        private static Choice choice = new ChoiceGT(null, 2, Integer.MAX_VALUE, elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return LogicOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            short type;
            FilterFactory factory = FilterSchema.filterFactory(hints);
            String name = element.getName();
            if ("and".equalsIgnoreCase(name)) {
                type = 2;
            } else if ("or".equalsIgnoreCase(name)) {
                type = 1;
            } else {
                throw new SAXException("Expected AND or OR logic filter");
            }
            try {
                LogicFilter filter = factory.createLogicFilter(type);
                for (int i = 0; i < value.length; ++i) {
                    filter.addFilter((Filter)value[i].getValue());
                }
                return filter;
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "BinaryLogicOpType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$LogicFilter == null ? (class$org$geotools$filter$LogicFilter = FilterOpsComplexTypes.class$("org.geotools.filter.LogicFilter")) : class$org$geotools$filter$LogicFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x800) != 2048) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LogicFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LogicFilter lf = (LogicFilter)value;
            Iterator i = lf.getFilterIterator();
            output.startElement(element.getNamespace(), element.getName(), null);
            while (i.hasNext()) {
                Filter f = (Filter)i.next();
                FilterOpsComplexTypes.encodeFilter(f, output, hints);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class DistanceType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new DistanceType();
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("units", XSISimpleTypes.String.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isMixed() {
            return true;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                GeometryDistanceFilter distance = factory.createGeometryDistanceFilter((short)24);
                distance.addLeftGeometry((Expression)value[0].getValue());
                distance.addRightGeometry((Expression)value[1].getValue());
                distance.setDistance(((Number)value[2].getValue()).doubleValue());
                return distance;
            }
            catch (ClassCastException wrong) {
                throw new SAXException(wrong);
            }
            catch (IllegalFilterException illegalFilterException) {
                throw new SAXException(illegalFilterException);
            }
        }

        public String getName() {
            return "DistanceType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$GeometryDistanceFilter == null ? (class$org$geotools$filter$GeometryDistanceFilter = FilterOpsComplexTypes.class$("org.geotools.filter.GeometryDistanceFilter")) : class$org$geotools$filter$GeometryDistanceFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 0x600) != 1536) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryDistanceFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryDistanceFilter lf = (GeometryDistanceFilter)value;
            AttributesImpl ai = new AttributesImpl();
            if (lf.getLeftGeometry().getType() == 104) {
                ai.addAttribute(this.getNamespace().toString(), attrs[0].getName(), null, "string", ((Geometry)lf.getLeftGeometry().getValue(null)).getUserData().toString());
            } else {
                ai.addAttribute(this.getNamespace().toString(), attrs[0].getName(), null, "string", ((Geometry)lf.getRightGeometry().getValue(null)).getUserData().toString());
            }
            output.startElement(element.getNamespace(), element.getName(), null);
            output.characters("" + lf.getDistance());
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class DistanceBufferType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new DistanceBufferType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), GMLSchema.getInstance().getElements()[29], new FilterSchema.FilterElement("Distance", DistanceType.getInstance())};
        private Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return this.seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                GeometryDistanceFilter distance = factory.createGeometryDistanceFilter((short)13);
                distance.addLeftGeometry((Expression)value[0].getValue());
                distance.addRightGeometry((Expression)value[1].getValue());
                distance.setDistance(((Number)value[2].getValue()).doubleValue());
                return distance;
            }
            catch (ClassCastException wrong) {
                throw new SAXException(wrong);
            }
            catch (IllegalFilterException illegalFilterException) {
                throw new SAXException(illegalFilterException);
            }
        }

        public String getName() {
            return "DistanceBufferType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$GeometryDistanceFilter == null ? (class$org$geotools$filter$GeometryDistanceFilter = FilterOpsComplexTypes.class$("org.geotools.filter.GeometryDistanceFilter")) : class$org$geotools$filter$GeometryDistanceFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 0x600) != 1536) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryDistanceFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryDistanceFilter lf = (GeometryDistanceFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            if (lf.getLeftGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getLeftGeometry(), output, hints);
                elems[1].getType().encode(elems[1], lf.getRightGeometry().getValue(null), output, hints);
                elems[2].getType().encode(elems[2], lf, output, hints);
            } else if (lf.getRightGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getRightGeometry(), output, hints);
                elems[1].getType().encode(elems[1], lf.getLeftGeometry().getValue(null), output, hints);
                elems[2].getType().encode(elems[2], lf, output, hints);
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BBOXType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BBOXType();
        private static final Element OGC_PROPERTY_NAME = new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance());
        private static final Element GML_BOX = GMLSchema.getInstance().getElements()[41];
        private static Element[] elems = new Element[]{OGC_PROPERTY_NAME, GML_BOX};
        private Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return this.seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            if (value == null || value.length != 2) {
                throw new SAXException("ogc:propertyName or gml:box required for bbox filter");
            }
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                GeometryFilter disjoint = factory.createGeometryFilter((short)6);
                disjoint.addLeftGeometry((Expression)value[0].getValue());
                disjoint.addRightGeometry((Expression)value[1].getValue());
                return disjoint.not();
            }
            catch (ClassCastException wrong) {
                throw new SAXException("ogc:propertyName or gml:box required for bbox filter", wrong);
            }
            catch (IllegalFilterException illegalFilterException) {
                throw new SAXException("Could not create bbox filter", illegalFilterException);
            }
        }

        public String getName() {
            return "BBOXType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$Filter == null ? (class$org$geotools$filter$Filter = FilterOpsComplexTypes.class$("org.geotools.filter.Filter")) : class$org$geotools$filter$Filter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 1) != 1) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryFilter lf = (GeometryFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            if (lf.getLeftGeometry().getType() == 104) {
                elems[0].getType().encode(elems[0], lf.getRightGeometry(), output, hints);
                Geometry g = ((Geometry)((LiteralExpression)lf.getLeftGeometry()).getLiteral()).getEnvelope();
                elems[1].getType().encode(elems[1], g, output, hints);
            } else if (lf.getRightGeometry().getType() == 104) {
                elems[0].getType().encode(elems[0], lf.getLeftGeometry(), output, hints);
                Geometry g = ((Geometry)((LiteralExpression)lf.getRightGeometry()).getLiteral()).getEnvelope();
                elems[1].getType().encode(elems[1], g, output, hints);
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name : BBOXType");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinarySpatialOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BinarySpatialOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), GMLSchema.getInstance().getElements()[29], GMLSchema.getInstance().getElements()[41]};
        private static Sequence child = new SequenceGT(new ElementGrouping[]{elems[0], new ChoiceGT(new Element[]{elems[1], elems[2]})});

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return child;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                short type = SpatialOpsType.findFilterType(element.getName());
                GeometryFilter filter = factory.createGeometryFilter(type);
                filter.addLeftGeometry((Expression)value[0].getValue());
                filter.addRightGeometry((Expression)value[1].getValue());
                return filter;
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "BinarySpatialOpType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$GeometryFilter == null ? (class$org$geotools$filter$GeometryFilter = FilterOpsComplexTypes.class$("org.geotools.filter.GeometryFilter")) : class$org$geotools$filter$GeometryFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities")) {
                FilterCapabilitiesMask fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities");
                int elementkey = FilterCapabilitiesMask.findOperation(element.getName());
                if (elementkey == 0 || (fc.getSpatialOps() & elementkey) != elementkey) {
                    return false;
                }
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryFilter lf = (GeometryFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            if (lf.getLeftGeometry().getType() == 103 || lf.getLeftGeometry().getType() == 111 || lf.getLeftGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getLeftGeometry(), output, hints);
                if (lf.getRightGeometry().getType() == 104) {
                    elems[1].getType().encode(elems[1], ((LiteralExpression)lf.getRightGeometry()).getLiteral(), output, hints);
                } else {
                    elems[2].getType().encode(elems[2], ((LiteralExpression)lf.getRightGeometry()).getLiteral(), output, hints);
                }
            } else if (lf.getRightGeometry().getType() == 103 || lf.getRightGeometry().getType() == 111 || lf.getRightGeometry().getType() == 113) {
                elems[0].getType().encode(elems[0], lf.getRightGeometry(), output, hints);
                if (lf.getLeftGeometry().getType() == 104) {
                    elems[1].getType().encode(elems[1], ((LiteralExpression)lf.getLeftGeometry()).getLiteral(), output, hints);
                } else {
                    elems[2].getType().encode(elems[2], ((LiteralExpression)lf.getLeftGeometry()).getLiteral(), output, hints);
                }
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name l=" + lf.getLeftGeometry().getType() + " r=" + lf.getRightGeometry().getType());
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class UpperBoundaryType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new UpperBoundaryType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance())};
        private static Sequence choice = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return (Expression)value[0].getValue();
        }

        public String getName() {
            return "UpperBoundaryType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$Expression == null ? (class$org$geotools$filter$Expression = FilterOpsComplexTypes.class$("org.geotools.filter.Expression")) : class$org$geotools$filter$Expression;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Expression;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Expression lf = (Expression)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class LowerBoundaryType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new LowerBoundaryType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance())};
        private static Choice choice = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return (Expression)value[0].getValue();
        }

        public String getName() {
            return "LowerBoundaryType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$Expression == null ? (class$org$geotools$filter$Expression = FilterOpsComplexTypes.class$("org.geotools.filter.Expression")) : class$org$geotools$filter$Expression;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Expression;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Expression lf = (Expression)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsBetweenType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsBetweenType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance()), new FilterSchema.FilterElement("LowerBoundary", LowerBoundaryType.getInstance()), new FilterSchema.FilterElement("UpperBoundary", UpperBoundaryType.getInstance())};
        private static Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                BetweenFilter filter = factory.createBetweenFilter();
                filter.addLeftValue((Expression)value[1].getValue());
                filter.addMiddleValue((Expression)value[0].getValue());
                filter.addRightValue((Expression)value[2].getValue());
                return filter;
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "PropertyIsBetweenType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$BetweenFilter == null ? (class$org$geotools$filter$BetweenFilter = FilterOpsComplexTypes.class$("org.geotools.filter.BetweenFilter")) : class$org$geotools$filter$BetweenFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x4000) != 16384) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof BetweenFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            BetweenFilter lf = (BetweenFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf.getMiddleValue(), output, hints);
            elems[1].getType().encode(elems[1], lf.getLeftValue(), output, hints);
            elems[2].getType().encode(elems[2], lf.getRightValue(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsNullType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsNullType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), new FilterSchema.FilterElement("Literal", FilterComplexTypes.LiteralType.getInstance())};
        private static Choice seq = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                NullFilter filter = factory.createNullFilter();
                filter.nullCheckValue((Expression)value[0].getValue());
                return filter;
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "PropertyIsNullType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$NullFilter == null ? (class$org$geotools$filter$NullFilter = FilterOpsComplexTypes.class$("org.geotools.filter.NullFilter")) : class$org$geotools$filter$NullFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x8000) != 32768) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof NullFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            NullFilter lf = (NullFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            elems[0].getType().encode(elems[0], lf.getNullCheckValue(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsLikeType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsLikeType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), new FilterSchema.FilterElement("Literal", FilterComplexTypes.LiteralType.getInstance())};
        private static Sequence seq = new SequenceGT(elems);
        private static Attribute[] attr = new Attribute[]{new FilterSchema.FilterAttribute("wildCard", XSISimpleTypes.String.getInstance(), 2), new FilterSchema.FilterAttribute("singleChar", XSISimpleTypes.String.getInstance(), 2), new FilterSchema.FilterAttribute("escape", XSISimpleTypes.String.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Attribute[] getAttributes() {
            return attr;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                LikeFilter filter = factory.createLikeFilter();
                filter.setValue((Expression)value[0].getValue());
                String wildCard = attrs.getValue("wildCard");
                String singleChar = attrs.getValue("singleChar");
                String escape = attrs.getValue("escape");
                filter.setPattern((Expression)value[1].getValue(), wildCard, singleChar, escape);
                return filter;
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "PropertyIsLikeType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$LikeFilter == null ? (class$org$geotools$filter$LikeFilter = FilterOpsComplexTypes.class$("org.geotools.filter.LikeFilter")) : class$org$geotools$filter$LikeFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x2000) != 8192) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LikeFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LikeFilter lf = (LikeFilter)value;
            AttributesImpl at = new AttributesImpl();
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "wildCard", null, "string", lf.getWildcardMulti());
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "singleChar", null, "string", lf.getWildcardSingle());
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "escape", null, "string", lf.getEscape());
            output.startElement(element.getNamespace(), element.getName(), at);
            elems[0].getType().encode(elems[0], lf.getValue(), output, hints);
            elems[1].getType().encode(elems[1], lf.getPattern(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinaryComparisonOpType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new BinaryComparisonOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance()){

            public int getMaxOccurs() {
                return 2;
            }

            public int getMinOccurs() {
                return 2;
            }
        }};
        private static Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        public ElementGrouping getChild() {
            return seq;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException, OperationNotSupportedException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                short type = ComparisonOpsType.findFilterType(element.getName());
                CompareFilter filter = factory.createCompareFilter(type);
                filter.addLeftValue((Expression)value[0].getValue());
                filter.addRightValue((Expression)value[1].getValue());
                return filter;
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "BinaryComparisonOpType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$CompareFilter == null ? (class$org$geotools$filter$CompareFilter = FilterOpsComplexTypes.class$("org.geotools.filter.CompareFilter")) : class$org$geotools$filter$CompareFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x11000) != 69632) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof CompareFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            CompareFilter cf = (CompareFilter)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(cf.getLeftValue(), output, hints);
            FilterOpsComplexTypes.encodeExpr(cf.getRightValue(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class FeatureIdType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new FeatureIdType();
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("fid", XSISimpleTypes.AnyURI.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        public Attribute[] getAttributes() {
            return attrs;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length != 0) {
                throw new SAXException("Invalid children: more than 0 ... " + value.length);
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            String fid = null;
            fid = attrs1.getValue("", attrs[0].getName());
            if (fid == null || "".equals(fid)) {
                fid = attrs1.getValue(attrs[0].getNamespace().toString(), attrs[0].getName());
            }
            FidFilter r = FilterFactory.createFilterFactory().createFidFilter(fid);
            return r;
        }

        public String getName() {
            return "FeatureIdType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$FidFilter == null ? (class$org$geotools$filter$FidFilter = FilterOpsComplexTypes.class$("org.geotools.filter.FidFilter")) : class$org$geotools$filter$FidFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof FidFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            FidFilter ff = (FidFilter)value;
            String[] fids = ff.getFids();
            AttributesImpl att = new AttributesImpl();
            att.addAttribute(null, null, null, null, null);
            for (int i = 0; i < fids.length; ++i) {
                att.setAttribute(0, element.getNamespace().toString(), attrs[0].getName(), null, "anyUri", fids[i]);
                output.element(element.getNamespace(), element.getName(), att);
            }
        }
    }

    public static class FilterType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        static final Element[] elems = new Element[]{new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance()), new FilterSchema.FilterElement("FeatureId", FeatureIdType.getInstance()){

            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        }};
        private static Choice choice = new ChoiceGT(elems);
        private static final ComplexType instance = new FilterType();

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return choice;
        }

        public Element[] getChildElements() {
            return elems;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return value[0].getValue();
        }

        public String getName() {
            return "FilterType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$Filter == null ? (class$org$geotools$filter$Filter = FilterOpsComplexTypes.class$("org.geotools.filter.Filter")) : class$org$geotools$filter$Filter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0 && fc.getSpatialOps() == 0) {
                return false;
            }
            boolean r = element != null && element.getType() != null && this.getName().equals(element.getType().getName());
            r = r && value != null && value instanceof Filter && ((Filter)value).getFilterType() != 0;
            return r;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Filter filter = (Filter)value;
            if (filter == null) {
                return;
            }
            if (filter == Filter.NONE) {
                return;
            }
            if (filter == Filter.ALL) {
                return;
            }
            if (element != null) {
                output.startElement(element.getNamespace(), element.getName(), null);
            }
            FilterOpsComplexTypes.encodeFilter(filter, output, hints);
            if (element != null) {
                output.endElement(element.getNamespace(), element.getName());
            }
        }
    }

    public static class LogicOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new LogicOpsType();

        public static ComplexType getInstance() {
            return instance;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) {
            return null;
        }

        public String getName() {
            return "LogicOpsType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$LogicFilter == null ? (class$org$geotools$filter$LogicFilter = FilterOpsComplexTypes.class$("org.geotools.filter.LogicFilter")) : class$org$geotools$filter$LogicFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x800) != 2048) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof LogicFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            LogicFilter lf = (LogicFilter)value;
            switch (lf.getFilterType()) {
                case 2: {
                    BinaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("And", BinaryLogicOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 1: {
                    BinaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("Or", BinaryLogicOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 3: {
                    UnaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("Not", UnaryLogicOpType.getInstance(), element), value, output, hints);
                    return;
                }
            }
            throw new OperationNotSupportedException("Unknown filter type in LogicFilter: " + lf.getClass().getName());
        }

        public boolean isAbstract() {
            return true;
        }
    }

    public static class SpatialOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new SpatialOpsType();

        public static short findFilterType(String s) {
            if ("BBOX".equalsIgnoreCase(s)) {
                return 4;
            }
            if ("Equals".equalsIgnoreCase(s)) {
                return 5;
            }
            if ("Disjoint".equalsIgnoreCase(s)) {
                return 6;
            }
            if ("Intersects".equalsIgnoreCase(s)) {
                return 7;
            }
            if ("Touches".equalsIgnoreCase(s)) {
                return 8;
            }
            if ("Crosses".equalsIgnoreCase(s)) {
                return 9;
            }
            if ("Within".equalsIgnoreCase(s)) {
                return 10;
            }
            if ("Contains".equalsIgnoreCase(s)) {
                return 11;
            }
            if ("Overlaps".equalsIgnoreCase(s)) {
                return 12;
            }
            if ("Beyond".equalsIgnoreCase(s)) {
                return 13;
            }
            if ("DWithin".equalsIgnoreCase(s)) {
                return 24;
            }
            return 0;
        }

        public static String writeFilterType(short filterType) {
            switch (filterType) {
                case 4: {
                    return "BBOX";
                }
                case 5: {
                    return "Equals";
                }
                case 6: {
                    return "Disjoint";
                }
                case 7: {
                    return "Intersects";
                }
                case 8: {
                    return "Touches";
                }
                case 9: {
                    return "Crosses";
                }
                case 10: {
                    return "Within";
                }
                case 11: {
                    return "Contains";
                }
                case 12: {
                    return "Overlaps";
                }
                case 13: {
                    return "Beyond";
                }
                case 24: {
                    return "DWithin";
                }
            }
            return "";
        }

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isAbstract() {
            return true;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            return null;
        }

        public String getName() {
            return "SpatialOpsType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$GeometryFilter == null ? (class$org$geotools$filter$GeometryFilter = FilterOpsComplexTypes.class$("org.geotools.filter.GeometryFilter")) : class$org$geotools$filter$GeometryFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() == 0) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof GeometryFilter;
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            GeometryFilter lf = (GeometryFilter)value;
            switch (lf.getFilterType()) {
                case 4: {
                    BBOXType.getInstance().encode(new FilterSchema.FilterElement("BBOX", BBOXType.getInstance(), element), value, output, hints);
                    return;
                }
                case 13: {
                    DistanceBufferType.getInstance().encode(new FilterSchema.FilterElement("Beyond", DistanceBufferType.getInstance(), element), value, output, hints);
                    return;
                }
                case 11: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Contains", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 9: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Crosses", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 6: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Disjoint", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 24: {
                    DistanceBufferType.getInstance().encode(new FilterSchema.FilterElement("DWithin", DistanceBufferType.getInstance(), element), value, output, hints);
                    return;
                }
                case 5: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Equals", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 7: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Intersects", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 12: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Overlaps", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 8: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Touches", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 10: {
                    BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Within", BinarySpatialOpType.getInstance(), element), value, output, hints);
                    return;
                }
            }
            throw new OperationNotSupportedException("Unknown filter type in ComparisonFilter: " + lf.getClass().getName());
        }
    }

    public static class ComparisonOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new ComparisonOpsType();

        public static short findFilterType(String s) {
            if ("PropertyIsEqualTo".equalsIgnoreCase(s)) {
                return 14;
            }
            if ("PropertyIsGreaterThan".equalsIgnoreCase(s)) {
                return 16;
            }
            if ("PropertyIsGreaterThanOrEqualTo".equalsIgnoreCase(s)) {
                return 18;
            }
            if ("PropertyIsLessThan".equalsIgnoreCase(s)) {
                return 15;
            }
            if ("PropertyIsLessThanOrEqualTo".equalsIgnoreCase(s)) {
                return 17;
            }
            if ("PropertyIsNotEqualTo".equalsIgnoreCase(s)) {
                return 23;
            }
            if ("PropertyIsLike".equalsIgnoreCase(s)) {
                return 20;
            }
            if ("PropertyIsNull".equalsIgnoreCase(s)) {
                return 21;
            }
            if ("PropertyIsBetween".equalsIgnoreCase(s)) {
                return 19;
            }
            return 0;
        }

        public static String writeFilterType(short filterType) {
            switch (filterType) {
                case 14: {
                    return "PropertyIsEqualTo";
                }
                case 16: {
                    return "PropertyIsGreaterThan";
                }
                case 18: {
                    return "PropertyIsGreaterThanOrEqualTo";
                }
                case 15: {
                    return "PropertyIsLessThan";
                }
                case 17: {
                    return "PropertyIsLessThanOrEqualTo";
                }
                case 23: {
                    return "PropertyIsNotEqualTo";
                }
                case 20: {
                    return "PropertyIsLike";
                }
                case 21: {
                    return "PropertyIsNull";
                }
                case 19: {
                    return "PropertyIsBetween";
                }
            }
            return "";
        }

        public static ComplexType getInstance() {
            return instance;
        }

        public boolean isAbstract() {
            return true;
        }

        public ElementGrouping getChild() {
            return null;
        }

        public Element[] getChildElements() {
            return null;
        }

        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map hints) throws SAXException {
            FilterFactory factory = FilterSchema.filterFactory(hints);
            try {
                short type = ComparisonOpsType.findFilterType(element.getName());
                CompareFilter filter = factory.createCompareFilter(type);
                filter.addLeftValue((Expression)value[0].getValue());
                filter.addRightValue((Expression)value[1].getValue());
                return filter;
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        public String getName() {
            return "ComparisonOpsType";
        }

        public Class getInstanceType() {
            return class$org$geotools$filter$CompareFilter == null ? (class$org$geotools$filter$CompareFilter = FilterOpsComplexTypes.class$("org.geotools.filter.CompareFilter")) : class$org$geotools$filter$CompareFilter;
        }

        public boolean canEncode(Element element, Object value, Map hints) {
            FilterCapabilitiesMask fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilitiesMask)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x1000) != 4096) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && (value instanceof CompareFilter || value instanceof BetweenFilter || value instanceof NullFilter || value instanceof LikeFilter);
        }

        public void encode(Element element, Object value, PrintHandler output, Map hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Filter lf = (Filter)value;
            switch (lf.getFilterType()) {
                case 14: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 16: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsGreaterThan", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 18: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsGreaterThanOrEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 15: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLessThan", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 17: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLessThanOrEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 23: {
                    BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsNotEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
                    return;
                }
                case 20: {
                    PropertyIsLikeType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLike", PropertyIsLikeType.getInstance(), element), value, output, hints);
                    return;
                }
                case 21: {
                    PropertyIsNullType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsNull", PropertyIsNullType.getInstance(), element), value, output, hints);
                    return;
                }
                case 19: {
                    PropertyIsBetweenType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsBetween", PropertyIsBetweenType.getInstance(), element), value, output, hints);
                    return;
                }
            }
            throw new OperationNotSupportedException("Unknown filter type in ComparisonFilter: " + lf.getClass().getName());
        }
    }
}

