/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.gvsig.fmap.dal.DataStoreNotification;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureTable;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableConfigurationPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTablePanel
extends JPanel
implements Observer {
    private static final Logger logger = LoggerFactory.getLogger(FeatureTablePanel.class);
    private static final long serialVersionUID = -9199073063283531216L;
    private ConfigurableFeatureTableModel tableModel;
    private JScrollPane jScrollPane = null;
    private FeatureTable table = null;
    private JPanel selectionPanel;
    private JLabel selectionLabel;

    public FeatureTablePanel(FeatureStore featureStore) throws BaseException {
        this(featureStore, true);
    }

    public FeatureTablePanel(FeatureStore featureStore, boolean isDoubleBuffered) throws BaseException {
        this(featureStore, null, isDoubleBuffered);
    }

    public FeatureTablePanel(FeatureStore featureStore, FeatureQuery featureQuery) throws BaseException {
        this(featureStore, featureQuery, true);
    }

    public FeatureTablePanel(FeatureStore featureStore, FeatureQuery featureQuery, boolean isDoubleBuffered) throws BaseException {
        this(FeatureTablePanel.createModel(featureStore, featureQuery));
    }

    public FeatureTablePanel(ConfigurableFeatureTableModel tableModel) throws DataException {
        this(tableModel, true);
    }

    public FeatureTablePanel(ConfigurableFeatureTableModel tableModel, boolean isDoubleBuffered) throws DataException {
        super(isDoubleBuffered);
        this.tableModel = tableModel;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJScrollPane(), "Center");
        this.add((Component)this.getSelectionPanel(), "South");
        tableModel.getFeatureStore().addObserver((Observer)this);
    }

    private JPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.selectionLabel = new JLabel();
            this.selectionLabel.setText(this.getFeatureSelectionSize() + " / " + this.getTableModel().getHelper().getTotalSize() + " " + i18n.getTranslation("registros_seleccionados_total") + ".");
            FeatureStore store = this.getTableModel().getFeatureStore();
            if (store != null) {
                this.selectionLabel.setToolTipText("<html>" + i18n.getTranslation("_Table") + ": " + store.getName() + "<br>\n" + "( " + store.getFullName() + " )" + "</html>");
            }
            this.selectionPanel = new JPanel();
            this.selectionPanel.add((Component)this.selectionLabel, "East");
        }
        return this.selectionPanel;
    }

    private void updateSelection() {
        this.selectionLabel.setText(this.getFeatureSelectionSize() + " / " + this.getTableModel().getRowCount() + " " + Messages.getText((String)"registros_seleccionados_total") + ".");
        this.table.getSelectionModel().clearCache();
    }

    private long getFeatureSelectionSize() {
        try {
            return this.getFeatureStore().getFeatureSelection().getSize();
        }
        catch (DataException e) {
            throw new RuntimeException("Error updating selection information", e);
        }
    }

    public JPanel createConfigurationPanel() {
        return new FeatureTableConfigurationPanel(this.tableModel);
    }

    public ConfigurableFeatureTableModel getTableModel() {
        return this.tableModel;
    }

    public FeatureStore getFeatureStore() {
        return this.getTableModel().getFeatureStore();
    }

    public FeatureQuery getFeatureQuery() {
        return this.getTableModel().getFeatureQuery();
    }

    public void setSelectionUp(boolean selectionUp) {
        try {
            this.getTable().setSelectionUp(selectionUp);
        }
        catch (DataException e) {
            throw new RuntimeException("Error setting the selection up", e);
        }
    }

    private static ConfigurableFeatureTableModel createModel(FeatureStore featureStore, FeatureQuery featureQuery) throws BaseException {
        FeatureQuery query = featureQuery == null ? featureStore.createFeatureQuery() : featureQuery;
        return new ConfigurableFeatureTableModel(featureStore, query);
    }

    public FeatureTable getTable() throws DataException {
        if (this.table == null) {
            this.table = new FeatureTable(this.tableModel);
            this.table.setRowSelectionAllowed(true);
            this.table.setColumnSelectionAllowed(false);
        }
        return this.table;
    }

    private JScrollPane getJScrollPane() throws DataException {
        if (this.jScrollPane == null) {
            FeatureTable theTable = this.getTable();
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(theTable);
            this.createTheRowHeader();
            theTable.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pce) {
                    if ("RowHeight".equalsIgnoreCase(pce.getPropertyName())) {
                        FeatureTablePanel.this.createTheRowHeader();
                    }
                }
            });
            TableModel model = theTable.getModel();
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tme) {
                    FeatureTablePanel.this.createTheRowHeader();
                }
            });
        }
        return this.jScrollPane;
    }

    void createTheRowHeader() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractListModel lm = new AbstractListModel(){

                    @Override
                    public int getSize() {
                        return FeatureTablePanel.this.table.getRowCount();
                    }

                    @Override
                    public Object getElementAt(int index) {
                        return String.valueOf(index + 1);
                    }
                };
                JList rowHeader = new JList(lm);
                rowHeader.setBackground(FeatureTablePanel.this.table.getTableHeader().getBackground());
                rowHeader.setCellRenderer(new RowHeaderRenderer(FeatureTablePanel.this.table, rowHeader));
                FeatureTablePanel.this.jScrollPane.setRowHeaderView(rowHeader);
            }
        });
    }

    public void update(Observable observable, Object notification) {
        String type;
        if (notification instanceof DataStoreNotification && "after_SelectionChange_DataStore".equals(type = ((DataStoreNotification)notification).getType())) {
            this.updateSelection();
        }
    }

    private static class RowHeaderRenderer
    extends JButton
    implements ListCellRenderer {
        private JTable table = null;
        private final Dimension dimension = new Dimension();
        private JList rowHeader;

        RowHeaderRenderer(JTable table, JList rowHeader) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
            this.table = table;
            this.rowHeader = rowHeader;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            this.setPreferredSize(null);
            this.dimension.height = this.table.getRowHeight(index);
            this.dimension.width = this.getPreferredSize().width + 10;
            this.setPreferredSize(this.dimension);
            return this;
        }
    }
}

