/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTypeListModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.SelectedFeatureTypeChangeListener;

public class FeatureTypeList
extends JPanel {
    private static final long serialVersionUID = 6168364334623238504L;
    private JScrollPane jScrollPane = null;
    private JList jList = null;
    private List<SelectedFeatureTypeChangeListener> featureTypeChangeListeners = new ArrayList<SelectedFeatureTypeChangeListener>();
    private final FeatureTypeListModel model;

    public FeatureTypeList(FeatureStore featureStore, FeatureQuery featureQuery) {
        this(new FeatureTypeListModel(featureStore, featureQuery));
    }

    public FeatureTypeList(FeatureTypeListModel model) {
        this.model = model;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(146, 281));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setModel(this.model);
            this.jList.setSelectedIndex(0);
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    FeatureType fType = FeatureTypeList.this.getSelectedFeatureType();
                    for (int i = 0; i < FeatureTypeList.this.featureTypeChangeListeners.size(); ++i) {
                        ((SelectedFeatureTypeChangeListener)FeatureTypeList.this.featureTypeChangeListeners.get(i)).change(FeatureTypeList.this.model.getFeatureStore(), fType);
                    }
                }
            });
        }
        return this.jList;
    }

    public void addSelectedFeatureTypeChangeListener(SelectedFeatureTypeChangeListener listener) {
        this.featureTypeChangeListeners.add(listener);
    }

    public void removeSelectedFeatureTypeChangeListener(SelectedFeatureTypeChangeListener listener) {
        this.featureTypeChangeListeners.remove(listener);
    }

    public FeatureType getSelectedFeatureType() {
        int index = this.jList.getSelectedIndex();
        if (index >= 0) {
            String typeId = (String)this.jList.getModel().getElementAt(index);
            return this.model.getFeatureType(typeId);
        }
        return null;
    }

    public int getFeatureTypesSize() {
        return this.model.getSize();
    }
}

