/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontrol.AreaAndPerimeterCalculator;
import org.gvsig.fmap.mapcontrol.CompoundLayersTreeModel;
import org.gvsig.fmap.mapcontrol.CompoundStoresTreeModel;
import org.gvsig.fmap.mapcontrol.LayersTreeModel;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlCreationException;
import org.gvsig.fmap.mapcontrol.MapControlCreationListener;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.impl.CompoundStoresTreeModelImpl;
import org.gvsig.fmap.mapcontrol.swing.dynobject.LayersDynObjectSetComponent;
import org.gvsig.fmap.mapcontrol.swing.dynobject.impl.DefaultLayersDynObjectSetComponent;
import org.gvsig.fmap.mapcontrol.swing.pickercontroller.impl.EnvelopePickerControllerImpl;
import org.gvsig.fmap.mapcontrol.swing.pickercontroller.impl.ScalePickerControllerImpl;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapper;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMapControlManager
implements MapControlManager {
    private static final Logger logger = LoggerFactory.getLogger(MapControlManager.class);
    private static final String MAPCONTROL_MANAGER_EXTENSION_POINT = "MapControlManagerExtensionPoint";
    private static final String DEFAULT_MAPCONTROLMANAGER_NAME = null;
    private static final String SNAPPING_EXTENSION_POINT = "Snapper";
    private ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
    private int snappingTolerance = 4;
    private ISymbol selectionSymbol = null;
    private ISymbol axisReferencesSymbol = null;
    private ISymbol geometrySelectionSymbol = null;
    private ISymbol handlerSymbol = null;
    private static MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
    private Preferences prefs = Preferences.userRoot().node("cadtooladapter");
    private static Preferences prefSnappers = Preferences.userRoot().node("snappers");
    private List<ISnapper> snappers = null;
    private Set<MapControlCreationListener> mapControlCreationListeners = new LinkedHashSet<MapControlCreationListener>();

    public DefaultMapControlManager() {
        this.snappers = new ArrayList<ISnapper>();
    }

    @Override
    public MapControlDrawer createDefaultMapControlDrawer() throws MapControlCreationException {
        ExtensionPoint ep = this.extensionPoints.add(MAPCONTROL_MANAGER_EXTENSION_POINT);
        try {
            return (MapControlDrawer)ep.create(DEFAULT_MAPCONTROLMANAGER_NAME);
        }
        catch (Exception e) {
            throw new MapControlCreationException(e);
        }
    }

    @Override
    public MapControlDrawer createMapControlDrawer(String name) throws MapControlCreationException {
        ExtensionPoint ep = this.extensionPoints.add(MAPCONTROL_MANAGER_EXTENSION_POINT);
        try {
            return (MapControlDrawer)ep.create(name);
        }
        catch (Exception e) {
            throw new MapControlCreationException(e);
        }
    }

    @Override
    public void registerDefaultMapControlDrawer(Class mapControlDrawerClass) {
        if (!MapControlDrawer.class.isAssignableFrom(mapControlDrawerClass)) {
            throw new IllegalArgumentException(mapControlDrawerClass.getName() + " must implement the MapControlDrawer interface");
        }
        ExtensionPoint extensionPoint = this.extensionPoints.add(MAPCONTROL_MANAGER_EXTENSION_POINT, "");
        extensionPoint.append(DEFAULT_MAPCONTROLMANAGER_NAME, "Default MapControl", mapControlDrawerClass);
    }

    @Override
    public void registerMapControlDrawer(String name, Class mapControlDrawerClass) {
        if (!MapControlDrawer.class.isAssignableFrom(mapControlDrawerClass)) {
            throw new IllegalArgumentException(mapControlDrawerClass.getName() + " must implement the MapControlDrawer interface");
        }
        ExtensionPoint extensionPoint = this.extensionPoints.add(MAPCONTROL_MANAGER_EXTENSION_POINT, "");
        extensionPoint.append(name, "Default MapControl", mapControlDrawerClass);
    }

    @Override
    public int getTolerance() {
        return this.snappingTolerance;
    }

    @Override
    public void setTolerance(int tolerance) {
        this.snappingTolerance = tolerance;
    }

    public void clearSnappers() {
        this.snappers.clear();
    }

    @Override
    public ISymbol getAxisReferenceSymbol() {
        if (this.axisReferencesSymbol == null) {
            this.axisReferencesSymbol = mapContextManager.getSymbolManager().createSymbol(0, new Color(100, 100, 100, 100));
        }
        return this.axisReferencesSymbol;
    }

    @Override
    public ISymbol getGeometrySelectionSymbol() {
        if (this.geometrySelectionSymbol == null) {
            this.geometrySelectionSymbol = mapContextManager.getSymbolManager().createSymbol(0, Color.RED);
        }
        return this.geometrySelectionSymbol;
    }

    @Override
    public ISymbol getHandlerSymbol() {
        if (this.handlerSymbol == null) {
            this.handlerSymbol = mapContextManager.getSymbolManager().createSymbol(0, Color.ORANGE);
        }
        return this.handlerSymbol;
    }

    @Override
    public ISymbol getSelectionSymbol() {
        if (this.selectionSymbol == null) {
            this.selectionSymbol = mapContextManager.getSymbolManager().createSymbol(0, new Color(255, 0, 0, 100));
        }
        return this.selectionSymbol;
    }

    @Override
    public void setAxisReferenceSymbol(ISymbol axisReferencesSymbol) {
        this.axisReferencesSymbol = axisReferencesSymbol;
    }

    @Override
    public void setGeometrySelectionSymbol(ISymbol geometrySelectionSymbol) {
        this.geometrySelectionSymbol = geometrySelectionSymbol;
    }

    @Override
    public void setHandlerSymbol(ISymbol handlerSymbol) {
        this.handlerSymbol = handlerSymbol;
    }

    @Override
    public void setSelectionSymbol(ISymbol selectionSymbol) {
        this.selectionSymbol = selectionSymbol;
    }

    @Override
    public void registerSnapper(String name, Class snapperClass) {
        if (!ISnapper.class.isAssignableFrom(snapperClass)) {
            throw new IllegalArgumentException(snapperClass.getName() + " must implement the ISnapper interface");
        }
        ExtensionPoint extensionPoint = this.extensionPoints.add(SNAPPING_EXTENSION_POINT, "");
        ExtensionPoint.Extension extension = extensionPoint.append(name, "", snapperClass);
        try {
            ISnapper snapper = (ISnapper)extension.create();
            this.snappers.add(snapper);
            String nameClass = snapper.getClass().getName();
            nameClass = nameClass.substring(nameClass.lastIndexOf(46));
            boolean select = prefSnappers.getBoolean("snapper_activated" + nameClass, false);
            int priority = this.prefs.getInt("snapper_priority" + nameClass, 3);
            snapper.setPriority(priority);
            if (select) {
                snapper.setEnabled(select);
            }
        }
        catch (Exception e) {
            logger.error("It is not possible to create the snapper");
        }
    }

    @Override
    public ISnapper getSnapperAt(int index) {
        return this.snappers.get(index);
    }

    @Override
    public int getSnapperCount() {
        return this.snappers.size();
    }

    public void disableSnapping() {
        this.snappers.clear();
    }

    public void enableSnapping() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint ep = extensionPoints.get(SNAPPING_EXTENSION_POINT);
        Iterator iterator = ep.iterator();
        while (iterator.hasNext()) {
            try {
                ExtensionPoint.Extension obj = (ExtensionPoint.Extension)iterator.next();
                ISnapper snapper = (ISnapper)ep.create(obj.getName());
                this.snappers.add(snapper);
            }
            catch (Exception e) {
                logger.error("Creating a snapper", (Throwable)e);
            }
        }
        for (int n = 0; n < this.getSnapperCount(); ++n) {
            ISnapper snp = this.getSnapperAt(n);
            String nameClass = snp.getClass().getName();
            nameClass = nameClass.substring(nameClass.lastIndexOf(46));
            boolean select = this.prefs.getBoolean("snapper_activated" + nameClass, false);
            if (select) {
                snp.setEnabled(select);
            }
            int priority = this.prefs.getInt("snapper_priority" + nameClass, 3);
            snp.setPriority(priority);
        }
    }

    @Override
    public Preferences getEditionPreferences() {
        return this.prefs;
    }

    @Override
    public MapControl createJMapControlPanel(MapContext mapContext) throws MapControlCreationException {
        MapControl mapControl = new MapControl(mapContext);
        mapControl.setMapControlDrawer(this.createDefaultMapControlDrawer());
        for (MapControlCreationListener listener : this.mapControlCreationListeners) {
            if (listener == null) continue;
            mapControl = listener.mapControlCreated(mapControl);
        }
        return mapControl;
    }

    @Override
    public void addMapControlCreationListener(MapControlCreationListener listener) {
        this.mapControlCreationListeners.add(listener);
    }

    @Override
    public LayersDynObjectSetComponent createLayersDynObjectSetComponent(Map<String, DynObjectSet> layerName2InfoByPoint) {
        return this.createLayersDynObjectSetComponent(layerName2InfoByPoint, false);
    }

    @Override
    public LayersDynObjectSetComponent createLayersDynObjectSetComponent(Map<String, DynObjectSet> layerName2InfoByPoint, boolean writable) {
        return new DefaultLayersDynObjectSetComponent(layerName2InfoByPoint, writable);
    }

    @Override
    public TreeModel createLayersTreeModel(MapContext mapContext) {
        return new LayersTreeModel(mapContext.getLayers());
    }

    @Override
    public TreeModel createLayersTreeModel(FLayers layers) {
        return new LayersTreeModel(layers);
    }

    @Override
    public TreeModel createCompoundLayersTreeModel() {
        return new CompoundLayersTreeModel();
    }

    @Override
    public CompoundStoresTreeModel createCompoundStoresTreeModel() {
        return new CompoundStoresTreeModelImpl();
    }

    @Override
    public double perimeter(Geometry geom, IProjection proj, int distanceUnits) {
        AreaAndPerimeterCalculator calculator = new AreaAndPerimeterCalculator();
        return calculator.perimeter(geom, proj, distanceUnits);
    }

    @Override
    public double area(Geometry geom, IProjection proj, int areaUnits) {
        AreaAndPerimeterCalculator calculator = new AreaAndPerimeterCalculator();
        return calculator.area(geom, proj, areaUnits);
    }

    public EnvelopePickerControllerImpl createEnvelopePickerController(MapControl mapControl, JTextField txtUpperLeftX, JTextField txtUpperLeftY, JTextField txtLowerRightX, JTextField txtLowerRightY, JButton btnMapControlEnvelope, JToggleButton btnCapture) {
        EnvelopePickerControllerImpl controller = new EnvelopePickerControllerImpl(() -> mapControl, txtUpperLeftX, txtUpperLeftY, txtLowerRightX, txtLowerRightY, btnMapControlEnvelope, btnCapture);
        return controller;
    }

    public EnvelopePickerControllerImpl createEnvelopePickerController(MapControl mapControl, JTextComponent txtEnvelope, JButton btnMapControlEnvelope, JToggleButton btnCapture) {
        return this.createEnvelopePickerController(() -> mapControl, txtEnvelope, btnMapControlEnvelope, btnCapture);
    }

    public EnvelopePickerControllerImpl createEnvelopePickerController(Supplier<MapControl> mapControl, JTextComponent txtEnvelope, JButton btnMapControlEnvelope, JToggleButton btnCapture) {
        EnvelopePickerControllerImpl controller = new EnvelopePickerControllerImpl(mapControl, txtEnvelope, btnMapControlEnvelope, btnCapture);
        return controller;
    }

    public ScalePickerControllerImpl createScalePickerController(MapControl mapControl, JComboBox cboScale, JButton btnMapControlScale, JToggleButton btnCapture) {
        ScalePickerControllerImpl controller = new ScalePickerControllerImpl(mapControl, cboScale, btnMapControlScale, btnCapture);
        return controller;
    }
}

