/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.impl;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.handler.Handler;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.impl.DefaultPrimitivesDrawer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapControlDrawer2D
extends DefaultPrimitivesDrawer
implements MapControlDrawer {
    private static final Logger LOG = LoggerFactory.getLogger(MapControlDrawer2D.class);
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private ViewPort viewPort = null;

    @Override
    public void draw(Geometry geometry, ISymbol symbol) {
        if (geometry != null) {
            symbol.draw(this.graphics, this.viewPort.getAffineTransform(), geometry, null, null);
        }
    }

    @Override
    public void draw(Geometry geometry, ISymbol symbol, Feature feature) {
        if (geometry != null) {
            symbol.draw(this.graphics, this.viewPort.getAffineTransform(), geometry, feature, null);
        }
    }

    @Override
    public void drawHandlers(Handler[] handlers, AffineTransform at, ISymbol symbol) {
        for (int i = 0; i < handlers.length; ++i) {
            try {
                Point2D point = handlers[i].getPoint();
                at.transform(point, point);
                this.graphics.setPaintMode();
                this.graphics.setColor(symbol.getColor());
                this.graphics.fillRect((int)(point.getX() - 3.0), (int)(point.getY() - 3.0), 7, 7);
                this.graphics.drawRect((int)(point.getX() - 5.0), (int)(point.getY() - 5.0), 10, 10);
                this.graphics.drawString("" + i, (int)(point.getX() - 5.0), (int)(point.getY() - 5.0));
                continue;
            }
            catch (Throwable th) {
                LOG.warn("Unexpected error while drawing handler: " + th.getMessage(), th);
            }
        }
    }

    @Override
    public void drawLine(Point2D firstPoint, Point2D endPoint, ISymbol symbol) {
        try {
            Line line = this.geomManager.createLine(0);
            line.addVertex(firstPoint.getX(), firstPoint.getY());
            line.addVertex(endPoint.getX(), endPoint.getY());
            AffineTransform at = this.viewPort.getAffineTransform();
            symbol.draw(this.graphics, at, (Geometry)line, null, null);
        }
        catch (Exception e) {
            LOG.warn("Cant draw line.", (Throwable)e);
        }
    }

    @Override
    public void drawImage(Image img, int x, int y) {
        if (img != null) {
            this.graphics.drawImage(img, x, y, null);
        }
    }

    @Override
    public void drawHandler(Handler handler, AffineTransform at) {
        Point2D point = handler.getPoint();
        Point2D dest = (Point2D)point.clone();
        at.transform(point, dest);
        this.graphics.setColor(Color.black);
        this.graphics.drawLine((int)dest.getX() - 2, (int)dest.getY() - 10, (int)dest.getX() - 2, (int)dest.getY() + 10);
        this.graphics.drawLine((int)dest.getX() + 2, (int)dest.getY() - 10, (int)dest.getX() + 2, (int)dest.getY() + 10);
        this.graphics.drawLine((int)dest.getX() - 10, (int)dest.getY() - 2, (int)dest.getX() + 10, (int)dest.getY() - 2);
        this.graphics.drawLine((int)dest.getX() - 10, (int)dest.getY() + 2, (int)dest.getX() + 10, (int)dest.getY() + 2);
        this.graphics.setColor(Color.red);
        this.graphics.drawLine((int)dest.getX() - 1, (int)dest.getY() - 10, (int)dest.getX() - 1, (int)dest.getY() + 10);
        this.graphics.drawLine((int)dest.getX() + 1, (int)dest.getY() - 10, (int)dest.getX() + 1, (int)dest.getY() + 10);
        this.graphics.drawLine((int)dest.getX() - 10, (int)dest.getY() - 1, (int)dest.getX() + 10, (int)dest.getY() - 1);
        this.graphics.drawLine((int)dest.getX() - 10, (int)dest.getY() + 1, (int)dest.getX() + 10, (int)dest.getY() + 1);
    }

    @Override
    public void drawImage(Image img, AffineTransform xform) {
        this.graphics.drawImage(img, xform, null);
    }

    @Override
    public void setViewPort(ViewPort viewPort) {
        this.viewPort = viewPort;
    }

    @Override
    public void draw(Geometry geometry) {
        this.draw(geometry, MapContextLocator.getSymbolManager().createSymbol(geometry.getType()));
    }

    @Override
    public void setComposite(Composite composite) {
        this.graphics.setComposite(composite);
    }

    @Override
    public void transform(AffineTransform at) {
        this.graphics.transform(at);
    }
}

