/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.japura.Application;
import org.japura.controller.AbstractController;
import org.japura.controller.ControllerManager;
import org.japura.controller.ControllerModel;
import org.japura.controller.DebugControllers;
import org.japura.controller.DefaultModalPanelFactory;
import org.japura.controller.Lock;
import org.japura.controller.Message;
import org.japura.controller.ModalAction;
import org.japura.controller.ModalPanelFactory;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugWindow;
import org.japura.modal.Modal;
import org.japura.modal.ModalEvent;
import org.japura.modal.ModalListener;

public abstract class Controller<V extends Component>
extends AbstractController {
    private static ModalPanelFactory modalPanelFactory = new DefaultModalPanelFactory();

    static ControllerManager getCurrentManager() {
        return Application.getControllerManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsLink(ControllerModel controller1, ControllerModel controller2) {
        Lock.lock();
        try {
            boolean bl = Controller.getCurrentManager().existsLink(controller1, controller2);
            return bl;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsLink(ControllerModel controller, Class<?> clss) {
        Lock.lock();
        try {
            boolean bl = Controller.getCurrentManager().existsLink(controller, clss);
            return bl;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void link(ControllerModel controller1, ControllerModel controller2) {
        Lock.lock();
        try {
            Controller.getCurrentManager().link(controller1, controller2);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlink(ControllerModel controller1, ControllerModel controller2) {
        Lock.lock();
        try {
            Controller.getCurrentManager().unlink(controller1, controller2);
        }
        finally {
            Lock.unlock();
        }
    }

    public static DebugComponent createDebugPanel() {
        DebugControllers component = new DebugControllers();
        DebugComponent.add(component);
        Controller.updateDebugComponents();
        return component;
    }

    public static void showDebugWindow() {
        DebugWindow.showDebugWindow(Controller.createDebugPanel());
        Controller.updateDebugComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void free(String id) {
        Lock.lock();
        try {
            Controller.getCurrentManager().remove(id);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void free(String id, boolean cancelTaskExecution) {
        Lock.lock();
        try {
            Controller.getCurrentManager().remove(id, cancelTaskExecution);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeGroup(String groupdId) {
        Lock.lock();
        try {
            Controller.getCurrentManager().removeGroup(groupdId);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeAll(Class<?> clss) {
        Lock.lock();
        try {
            Controller.getCurrentManager().removeAll(clss);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeAllFromGroup(String groupId, Class<?> clss) {
        Lock.lock();
        try {
            Controller.getCurrentManager().removeAllFromGroup(groupId, clss);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstancied(Class<?> clss) {
        Lock.lock();
        try {
            boolean bl = Controller.getCurrentManager().isInstancied(clss);
            return bl;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstanciedInGroup(String groupId, Class<?> clss) {
        Lock.lock();
        try {
            boolean bl = Controller.getCurrentManager().isInstanciedInGroup(groupId, clss);
            return bl;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeAll() {
        Lock.lock();
        try {
            Controller.getCurrentManager().removeAll();
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int count(Class<?> clss) {
        Lock.lock();
        try {
            int n = Controller.getCurrentManager().count(clss);
            return n;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E get(Class<E> clss) {
        Lock.lock();
        try {
            E e = Controller.getCurrentManager().get(clss);
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E get(String id, Class<E> clss) {
        Lock.lock();
        try {
            E e = Controller.getCurrentManager().get(id, clss);
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E getFromGroup(String groupId, Class<E> clss) {
        Lock.lock();
        try {
            E e = Controller.getCurrentManager().getFromGroup(groupId, clss);
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E getFromGroup(String groupId, String id, Class<E> clss) {
        Lock.lock();
        try {
            E e = Controller.getCurrentManager().getFromGroup(groupId, clss);
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerModel getFromGroup(String groupId, String id) {
        Lock.lock();
        try {
            ControllerModel controllerModel = Controller.getCurrentManager().getFromGroup(groupId, id);
            return controllerModel;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> List<E> getAllFromGroup(String groupId, Class<E> clss) {
        Lock.lock();
        try {
            List<E> list = Controller.getCurrentManager().getAllFromGroup(groupId, clss);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ControllerModel> getAllFromGroup(String groupId) {
        Lock.lock();
        try {
            List<ControllerModel> list = Controller.getCurrentManager().getAllFromGroup(groupId);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerModel get(String id) {
        Lock.lock();
        try {
            ControllerModel controllerModel = Controller.getCurrentManager().get(id);
            return controllerModel;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> List<E> getAll(Class<E> clss) {
        Lock.lock();
        try {
            List<E> list = Controller.getCurrentManager().getAll(clss);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ControllerModel> getAll() {
        Lock.lock();
        try {
            List<ControllerModel> list = Controller.getCurrentManager().getAll();
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    public static void setModalPanelFactory(ModalPanelFactory modalPanelFactory) {
        if (modalPanelFactory != null) {
            Controller.modalPanelFactory = modalPanelFactory;
        }
    }

    public static ModalPanelFactory getModalPanelFactory() {
        return modalPanelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(ControllerModel controller) {
        Lock.lock();
        try {
            boolean bl = Controller.getCurrentManager().contains(controller);
            return bl;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printAllControllers() {
        Lock.lock();
        try {
            Controller.getCurrentManager().printAllControllers();
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ControllerModel getRoot(String groupId) {
        Lock.lock();
        try {
            ControllerModel controllerModel = Controller.getCurrentManager().getRoot(groupId);
            return controllerModel;
        }
        finally {
            Lock.unlock();
        }
    }

    public static void updateDebugComponents() {
        if (DebugComponent.exists(DebugControllers.class)) {
            DebugControllers.Parameter parameter = new DebugControllers.Parameter();
            DebugComponent.publish(DebugControllers.class, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlink(ControllerModel controller) {
        Lock.lock();
        try {
            Controller.getCurrentManager().unlink(controller);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> E getFromLink(ControllerModel controllerInLink, Class<E> clss) {
        Lock.lock();
        try {
            E e = Controller.getCurrentManager().getFromLink(controllerInLink, clss);
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    private static List<RootPaneContainer> getRootPaneContainers(String groupId) {
        ArrayList<RootPaneContainer> list = new ArrayList<RootPaneContainer>();
        for (ControllerModel controller : Controller.getAll()) {
            Controller c;
            RootPaneContainer rootPane;
            if (!controller.getGroupId().equals(groupId) || (rootPane = (c = (Controller)controller).getRootPaneContainer()) == null || list.contains(rootPane)) continue;
            list.add(rootPane);
        }
        return list;
    }

    private static RootPaneContainer getRootPaneContainer(Controller<?> controller) {
        Object comp = controller.getComponent();
        if (comp != null) {
            if (comp instanceof RootPaneContainer) {
                return (RootPaneContainer)comp;
            }
            for (Container p = ((Component)comp).getParent(); p != null; p = p.getParent()) {
                if (!(p instanceof RootPaneContainer)) continue;
                return (RootPaneContainer)((Object)p);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishToAll(Message message) {
        Lock.lock();
        try {
            Controller.getCurrentManager().publishToAll(message);
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <E> E newInstance(Class<E> clss) {
        Lock.lock();
        try {
            E e = Controller.getCurrentManager().newInstance(clss);
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(ControllerModel controller) {
        Lock.lock();
        try {
            Controller.getCurrentManager().add(controller);
        }
        finally {
            Lock.unlock();
        }
    }

    @Override
    protected void beforeFreeController() {
    }

    @Override
    protected void afterFreeController() {
        if (this.isComponentInstancied() && this.getComponent() instanceof Window) {
            Runnable disposer = new Runnable(){

                @Override
                public void run() {
                    Window window = (Window)Controller.this.getComponent();
                    window.dispose();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                disposer.run();
            } else {
                SwingUtilities.invokeLater(disposer);
            }
        }
    }

    @Override
    public Window getWindowAncestor() {
        if (this.isComponentInstancied()) {
            if (this.getComponent() instanceof Window) {
                return (Window)this.getComponent();
            }
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            if (window != null) {
                return window;
            }
        }
        return null;
    }

    @Override
    public void requestWindowFocus() {
        Window window = this.getWindowAncestor();
        if (window != null) {
            window.requestFocus();
        }
    }

    @Override
    public boolean isWindowFocused() {
        Window window = this.getWindowAncestor();
        if (window != null) {
            return window.isFocused();
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.isComponentInstancied()) {
            ((Component)this.getComponent()).requestFocus();
        }
    }

    @Override
    public boolean isFocused() {
        if (this.isComponentInstancied()) {
            return ((Component)this.getComponent()).isFocusOwner();
        }
        return false;
    }

    protected abstract V getComponent();

    @Override
    public void showQuestionModal(String title, String question, ModalAction yesAction, ModalAction noAction) {
        this.addModal(modalPanelFactory.buildQuestionPanel(this, title, question, yesAction, noAction));
    }

    @Override
    public void showQuestionModal(String title, String question, ModalAction yesAction) {
        this.addModal(modalPanelFactory.buildQuestionPanel(this, title, question, yesAction, null));
    }

    @Override
    public void showConfirmationModal(String title, String question, ModalAction confirmAction, ModalAction cancelAction) {
        this.addModal(modalPanelFactory.buildConfirmationPanel(this, title, question, confirmAction, cancelAction));
    }

    @Override
    public void showConfirmationModal(String title, String question, ModalAction confirmAction) {
        this.addModal(modalPanelFactory.buildConfirmationPanel(this, title, question, confirmAction, null));
    }

    @Override
    public void showInformationModal(String title, String info) {
        this.addModal(modalPanelFactory.buildInformationPanel(this, title, info));
    }

    @Override
    public void showWarningModal(String title, String warning) {
        this.addModal(modalPanelFactory.buildWarningPanel(this, title, warning));
    }

    @Override
    public void showErrorModal(String title, String error) {
        this.addModal(modalPanelFactory.buildErrorPanel(this, title, error));
    }

    @Override
    public void addModal(Component component) {
        this.addModal(component, null);
    }

    @Override
    public void addModal(Component component, ModalListener listener) {
        this.addModal(component, listener, null);
    }

    @Override
    public void addModal(Component component, ModalListener listener, Integer modalDepth) {
        RootPaneContainer rootPane = this.getRootPaneContainer();
        if (rootPane == null) {
            return;
        }
        if (rootPane instanceof JFrame) {
            Modal.addModal((JFrame)rootPane, component, listener, modalDepth);
        } else if (rootPane instanceof JDialog) {
            Modal.addModal((JDialog)rootPane, component, listener, modalDepth);
        } else if (rootPane instanceof JInternalFrame) {
            Modal.addModal((JInternalFrame)rootPane, component, listener, modalDepth);
        } else {
            return;
        }
        List<RootPaneContainer> rootPanes = Controller.getRootPaneContainers(this.getGroupId());
        if (this.getModalGroupName() != null) {
            String groupName = this.getModalGroupName().toLowerCase();
            for (ControllerModel controller : Controller.getAll()) {
                Controller c;
                RootPaneContainer rootPaneTemp;
                String groupNameTemp;
                if (controller.getModalGroupName() == null || !groupName.equals(groupNameTemp = controller.getModalGroupName().toLowerCase()) || (rootPaneTemp = (c = (Controller)controller).getRootPaneContainer()) == null || rootPanes.contains(rootPaneTemp)) continue;
                rootPanes.add(rootPaneTemp);
            }
        }
        rootPanes.remove(rootPane);
        ArrayList<Component> list = new ArrayList<Component>();
        for (RootPaneContainer otherRootPane : rootPanes) {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            list.add(panel);
            if (otherRootPane instanceof JFrame) {
                Modal.addModal((JFrame)otherRootPane, (Component)panel, null, modalDepth);
                continue;
            }
            if (!(otherRootPane instanceof JDialog)) continue;
            Modal.addModal((JDialog)otherRootPane, (Component)panel, null, modalDepth);
        }
        if (rootPane instanceof JFrame) {
            Modal.addListener((JFrame)rootPane, component, (ModalListener)new ModalAllFramesListener(list));
        } else if (rootPane instanceof JDialog) {
            Modal.addListener((JDialog)rootPane, component, (ModalListener)new ModalAllFramesListener(list));
        }
    }

    @Override
    public Component getCurrentModal() {
        RootPaneContainer rootPane = this.getRootPaneContainer();
        if (rootPane != null) {
            if (rootPane instanceof JFrame) {
                return Modal.getCurrentModal((JFrame)rootPane);
            }
            if (rootPane instanceof JDialog) {
                return Modal.getCurrentModal((JDialog)rootPane);
            }
        }
        return null;
    }

    public void closeCurrentModal() {
        RootPaneContainer rootPane = this.getRootPaneContainer();
        if (rootPane != null) {
            if (rootPane instanceof JFrame) {
                Modal.closeCurrentModal((JFrame)rootPane);
            } else if (rootPane instanceof JDialog) {
                Modal.closeCurrentModal((JDialog)rootPane);
            }
        }
    }

    @Override
    public void closeModal(Component component) {
        Modal.closeModal(component);
    }

    @Override
    public void closeAllModals() {
        RootPaneContainer rootPane = this.getRootPaneContainer();
        if (rootPane != null) {
            if (rootPane instanceof JFrame) {
                Modal.closeAllModals((JFrame)rootPane);
            } else if (rootPane instanceof JDialog) {
                Modal.closeAllModals((JDialog)rootPane);
            }
        }
    }

    @Override
    public boolean hasModal() {
        RootPaneContainer rootPane = this.getRootPaneContainer();
        if (rootPane == null) {
            return false;
        }
        if (rootPane instanceof JFrame) {
            return Modal.hasModal((JFrame)rootPane);
        }
        if (rootPane instanceof JDialog) {
            return Modal.hasModal((JDialog)rootPane);
        }
        return false;
    }

    private RootPaneContainer getRootPaneContainer() {
        return Controller.getRootPaneContainer(this);
    }

    protected void cancelTasks() {
        Application.getTaskManager().cancel(this.getGroupId());
    }

    @Override
    public void repaint() {
        if (this.isComponentInstancied()) {
            ((Component)this.getComponent()).repaint();
        }
    }

    private static class ModalAllFramesListener
    implements ModalListener {
        private List<Component> components;

        public ModalAllFramesListener(List<Component> components) {
            this.components = components;
        }

        @Override
        public void modalClosed(ModalEvent event) {
            for (Component component : this.components) {
                Modal.closeModal(component);
            }
        }
    }
}

