/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller.modals;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.japura.controller.ModalAction;
import org.japura.controller.modals.AbstractPanel;
import org.japura.gui.Images;

public class QuestionPanel
extends AbstractPanel {
    private static final long serialVersionUID = -874624949595966544L;
    private JPanel buttonsPanel;
    private JButton confirmButton;
    private JButton cancelButton;
    private ModalAction confirmAction;
    private ModalAction cancelAction;

    public QuestionPanel(String title, String text, ModalAction confirmAction) {
        this(title, text, confirmAction, null);
    }

    public QuestionPanel(String title, String text, ModalAction confirmAction, ModalAction cancelAction) {
        super(title, text, new ImageIcon(Images.QUESTION));
        this.confirmAction = confirmAction;
        this.cancelAction = cancelAction;
    }

    @Override
    protected JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setName("buttonsPanel");
            this.buttonsPanel.setLayout(new FlowLayout(2, 5, 0));
            this.buttonsPanel.setOpaque(false);
            this.buttonsPanel.add(this.getConfirmButton());
            this.buttonsPanel.add(this.getCancelButton());
        }
        return this.buttonsPanel;
    }

    private JButton getConfirmButton() {
        if (this.confirmButton == null) {
            this.confirmButton = new JButton();
            this.confirmButton.setName("confirmButton");
            this.confirmButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuestionPanel.this.closeModal();
                    if (QuestionPanel.this.confirmAction != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                QuestionPanel.this.confirmAction.executeAction(QuestionPanel.this);
                            }
                        });
                    }
                }
            });
        }
        return this.confirmButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setName("cancelButton");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuestionPanel.this.closeModal();
                    if (QuestionPanel.this.cancelAction != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                QuestionPanel.this.cancelAction.executeAction(QuestionPanel.this);
                            }
                        });
                    }
                }
            });
        }
        return this.cancelButton;
    }

    public void setCancelButtonText(String text) {
        this.getCancelButton().setText(text);
    }

    public void setConfirmButtonText(String text) {
        this.getConfirmButton().setText(text);
    }

    @Override
    protected JComponent getContent() {
        return null;
    }
}

