/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class ToolTipButton
extends JPanel {
    private static final long serialVersionUID = 2679673685756193717L;
    private static Color DEFAULT_BACKGROUND = new Color(255, 255, 220);
    private Color borderColor = Color.BLACK;
    private Color toolTipBackground;
    private Icon image;
    private Icon imageMouseOver;
    private int toolTipWrapWidth = 300;
    private JLabel imageComponent;
    private Insets margin;
    private int borderThickness = 2;
    private Timer timer;
    private String text;

    public ToolTipButton(Icon image) {
        this(image, null, null, DEFAULT_BACKGROUND);
    }

    public ToolTipButton(Icon image, String tooltip) {
        this(image, null, tooltip, DEFAULT_BACKGROUND);
    }

    public ToolTipButton(Icon image, Icon imageMouseOver, String tooltip) {
        this(image, imageMouseOver, tooltip, DEFAULT_BACKGROUND);
    }

    public ToolTipButton(Icon image, Icon imageMouseOver, String tooltip, Color toolTipBackground) {
        this.setTooltipMargin(null);
        this.setLayout(new GridBagLayout());
        this.imageComponent = new JLabel(image);
        this.add(this.imageComponent);
        this.image = image;
        this.imageMouseOver = imageMouseOver;
        this.toolTipBackground = toolTipBackground;
        this.setText(tooltip);
        this.setOpaque(false);
        ToolTipEvent tte = new ToolTipEvent();
        this.timer = new Timer(2000, tte);
        this.addMouseListener(tte);
        if (imageMouseOver != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ToolTipButton.this.imageComponent.setIcon(ToolTipButton.this.imageMouseOver);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ToolTipButton.this.imageComponent.setIcon(ToolTipButton.this.image);
                }
            });
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
    }

    @Override
    public void setToolTipText(String text) {
        this.setText(text);
    }

    public int getTooltipDelay() {
        return this.timer.getInitialDelay();
    }

    public void setTooltipDelay(int delay) {
        this.timer.setInitialDelay(delay);
    }

    public Insets getTooltipMargin() {
        return this.margin;
    }

    public void setTooltipMargin(Insets margin) {
        if (margin == null) {
            margin = new Insets(10, 10, 10, 10);
        }
        margin.bottom = Math.max(margin.bottom, 0);
        margin.top = Math.max(margin.top, 0);
        margin.right = Math.max(margin.right, 0);
        margin.left = Math.max(margin.left, 0);
        this.margin = margin;
    }

    public void setTooltipBorderThickness(int thickness) {
        this.borderThickness = Math.max(0, thickness);
    }

    public int getTooltipBorderThickness() {
        return this.borderThickness;
    }

    public Color getTooltipBorderColor() {
        return this.borderColor;
    }

    public void setTooltipBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getToolTipBackground() {
        return this.toolTipBackground;
    }

    public void setToolTipBackground(Color toolTipBackground) {
        this.toolTipBackground = toolTipBackground;
    }

    public int getToolTipWrapWidth() {
        return this.toolTipWrapWidth;
    }

    public void setToolTipWrapWidth(int toolTipWrapWidth) {
        this.toolTipWrapWidth = Math.max(200, toolTipWrapWidth);
    }

    private static class Wrap
    extends JTextPane {
        private static final long serialVersionUID = 2849635511260534304L;
        private View view;
        private int width;

        public Wrap(int width) {
            this.width = width;
            this.setText("");
            this.setContentType("text/html");
            this.setOpaque(false);
            this.setEditable(false);
            this.setEnabled(false);
            this.setDisabledTextColor(Color.BLACK);
        }

        private void setHTMLFont(Font font) {
            MutableAttributeSet attrs = this.getInputAttributes();
            StyleConstants.setFontFamily(attrs, font.getFamily());
            StyleConstants.setFontSize(attrs, font.getSize());
            StyleConstants.setForeground(attrs, this.getForeground());
            StyledDocument doc = this.getStyledDocument();
            doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            this.view = BasicHTML.createHTMLView(this, t);
            this.setHTMLFont(this.getFont());
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            this.view.setSize(this.width, 0.0f);
            Insets insets = this.getInsets();
            Insets margin = this.getMargin();
            float w = this.view.getPreferredSpan(0) + (float)insets.left + (float)insets.right + (float)margin.left + (float)margin.right;
            float h = this.view.getPreferredSpan(1) + (float)insets.bottom + (float)insets.top + (float)margin.bottom + (float)margin.top;
            return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
        }
    }

    private class ToolTipEvent
    extends MouseAdapter
    implements ActionListener {
        private JPopupMenu popup;

        private ToolTipEvent() {
        }

        private void disposeWindow() {
            if (this.popup != null) {
                this.popup.setVisible(false);
                this.popup = null;
            }
        }

        private void showHint() {
            this.disposeWindow();
            Wrap tooltipLabel = new Wrap(ToolTipButton.this.toolTipWrapWidth);
            tooltipLabel.setForeground(ToolTipButton.this.getForeground());
            tooltipLabel.setFont(ToolTipButton.this.getFont());
            tooltipLabel.setText(ToolTipButton.this.text);
            Border out = BorderFactory.createLineBorder(ToolTipButton.this.borderColor, ToolTipButton.this.borderThickness);
            Border in = BorderFactory.createEmptyBorder(((ToolTipButton)ToolTipButton.this).margin.top, ((ToolTipButton)ToolTipButton.this).margin.left, ((ToolTipButton)ToolTipButton.this).margin.bottom, ((ToolTipButton)ToolTipButton.this).margin.right);
            CompoundBorder border = BorderFactory.createCompoundBorder(out, in);
            tooltipLabel.setBorder(border);
            tooltipLabel.setBackground(ToolTipButton.this.toolTipBackground);
            tooltipLabel.setOpaque(true);
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            this.popup.add(tooltipLabel);
            this.popup.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    ToolTipEvent.this.disposeWindow();
                }
            });
            this.popup.show(ToolTipButton.this, 0, ToolTipButton.this.getHeight());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTipButton.this.timer.stop();
            this.showHint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ToolTipButton.this.timer.start();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ToolTipButton.this.timer.stop();
            this.showHint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ToolTipButton.this.timer.stop();
            if (this.popup != null) {
                if (this.popup.isShowing()) {
                    Point los = ToolTipButton.this.getLocationOnScreen();
                    Dimension dim = ToolTipButton.this.getSize();
                    Rectangle2D.Double hbBounds = new Rectangle2D.Double(los.getX(), los.getY(), dim.getWidth(), dim.getHeight());
                    los = this.popup.getLocationOnScreen();
                    dim = this.popup.getSize();
                    Rectangle2D.Double popupBounds = new Rectangle2D.Double(los.getX(), los.getY(), dim.getWidth(), dim.getHeight());
                    if (!popupBounds.contains(hbBounds)) {
                        this.disposeWindow();
                    }
                } else {
                    this.disposeWindow();
                }
            }
        }
    }
}

