/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task.ui;

import java.util.HashMap;
import org.japura.controller.Controller;
import org.japura.task.Task;
import org.japura.task.ui.GroupUIFactory;
import org.japura.task.ui.ModalProgressBarUI;
import org.japura.task.ui.TaskExecutionUI;

public class DefaultTaskExecutionUI
implements TaskExecutionUI {
    private GroupUIFactory groupUIFactory = new DefaultGroupUIFactory();
    private HashMap<String, Integer> tasksCount;
    private int globalTasksCount;
    private TaskExecutionUI globalTaskExecutionUI = null;
    private HashMap<String, TaskExecutionUI> groupUIs = new HashMap();

    public DefaultTaskExecutionUI() {
        this.tasksCount = new HashMap();
    }

    @Override
    public synchronized void submitted(Task<?> task) {
        if (task.isCanceled()) {
            return;
        }
        TaskExecutionUI taskExecutionUI = null;
        Controller<?> controller = this.getController(task);
        if (controller != null) {
            String groupId = controller.getGroupId();
            Integer count = this.tasksCount.get(groupId);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            this.tasksCount.put(groupId, count);
            taskExecutionUI = this.groupUIs.get(groupId);
            if (taskExecutionUI == null && (taskExecutionUI = this.getGroupUIFactory().buildTaskExecutionUI(groupId)) != null) {
                this.groupUIs.put(groupId, taskExecutionUI);
            }
        } else {
            ++this.globalTasksCount;
            taskExecutionUI = this.globalTaskExecutionUI;
        }
        if (taskExecutionUI != null) {
            taskExecutionUI.submitted(task);
        }
    }

    @Override
    public synchronized void beforeExecute(Task<?> task) {
        TaskExecutionUI taskExecutionUI = null;
        Controller<?> controller = this.getController(task);
        if (controller != null) {
            String groupId = controller.getGroupId();
            taskExecutionUI = this.groupUIs.get(groupId);
        } else {
            taskExecutionUI = this.globalTaskExecutionUI;
        }
        if (taskExecutionUI != null) {
            taskExecutionUI.beforeExecute(task);
        }
    }

    @Override
    public synchronized void afterExecute(Task<?> task) {
        TaskExecutionUI taskExecutionUI = null;
        Controller<?> controller = this.getController(task);
        if (controller != null) {
            Integer count;
            String groupId = controller.getGroupId();
            taskExecutionUI = this.groupUIs.get(groupId);
            Integer n = count = this.tasksCount.get(groupId);
            Integer n2 = count = Integer.valueOf(count - 1);
            if (count == 0) {
                this.tasksCount.remove(groupId);
                this.groupUIs.remove(groupId);
            } else {
                this.tasksCount.put(groupId, count);
            }
        } else {
            taskExecutionUI = this.globalTaskExecutionUI;
            --this.globalTasksCount;
            if (this.globalTasksCount == 0) {
                this.globalTaskExecutionUI = null;
            }
        }
        if (taskExecutionUI != null) {
            taskExecutionUI.afterExecute(task);
        }
    }

    private Controller<?> getController(Task<?> task) {
        Controller c;
        if (task.getRootModel() != null && (c = task.rootModelTo(Controller.class)) != null && Controller.contains(c)) {
            return c;
        }
        return null;
    }

    public TaskExecutionUI getGlobalTaskExecutionUI() {
        return this.globalTaskExecutionUI;
    }

    public void setGlobalTaskExecutionUI(TaskExecutionUI taskExecutionUI) {
        this.globalTaskExecutionUI = taskExecutionUI;
    }

    public void setGroupUIFactory(GroupUIFactory factory) {
        this.groupUIFactory = factory;
    }

    public GroupUIFactory getGroupUIFactory() {
        return this.groupUIFactory;
    }

    public static class DefaultGroupUIFactory
    implements GroupUIFactory {
        @Override
        public TaskExecutionUI buildTaskExecutionUI(String groupId) {
            return new ModalProgressBarUI(groupId);
        }
    }
}

