/*
 * Decompiled with CFR 0.152.
 */
package org.japura.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class WeakList<T>
extends AbstractList<T> {
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final List<WeakReference<T>> list = new ArrayList<WeakReference<T>>();

    @Override
    public boolean add(T obj) {
        this.expungeStaleEntries();
        return this.list.add(new WeakReference<T>(obj, this.queue));
    }

    @Override
    public T get(int index) {
        this.expungeStaleEntries();
        return this.list.get(index).get();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.list.size();
    }

    @Override
    public T remove(int index) {
        return this.list.remove(index).get();
    }

    private void expungeStaleEntries() {
        Reference<T> garbagedObj = this.queue.poll();
        while (garbagedObj != null) {
            int index = this.list.indexOf(garbagedObj);
            if (index != -1) {
                this.list.remove(index);
            }
            garbagedObj = this.queue.poll();
        }
    }
}

