/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.base.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.geoprocess.algorithm.base.core.DALFeaturePersister;
import org.gvsig.geoprocess.core.IProgressModel;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.task.SimpleTaskStatus;

public abstract class GeometryOperation {
    protected DALFeaturePersister persister = null;
    protected FeatureStore inFeatureStore = null;
    protected ArrayList<FeatureStore> inFeatureStoreList = null;
    protected int numberOfFeatures = 0;
    protected EditableFeature lastEditFeature = null;
    protected SimpleTaskStatus status = null;
    protected AbstractSextanteGeoProcess process = null;
    protected boolean selectedGeomInput = false;
    protected boolean selectedGeomOverlay = false;
    protected int procesSize = 0;

    public GeometryOperation(AbstractSextanteGeoProcess process) {
        this.process = process;
    }

    public void setSelectedGeomOverlayLayer(boolean setSelected) {
        this.selectedGeomOverlay = setSelected;
    }

    public abstract EditableFeature invoke(Geometry var1, Feature var2);

    public abstract void invoke(Geometry var1, EditableFeature var2);

    public void setFeatureStore(FeatureStore out, String[] attrNames) throws DataException {
        this.persister = new DALFeaturePersister(out, attrNames, this.process.getNamesTranslator());
    }

    public Object getResult() {
        return this.lastEditFeature;
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureStore outFeatStore, String[] attrNames, boolean selectedGeomInput, boolean selectedGeomOverlay, boolean closeOutStore) throws DataException {
        this.computesGeometryOperation(inFeatStore, null, outFeatStore, attrNames, selectedGeomInput, selectedGeomOverlay, closeOutStore);
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureQuery query, FeatureStore outFeatStore, String[] attrNames, boolean selectedGeomInput, boolean selectedGeomOverlay, boolean closeOutStore) throws DataException {
        this.inFeatureStore = inFeatStore;
        FeatureSet featuresSet = null;
        this.selectedGeomInput = selectedGeomInput;
        this.selectedGeomOverlay = selectedGeomOverlay;
        if (outFeatStore != null) {
            this.setFeatureStore(outFeatStore, attrNames);
        }
        DisposableIterator it = null;
        featuresSet = this.selectedGeomInput ? (FeatureSet)inFeatStore.getSelection() : (query != null && this.process.queryImprovePerformance(inFeatStore) ? inFeatStore.getFeatureSet(query) : inFeatStore.getFeatureSet());
        it = featuresSet.iterator();
        this.numberOfFeatures = (int)featuresSet.getSize();
        if (this.status != null && this.process != null) {
            this.status.setRangeOfValues(0L, (long)this.numberOfFeatures);
            this.process.setProgress(0, this.numberOfFeatures);
        }
        int iCount = 0;
        while (it.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
            Feature feature = (Feature)it.next();
            List geomList = feature.getGeometries();
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
            if (geomList == null) {
                Geometry geom = feature.getDefaultGeometry();
                if (geom == null) continue;
                this.invoke(geom, feature);
                continue;
            }
            Iterator itGeom = geomList.iterator();
            boolean first = true;
            EditableFeature editFeat = null;
            while (itGeom.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
                Geometry g = (Geometry)itGeom.next();
                if (first) {
                    editFeat = this.invoke(g, feature);
                    first = false;
                    continue;
                }
                this.invoke(g, editFeat);
            }
        }
        this.process.setProgress(iCount, this.numberOfFeatures);
        if (closeOutStore && this.persister != null) {
            this.persister.end();
        }
    }

    public void computesGeometryOperation(FeatureStore inFeatStore, FeatureQuery query, FeatureStore outFeatStorePolygon, FeatureStore outFeatStoreLine, FeatureStore outFeatStorePoint, String[] attrNames, boolean selectedGeomInput, boolean selectedGeomOverlay, boolean closeOutStore) throws DataException {
        DALFeaturePersister persisterPolygon = null;
        DALFeaturePersister persisterLine = null;
        DALFeaturePersister persisterPoint = null;
        this.inFeatureStore = inFeatStore;
        FeatureSet featuresSet = null;
        this.selectedGeomInput = selectedGeomInput;
        this.selectedGeomOverlay = selectedGeomOverlay;
        if (outFeatStorePolygon != null) {
            this.setFeatureStore(outFeatStorePolygon, attrNames);
            persisterPolygon = this.persister;
        }
        if (outFeatStoreLine != null) {
            this.setFeatureStore(outFeatStoreLine, attrNames);
            persisterLine = this.persister;
        }
        if (outFeatStorePoint != null) {
            this.setFeatureStore(outFeatStorePoint, attrNames);
            persisterPoint = this.persister;
        }
        DisposableIterator it = null;
        featuresSet = this.selectedGeomInput ? (FeatureSet)inFeatStore.getSelection() : (query != null && this.process.queryImprovePerformance(inFeatStore) ? inFeatStore.getFeatureSet(query) : inFeatStore.getFeatureSet());
        it = featuresSet.iterator();
        this.numberOfFeatures = (int)featuresSet.getSize();
        if (this.status != null && this.process != null) {
            this.status.setRangeOfValues(0L, (long)this.numberOfFeatures);
            this.process.setProgress(0, this.numberOfFeatures);
        }
        int iCount = 0;
        while (it.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
            Feature feature = (Feature)it.next();
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
            Geometry geom = feature.getDefaultGeometry();
            if (geom == null) continue;
            if (persisterPolygon != null) {
                this.persister = persisterPolygon;
                this.invoke(geom, feature);
            }
            if (persisterLine != null) {
                this.persister = persisterLine;
                this.invoke(geom, feature);
            }
            if (persisterPoint == null) continue;
            this.persister = persisterPoint;
            this.invoke(geom, feature);
        }
        this.process.setProgress(iCount, this.numberOfFeatures);
        if (closeOutStore && this.persister != null) {
            this.persister.end();
        }
    }

    public void computesFeatureOperation(FeatureStore inFeatStore, FeatureStore outFeatStore, String[] attrNames, boolean selectedGeomInput, boolean selectedGeomOverlay, boolean closeOutStore) throws DataException {
        this.inFeatureStore = inFeatStore;
        FeatureSet featuresSet = null;
        featuresSet = inFeatStore.getFeatureSet();
        this.selectedGeomInput = selectedGeomInput;
        this.selectedGeomOverlay = selectedGeomOverlay;
        if (outFeatStore != null) {
            this.setFeatureStore(outFeatStore, attrNames);
        }
        DisposableIterator it = null;
        if (this.selectedGeomInput) {
            DataSet ds = inFeatStore.getSelection();
            it = ((FeatureSelection)ds).fastIterator();
        } else {
            it = featuresSet.fastIterator();
        }
        this.numberOfFeatures = (int)featuresSet.getSize();
        if (this.status != null && this.process != null) {
            this.status.setRangeOfValues(0L, (long)this.numberOfFeatures);
            this.process.setProgress(0, this.numberOfFeatures);
        }
        int iCount = 0;
        while (it.hasNext() && !this.process.getTaskMonitor().isCanceled()) {
            Feature feature = (Feature)it.next();
            this.invoke(null, feature);
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
        }
        if (closeOutStore && this.persister != null) {
            this.persister.end();
        }
    }

    public void computesGeometryOperationInAList(ArrayList<FeatureStore> inFeatStoreList, FeatureStore outFeatStore, String[] attrNames, boolean selectedGeomInput, boolean selectedGeomOverlay, boolean closeOutStore) throws DataException {
        this.inFeatureStoreList = inFeatStoreList;
        this.selectedGeomInput = selectedGeomInput;
        this.selectedGeomOverlay = selectedGeomOverlay;
        if (this.status != null && this.process != null) {
            this.status.setRangeOfValues(0L, (long)inFeatStoreList.size());
            this.process.setProgress(0, inFeatStoreList.size());
        }
        int iCount = 0;
        for (int i = 0; i < inFeatStoreList.size(); ++i) {
            if (this.status != null && this.process != null) {
                this.status.setCurValue((long)iCount);
                this.process.setProgress(iCount, this.numberOfFeatures);
            }
            ++iCount;
            this.computesGeometryOperation(inFeatStoreList.get(i), (FeatureStore)(i == 0 ? outFeatStore : null), attrNames, selectedGeomInput, selectedGeomOverlay, false);
            if (!this.process.getTaskMonitor().isCanceled()) continue;
            return;
        }
        if (closeOutStore && this.persister != null) {
            this.persister.end();
        }
    }

    public void end() {
        this.persister.end();
    }

    public void setProgressModel(IProgressModel pModel) {
    }

    public void setTaskStatus(SimpleTaskStatus status) {
        this.status = status;
    }

    public void setGeoProcess(AbstractSextanteGeoProcess geoprocess, int size) {
        this.process = geoprocess;
        this.procesSize = size;
    }
}

