/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.base.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import org.cresques.Messages;
import org.slf4j.LoggerFactory;

public class JTSFacade {
    public static Geometry computeBuffer(Geometry originalGeometry, double distance) {
        return EnhancedPrecisionOp.buffer((Geometry)originalGeometry, (double)distance);
    }

    public static Geometry difference(Geometry geom1, Geometry geom2) {
        return EnhancedPrecisionOp.difference((Geometry)geom1, (Geometry)geom2);
    }

    public static Geometry symDifference(Geometry geom1, Geometry geom2) {
        return EnhancedPrecisionOp.symDifference((Geometry)geom1, (Geometry)geom2);
    }

    public static Geometry union(Geometry geom1, Geometry geom2) {
        try {
            return EnhancedPrecisionOp.union((Geometry)geom1, (Geometry)geom2);
        }
        catch (TopologyException e) {
            LoggerFactory.getLogger(JTSFacade.class).error(Messages.getText((String)"topological_problems"), (Throwable)e);
            return geom1;
        }
    }

    public static Geometry union(Geometry[] geomArray, int geometryType) {
        if (geomArray.length == 0) {
            return null;
        }
        if (geomArray.length == 1) {
            return geomArray[0];
        }
        if (geometryType == 3 || geometryType == 11 || geometryType == 13) {
            GeometryFactory fact = geomArray[0].getFactory();
            GeometryCollection geomCol = fact.createGeometryCollection(geomArray);
            return JTSFacade.computeBuffer((Geometry)geomCol, 0.0);
        }
        Geometry unionResult = geomArray[0];
        for (int i = 1; i < geomArray.length; ++i) {
            unionResult = JTSFacade.union(unionResult, geomArray[i]);
        }
        return unionResult;
    }

    public static Geometry intersection(Geometry geom1, Geometry geom2) {
        return EnhancedPrecisionOp.intersection((Geometry)geom1, (Geometry)geom2);
    }

    public static boolean checkNull(Geometry geometry) {
        GeometryCollection col;
        if (geometry == null) {
            return true;
        }
        return geometry instanceof GeometryCollection && (col = (GeometryCollection)geometry).getNumGeometries() < 1;
    }
}

