/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.ogc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.net.Downloader;
import org.gvsig.remoteclient.ogc.OGCServiceInformation;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class OGCProtocolHandler {
    protected static final Downloader downloader = CompatLocator.getDownloader();
    protected String name;
    protected String version;
    protected String host;
    protected String port;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public abstract boolean parseCapabilities(File var1);

    public abstract OGCServiceInformation getServiceInformation();

    protected static String getSymbol(String h) {
        String symbol = h.indexOf("?") == -1 ? "?" : (h.indexOf("?") != h.length() - 1 ? "&" : "");
        return symbol;
    }

    protected void parserDcpType(KXmlParser parser, String operation) throws XmlPullParserException, IOException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("HTTP") != 0) break;
                    this.parseHTTPTag(parser, operation);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("DCPType") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    protected void parseHTTPTag(KXmlParser parser, String operation) throws XmlPullParserException, IOException {
        boolean end = false;
        int currentTag = parser.next();
        int protocol = -1;
        while (!end) {
            switch (currentTag) {
                case 2: {
                    Object value = null;
                    if (parser.getName().compareTo("Get") == 0) {
                        protocol = 0;
                        this.addOperationByAttribute(parser, operation, protocol);
                        break;
                    }
                    if (parser.getName().compareTo("Post") == 0) {
                        protocol = 1;
                        this.addOperationByAttribute(parser, operation, protocol);
                        break;
                    }
                    if (parser.getName().compareTo("OnlineResource") != 0) break;
                    this.addOperationByAttribute(parser, operation, protocol);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("HTTP") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    protected void addOperationByAttribute(KXmlParser parser, String operation, int protocol) {
        String value = null;
        if (protocol > -1) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                if (parser.getAttributeName(i).toUpperCase().compareTo("OnlineResource".toUpperCase()) != 0 && !parser.getAttributeName(i).equals("xlink:href")) continue;
                value = parser.getAttributeValue(i);
            }
            if (value == null) {
                this.getServiceInformation().addOperation(operation, protocol);
            } else {
                this.getServiceInformation().addOperation(operation, protocol, value);
            }
        }
    }

    protected byte[] fileToBytes(File file) throws IOException {
        byte[] bytes = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            long length = file.length();
            bytes = new byte[(int)file.length()];
            int numRead = 0;
            for (int offset = 0; offset < bytes.length && (numRead = fis.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        return bytes;
    }
}

