/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.utils;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.net.Downloader;
import org.gvsig.compat.net.ICancellable;

public class Utilities {
    private static final Downloader downloader = CompatLocator.getDownloader();
    private static String characters;
    static boolean canceled;
    static final long latency = 500L;
    static Hashtable canceledGroup;
    private static Hashtable downloadedFiles;
    static Exception downloadException;
    private static final String tempDirectoryPath;

    public static boolean isTextFile(File file) {
        return Utilities.isTextFile(file, 1024);
    }

    public static boolean isTextFile(File file, int byteAmount) {
        int umbral = byteAmount;
        try {
            FileReader fr = new FileReader(file);
            for (int i = 0; i < umbral; ++i) {
                int c = fr.read();
                if (c == -1) {
                    return true;
                }
                char ch = (char)c;
                if (characters.indexOf(ch) != -1) continue;
                return false;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean isTextData(byte[] data) {
        int i;
        char[] charData = new char[data.length];
        for (i = 0; i < data.length; ++i) {
            charData[i] = (char)data[i];
        }
        for (i = 0; i < data.length; ++i) {
            char c = charData[i];
            if (c == '\uffffffff') {
                return true;
            }
            char ch = c;
            if (characters.indexOf(ch) != -1) continue;
            return false;
        }
        return true;
    }

    public static void serializar(InputStream in, OutputStream out) {
        byte[] buffer = new byte[102400];
        try {
            int n;
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] eliminarDTD(byte[] bytes, String startTag) {
        int index2;
        String text = new String(bytes);
        int index1 = text.indexOf("?>") + 2;
        try {
            index2 = Utilities.findBeginIndex(bytes, startTag);
        }
        catch (Exception e) {
            return bytes;
        }
        byte[] buffer = new byte[bytes.length - (index2 - index1)];
        System.arraycopy(bytes, 0, buffer, 0, index1);
        System.arraycopy(bytes, index2, buffer, index1, bytes.length - index2);
        return buffer;
    }

    private static int findBeginIndex(byte[] bytes, String tagRaiz) throws Exception {
        try {
            int nodo = 0;
            int ret = -1;
            int i = 0;
            while (true) {
                switch (nodo) {
                    case 0: {
                        if (bytes[i] != 60) break;
                        ret = i;
                        nodo = 1;
                        break;
                    }
                    case 1: {
                        if (bytes[i] == 32) break;
                        if (bytes[i] == tagRaiz.charAt(0)) {
                            nodo = 2;
                            break;
                        }
                        nodo = 0;
                        break;
                    }
                    case 2: {
                        String aux = new String(bytes, i, 18);
                        if (aux.equalsIgnoreCase(tagRaiz.substring(1))) {
                            return ret;
                        }
                        nodo = 0;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("No se pudo parsear el xml", e);
        }
    }

    public static String Vector2CS(Vector v) {
        String str = new String();
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                str = str + v.elementAt(i);
                if (i >= v.size() - 1) continue;
                str = str + ",";
            }
        }
        return str;
    }

    public static boolean isValidVersion(String version) {
        if (version.trim().length() == 5) {
            if (version.charAt(1) == '.' && version.charAt(3) == '.') {
                char x = version.charAt(0);
                char y = version.charAt(2);
                char z = version.charAt(4);
                return Character.isDigit(x) && Character.isDigit(y) && Character.isDigit(z);
            }
            return false;
        }
        return false;
    }

    public static void createTemp(String fileName, String data) throws IOException {
        File f = new File(fileName);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
        dos.writeBytes(data);
        dos.close();
        f.deleteOnExit();
    }

    public static boolean isNumber(String s) {
        try {
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Vector createVector(String str, String c) {
        StringTokenizer tokens = new StringTokenizer(str, c);
        Vector<String> v = new Vector<String>();
        try {
            while (tokens.hasMoreTokens()) {
                v.addElement(tokens.nextToken());
            }
            return v;
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    public static String Vector2URLParamString(Vector v) {
        if (v == null) {
            return "";
        }
        String s = "";
        for (int i = 0; i < v.size(); ++i) {
            s = s + v.get(i);
            if (i >= v.size() - 1) continue;
            s = s + "&";
        }
        return s;
    }

    public static synchronized File downloadFile(URL url, String name, ICancellable cancel) throws IOException, ConnectException, UnknownHostException {
        return downloader.downloadFile(url, name, cancel);
    }

    private static String calculateFileName(String name) {
        int index = name.lastIndexOf(".");
        if (index > 0) {
            return tempDirectoryPath + "/" + name.substring(0, index) + System.currentTimeMillis() + name.substring(index, name.length());
        }
        return tempDirectoryPath + "/" + name + System.currentTimeMillis();
    }

    public static synchronized File downloadFile(URL url, String data, String name, ICancellable cancel) throws IOException, ConnectException, UnknownHostException {
        return downloader.downloadFile(url, data, name, cancel);
    }

    public static synchronized File downloadFile(URL url, String data, String name, ICancellable cancel, int maxbytes) throws IOException, ConnectException, UnknownHostException {
        return downloader.downloadFile(url, data, name, cancel, maxbytes);
    }

    public static void cleanUpTempFiles() {
        downloader.cleanUpTempFiles();
    }

    public static void removeURL(URL url) {
        downloader.removeURL(url);
    }

    public static void removeURL(Object url) {
        downloader.removeURL(url);
    }

    public static String getAbsolutePathOrEmpty(File f) {
        if (f == null) {
            return "";
        }
        return f.getAbsolutePath();
    }

    static {
        canceledGroup = new Hashtable();
        tempDirectoryPath = System.getProperty("java.io.tmpdir") + "/tmp-andami";
        characters = "";
        for (int j = 32; j <= 127; ++j) {
            characters = characters + (char)j;
        }
        characters = characters + "\u00e1\u00e0\u00c1\u00c0\u00e4\u00c4\u00e2\u00c2\u00e9\u00c9\u00e8\u00c8\u00eb\u00cb\u00ea\u00ca\u00ed\u00ec\u00cd\u00cc\u00ef\u00cf\u00ee\u00ce\u00f3\u00d3\u00f2\u00d2\u00f6\u00d6\u00f4\u00d4\u00fa\u00f9\u00da\u00d9\u00fc\u00dc\u00fb\u00db\u00f1\u00d1\u00e7\u00c7\u00a1\u00bf\u00b7\u00aa\u00ba\u0080\n\r\f\t\u00ab\u00bb";
    }
}

