/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.ellipse;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class FilledEllipseCenterAxesEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected EditingServiceParameter center;
    protected EditingServiceParameter pointAxisA;
    protected EditingServiceParameter lengthSemiaxisB;
    protected Map<EditingServiceParameter, Object> values;
    protected FeatureStore featureStore;

    public FilledEllipseCenterAxesEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.center = new DefaultEditingServiceParameter("center", "center", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.pointAxisA = new DefaultEditingServiceParameter("point_A_axis", "point_A_axis", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.lengthSemiaxisB = new DefaultEditingServiceParameter("length_of_B_semiaxis", "length_of_B_semiaxis", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.center) == null) {
            return this.center;
        }
        if (this.values.get(this.pointAxisA) == null) {
            return this.pointAxisA;
        }
        if (this.values.get(this.lengthSemiaxisB) == null) {
            return this.lengthSemiaxisB;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        drawingStatus.setPreviewSymbol(previewSymbol);
        if (this.values != null) {
            EditingProviderServices editingServiceProvider = this.getProviderServices();
            Point centerValue = (Point)this.values.get(this.center);
            Point pointAxis1Value = (Point)this.values.get(this.pointAxisA);
            if (centerValue != null) {
                drawingStatus.addStatus((Geometry)centerValue, auxiliaryPointSymbolEditing, "");
                if (pointAxis1Value == null) {
                    try {
                        int subtype = editingServiceProvider.getSubType(this.featureStore);
                        Line line = editingServiceProvider.createLine(centerValue, mousePosition, subtype);
                        drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                        drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                        return drawingStatus;
                    }
                    catch (Exception e) {
                        throw new DrawServiceException((Throwable)e);
                    }
                }
                try {
                    int subtype = editingServiceProvider.getSubType(this.featureStore);
                    drawingStatus.addStatus((Geometry)pointAxis1Value, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)centerValue, auxiliaryPointSymbolEditing, "");
                    Line aAxis = editingServiceProvider.createLine(centerValue, pointAxis1Value, subtype);
                    drawingStatus.addStatus((Geometry)aAxis, auxiliaryLineSymbolEditing, "");
                    Point firstPointAxis1 = this.calculateOpositePointAxis(centerValue, pointAxis1Value, subtype);
                    EuclideanLine2D semiAxisA = euclideanManager.createLine2D(centerValue.getX(), centerValue.getY(), pointAxis1Value.getX(), pointAxis1Value.getY());
                    EuclideanLine2D semiAxisB = semiAxisA.getPerpendicular(centerValue.getX(), centerValue.getY());
                    Point2D pointAxisB = semiAxisB.getNearestPoint(mousePosition.getX(), mousePosition.getY());
                    double distance = semiAxisA.getDistance(mousePosition.getX(), mousePosition.getY());
                    this.addTemporaryGeometryToDrawingStatus(drawingStatus, firstPointAxis1, pointAxis1Value, subtype, distance);
                    Line line = editingServiceProvider.createLine(centerValue.getX(), centerValue.getY(), pointAxisB.getX(), pointAxisB.getY(), subtype);
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)aAxis, auxiliaryLineSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
        }
        return drawingStatus;
    }

    protected void addTemporaryGeometryToDrawingStatus(DefaultDrawingStatus drawingStatus, Point firstPointAxis1Value, Point secondPointAxis1Value, int subtype, double distance) throws CreateGeometryException {
        Ellipse ellipse = (Ellipse)GeometryLocator.getGeometryManager().create(13, subtype);
        ellipse.setPoints(firstPointAxis1Value, secondPointAxis1Value, distance);
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        drawingStatus.addStatus((Geometry)ellipse, polygonSymbolEditing, "");
        drawingStatus.addStatus((Geometry)ellipse, drawingStatus.getPreviewSymbol(), "");
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.center);
        list.add(this.pointAxisA);
        list.add(this.lengthSemiaxisB);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        if (param == this.center || param == this.pointAxisA) {
            if (value instanceof Point) {
                this.values.put(param, value);
            }
        } else if (param == this.lengthSemiaxisB) {
            if (value instanceof Point) {
                Double length = null;
                try {
                    EditingProviderServices editingProviderServices = this.getProviderServices();
                    Point centerValue = (Point)this.values.get(this.center);
                    Point pointAxisAValue = (Point)this.values.get(this.pointAxisA);
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    EuclideanLine2D lineAxisA = euclideanManager.createLine2D(centerValue.getX(), centerValue.getY(), pointAxisAValue.getX(), pointAxisAValue.getY());
                    length = lineAxisA.getDistance(((Point)value).getX(), ((Point)value).getY());
                }
                catch (DataException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
                this.values.put(param, length);
            } else if (value instanceof Double && (Double)value - 0.01 > 0.0) {
                this.values.put(param, value);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            Point centerValue = (Point)this.values.get(this.center);
            Point pointAxis1Value = (Point)this.values.get(this.pointAxisA);
            double lengthSemiaxis2Value = (Double)this.values.get(this.lengthSemiaxisB);
            if (this.center != null && pointAxis1Value != null && lengthSemiaxis2Value > 0.0) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    GeometryType storeGeomType = editingProviderServices.getGeomType(this.featureStore);
                    Ellipse ellipse = (Ellipse)GeometryLocator.getGeometryManager().create(13, subtype);
                    Point firstPointAxis = this.calculateOpositePointAxis(centerValue, pointAxis1Value, subtype);
                    ellipse.setPoints(firstPointAxis, pointAxis1Value, lengthSemiaxis2Value);
                    return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)ellipse);
                }
                catch (Exception e) {
                    throw new FinishServiceException((Throwable)e);
                }
            }
        }
        return null;
    }

    protected Point calculateOpositePointAxis(Point centerValue, Point pointAxis1Value, int subtype) throws CreateGeometryException, LocatorException {
        Point oppositePointAxis = (Point)GeometryLocator.getGeometryManager().create(1, subtype);
        oppositePointAxis.setX(centerValue.getX() - (pointAxis1Value.getX() - centerValue.getX()));
        oppositePointAxis.setY(centerValue.getY() - (pointAxis1Value.getY() - centerValue.getY()));
        return oppositePointAxis;
    }

    public void finishAndStore() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = this.finish();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-filled-ellipse-center-axes";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

