/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.ellipse;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class FilledEllipseEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected EditingServiceParameter firstPointAxisA;
    protected EditingServiceParameter secondPointAxisA;
    protected EditingServiceParameter lengthSemiAxisB;
    protected Map<EditingServiceParameter, Object> values;
    protected FeatureStore featureStore;

    public FilledEllipseEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.firstPointAxisA = new DefaultEditingServiceParameter("first_point_A_axis", "first_point_A_axis", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPointAxisA = new DefaultEditingServiceParameter("second_point_A_axis", "second_point_A_axis", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.lengthSemiAxisB = new DefaultEditingServiceParameter("length_of_B_semiaxis", "length_of_B_semiaxis", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.firstPointAxisA) == null) {
            return this.firstPointAxisA;
        }
        if (this.values.get(this.secondPointAxisA) == null) {
            return this.secondPointAxisA;
        }
        if (this.values.get(this.lengthSemiAxisB) == null) {
            return this.lengthSemiAxisB;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        drawingStatus.setPreviewSymbol(previewSymbol);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        if (this.values != null) {
            EditingProviderServices editingServiceProvider = this.getProviderServices();
            Point firstPointAxis1Value = (Point)this.values.get(this.firstPointAxisA);
            Point secondPointAxis1Value = (Point)this.values.get(this.secondPointAxisA);
            if (firstPointAxis1Value != null) {
                drawingStatus.addStatus((Geometry)firstPointAxis1Value, auxiliaryPointSymbolEditing, "");
                if (secondPointAxis1Value == null) {
                    try {
                        int subtype = editingServiceProvider.getSubType(this.featureStore);
                        Line line = editingServiceProvider.createLine(firstPointAxis1Value, mousePosition, subtype);
                        drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                        drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                        return drawingStatus;
                    }
                    catch (Exception e) {
                        throw new DrawServiceException((Throwable)e);
                    }
                }
                try {
                    int subtype = editingServiceProvider.getSubType(this.featureStore);
                    Point center = editingServiceProvider.getMidPoint(firstPointAxis1Value, secondPointAxis1Value, subtype);
                    drawingStatus.addStatus((Geometry)secondPointAxis1Value, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)center, auxiliaryPointSymbolEditing, "");
                    Line aAxis = editingServiceProvider.createLine(firstPointAxis1Value, secondPointAxis1Value, subtype);
                    drawingStatus.addStatus((Geometry)aAxis, auxiliaryLineSymbolEditing, "");
                    EuclideanLine2D lineAxisA = euclideanManager.createLine2D(firstPointAxis1Value.getX(), firstPointAxis1Value.getY(), secondPointAxis1Value.getX(), secondPointAxis1Value.getY());
                    double distance = lineAxisA.getDistance(mousePosition.getX(), mousePosition.getY());
                    this.addTemporaryGeometryToDrawingStatus(drawingStatus, firstPointAxis1Value, secondPointAxis1Value, subtype, distance);
                    EuclideanLine2D lineAxisB = lineAxisA.getPerpendicular(center.getX(), center.getY());
                    Point2D pointAxisB = lineAxisB.getNearestPoint(mousePosition.getX(), mousePosition.getY());
                    Line line = editingServiceProvider.createLine(center.getX(), center.getY(), pointAxisB.getX(), pointAxisB.getY(), subtype);
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)aAxis, auxiliaryLineSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
        }
        return drawingStatus;
    }

    protected void addTemporaryGeometryToDrawingStatus(DefaultDrawingStatus drawingStatus, Point firstPointAxis1Value, Point secondPointAxis1Value, int subtype, double distance) throws CreateGeometryException {
        Ellipse ellipse = (Ellipse)GeometryLocator.getGeometryManager().create(13, subtype);
        ellipse.setPoints(firstPointAxis1Value, secondPointAxis1Value, distance);
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        drawingStatus.addStatus((Geometry)ellipse, polygonSymbolEditing, "");
        drawingStatus.addStatus((Geometry)ellipse, drawingStatus.getPreviewSymbol(), "");
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.firstPointAxisA);
        list.add(this.secondPointAxisA);
        list.add(this.lengthSemiAxisB);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        if (param == this.firstPointAxisA || param == this.secondPointAxisA) {
            if (value instanceof Point) {
                this.values.put(param, value);
            }
        } else if (param == this.lengthSemiAxisB) {
            if (value instanceof Point) {
                Double length = null;
                try {
                    EditingProviderServices editingProviderServices = this.getProviderServices();
                    Point firstPointAxis1Value = (Point)this.values.get(this.firstPointAxisA);
                    Point secondPointAxis1Value = (Point)this.values.get(this.secondPointAxisA);
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    Point center = GeometryUtils.getMidPoint((Point)firstPointAxis1Value, (Point)secondPointAxis1Value, (int)subtype);
                    EuclideanLine2D lineAxisA = euclideanManager.createLine2D(firstPointAxis1Value.getX(), firstPointAxis1Value.getY(), secondPointAxis1Value.getX(), secondPointAxis1Value.getY());
                    length = lineAxisA.getDistance(((Point)value).getX(), ((Point)value).getY());
                }
                catch (Exception e) {
                    throw new InvalidEntryException((Throwable)e);
                }
                if (length != null) {
                    this.values.put(param, length);
                }
            } else if (value instanceof Double && (Double)value - 0.01 > 0.0) {
                this.values.put(param, value);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            Point firstPointAxis1Value = (Point)this.values.get(this.firstPointAxisA);
            Point secondPointAxis1Value = (Point)this.values.get(this.secondPointAxisA);
            double lengthSemiaxis2Value = (Double)this.values.get(this.lengthSemiAxisB);
            if (firstPointAxis1Value != null && secondPointAxis1Value != null && lengthSemiaxis2Value > 0.0) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    GeometryType storeGeomType = editingProviderServices.getGeomType(this.featureStore);
                    Ellipse ellipse = (Ellipse)GeometryLocator.getGeometryManager().create(13, subtype);
                    ellipse.setPoints(firstPointAxis1Value, secondPointAxis1Value, lengthSemiaxis2Value);
                    return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)ellipse);
                }
                catch (Exception e) {
                    throw new FinishServiceException((Throwable)e);
                }
            }
        }
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = this.finish();
        editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-filled-ellipse";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

