/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.dxf.service;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.dxf.service.ExportDXFParameters;
import org.gvsig.export.spi.AbstractExportService;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.tools.util.HasAFile;

public class ExportDXFService
extends AbstractExportService
implements ExportService {
    public static final int MAX_FIELD_NAME_LENGTH = 10;

    protected ExportDXFService(ExportServiceFactory factory, ExportDXFParameters parameters) {
        super(factory, (ExportParameters)parameters);
    }

    public ExportDXFParameters getParameters() {
        return (ExportDXFParameters)super.getParameters();
    }

    protected DataServerExplorer createServerExplorer() throws ExportException {
        FilesystemServerExplorerParameters explorerParams;
        DataManager dataManager = DALLocator.getDataManager();
        try {
            explorerParams = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
        explorerParams.setRoot(this.getParameters().getFile().getParent());
        try {
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)explorerParams);
            return explorer;
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
    }

    protected NewDataStoreParameters createTargetNewStoreParameters() throws ExportException {
        try {
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)this.createServerExplorer();
            NewFeatureStoreParameters newStoreParameters = (NewFeatureStoreParameters)explorer.getAddParameters(this.getParameters().getEvaluatedFile());
            newStoreParameters.setDynValue("CRS", (Object)this.getParameters().getTargetProjection());
            return newStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    public OpenDataStoreParameters createTargetOpenStoreParameters() throws ExportException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            OpenFeatureStoreParameters openStoreParameters = (OpenFeatureStoreParameters)dataManager.createStoreParameters("DXF");
            ((HasAFile)openStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            openStoreParameters.setDynValue("CRS", (Object)this.getParameters().getTargetProjection());
            return openStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    protected void copyValues(Feature source, EditableFeature target) {
        FeatureType sourceType = source.getType();
        FeatureType targetType = target.getType();
        ExportAttributes exp = this.getParameters().getExportAttributes();
        boolean isActive = exp.isActive();
        for (FeatureAttributeDescriptor targetAttr : targetType) {
            FeatureAttributeDescriptor sourceAttr;
            String sourceAttrName;
            if (!target.canSetValue(targetAttr, null)) continue;
            String targetAttrName = targetAttr.getName();
            if (isActive) {
                sourceAttrName = exp.getSourceName(targetAttrName);
                for (ExportAttributes.ExportAttribute exportAttribute : exp) {
                    if (!StringUtils.equals((CharSequence)exportAttribute.getNewName(), (CharSequence)targetAttrName)) continue;
                    sourceAttrName = exportAttribute.getName();
                    break;
                }
                sourceAttr = sourceType.getAttributeDescriptorFromAll(sourceAttrName);
            } else {
                sourceAttrName = targetAttrName;
                sourceAttr = sourceType.getAttributeDescriptorFromAll(targetAttrName);
            }
            Object value = null;
            try {
                if (sourceAttr != null) {
                    value = source.get(sourceAttrName);
                    if (value == null) {
                        if (!targetAttr.allowNull()) continue;
                        target.set(targetAttrName, null);
                        continue;
                    }
                    target.set(targetAttrName, value);
                    continue;
                }
                if (!source.hasValue(sourceAttrName)) continue;
                value = source.get(sourceAttrName);
                target.set(targetAttrName, value);
            }
            catch (Throwable ex) {
                LOG.debug("Can't set value '" + Objects.toString(value) + " into '" + targetAttrName + "'", ex);
            }
        }
    }
}

