/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.basicformats.impl;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.basicformats.CLRFile;
import org.gvsig.basicformats.impl.AbstractFormatFile;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.api.colortable.ColorTable;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCLRFile
extends AbstractFormatFile
implements CLRFile {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCLRFile.class);
    private File source = null;
    private ColorTable colorTable = null;

    public File getFile(File file) {
        File f = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + "." + "clr");
        return f;
    }

    public File getFile() {
        return this.source;
    }

    @Override
    public ColorTable getColorTable() {
        return this.colorTable;
    }

    @Override
    public void setColorTable(ColorTable colorTable) {
        this.colorTable = colorTable;
    }

    public void read(File file) throws IOException {
        File f = this.getFile(file);
        if (f.exists()) {
            try {
                RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
                ArrayList<ColorTableClass> colors = new ArrayList<ColorTableClass>();
                List lines = FileUtils.readLines((File)f);
                if (lines != null) {
                    this.source = f.getAbsoluteFile();
                    int lineno = 1;
                    double interpolation = 50.0;
                    for (String line : lines) {
                        if (!Character.isDigit((line = line.trim()).charAt(0))) continue;
                        try {
                            String[] words = StringUtils.split((String)line);
                            if (words.length < 4) continue;
                            int value = Integer.parseInt(words[0]);
                            int r = Integer.parseInt(words[1]);
                            int g = Integer.parseInt(words[2]);
                            int b = Integer.parseInt(words[3]);
                            Color color = new Color(r, g, b);
                            ColorTableClass colorTableClass = legendManager.createColorTableClass(String.valueOf(value), value, interpolation, color);
                            colors.add(colorTableClass);
                        }
                        catch (Exception e) {
                            logger.warn("Can't parse line '" + line + "' (lineno=+" + lineno + ", file=" + f.getAbsoluteFile() + ").", (Throwable)e);
                        }
                    }
                }
                if (!colors.isEmpty()) {
                    String colorTableName = FilenameUtils.getBaseName((String)f.getName());
                    this.colorTable = legendManager.createColorTable(colorTableName, colors, true);
                }
            }
            catch (IOException e) {
                logger.warn("Couldn't read clr file (" + f.getAbsoluteFile() + ")", (Throwable)e);
                throw e;
            }
        }
    }

    public void write(File file) throws IOException {
        File f = this.getFile(file);
    }
}

