/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers;

import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;

public class LayerFactory {
    private static LayerFactory instance = null;

    public static LayerFactory getInstance() {
        if (instance == null) {
            instance = new LayerFactory();
        }
        return instance;
    }

    public boolean registerLayerToUseForStore(String dataStoreName, Class layerClassToUse) {
        throw new UnsupportedOperationException("This method is deprecated use MapContextMananer.registerLayer");
    }

    public boolean registerLayerToUseForStore(Class storeClass, Class layerClassToUse) {
        MapContextManager manager = MapContextLocator.getMapContextManager();
        manager.registerLayer(storeClass, layerClassToUse);
        return true;
    }

    public FLayer createLayer(String layerName, DataStoreParameters storeParameters) throws LoadLayerException {
        MapContextManager manager = MapContextLocator.getMapContextManager();
        return manager.createLayer(layerName, storeParameters);
    }

    public FLayer createLayer(String layerName, DataStore dataStore) throws LoadLayerException {
        MapContextManager manager = MapContextLocator.getMapContextManager();
        return manager.createLayer(layerName, dataStore);
    }

    private class CantRetrieveLayerByStoreException
    extends LoadLayerException {
        private static final long serialVersionUID = 1442450896900126712L;

        CantRetrieveLayerByStoreException(String layerName, String storeName) {
            super("Can't retrieve the class leyer of %(layer) to use for store %(store).", null, "_Cant_retrieve_the_class_leyer_of_XlayerX_to_use_for_store_XstoreX", 1442450896900126712L);
            this.setValue("layer", layerName);
            this.setValue("store", storeName);
        }
    }
}

