/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.AbstractCancellableTask;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialCache {
    private static final Logger logger = LoggerFactory.getLogger(SpatialCache.class);
    private int maxFeatures = 1000;
    private int fastNumTotalRegs = 0;
    private SpatialIndex index = null;
    private boolean overflown = false;
    private Map<String, Boolean> enabledContexts = new HashMap<String, Boolean>();
    private boolean enabled = false;
    private AbstractCancellableTask refreshTask = null;

    public SpatialCache() {
        try {
            this.index = GeometryLocator.getGeometryManager().createDefaultMemorySpatialIndex();
        }
        catch (Exception e) {
            logger.info("Can't create spatial index", (Throwable)e);
        }
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public synchronized void insert(Envelope bounds, Geometry geom) {
        if (this.isEnabled()) {
            if (this.getMaxFeatures() >= this.size()) {
                this.index.insert(bounds, (Object)geom);
                ++this.fastNumTotalRegs;
            } else {
                this.overflown = true;
            }
        }
    }

    public synchronized void query(Envelope searchEnv, Visitor visitor) {
        if (!this.isEnabled()) {
            return;
        }
        this.index.query(searchEnv, visitor);
    }

    public synchronized List query(Envelope searchEnv) {
        if (!this.isEnabled()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        Iterator it = this.index.query(searchEnv);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public synchronized void insert(Envelope itemEnv, Object item) {
        if (this.isEnabled()) {
            if (this.getMaxFeatures() >= this.size()) {
                this.index.insert(itemEnv, item);
                ++this.fastNumTotalRegs;
            } else {
                this.overflown = true;
            }
        }
    }

    public synchronized boolean remove(Envelope itemEnv, Object item) {
        boolean resul = this.index.remove(itemEnv, item);
        if (resul) {
            --this.fastNumTotalRegs;
        }
        return resul;
    }

    public int size() {
        return this.fastNumTotalRegs;
    }

    public synchronized void removeAll() {
        if (this.refreshTask != null) {
            this.refreshTask.cancelRequest();
        }
        this.index.removeAll();
        this.fastNumTotalRegs = 0;
        this.overflown = false;
    }

    public synchronized void remove(Envelope bounds, Geometry geom) {
        this.index.remove(bounds, (Object)geom);
    }

    public boolean isEnabled() {
        if (this.enabled) {
            return true;
        }
        for (Boolean value : this.enabledContexts.values()) {
            if (!value.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled(String contextId) {
        return this.enabledContexts.getOrDefault(contextId, false);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabled(String contextId, boolean enabled) {
        this.enabledContexts.put(contextId, enabled);
    }

    public boolean isOverflown() {
        return this.overflown;
    }

    public boolean isContextEnabled() {
        for (Boolean value : this.enabledContexts.values()) {
            if (!value.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public synchronized void refresh(final String name, final FeatureStore store, final Envelope envelope, final IProjection projection) {
        if (store == null || envelope == null || envelope.isEmpty() || envelope.isCollapsed() || projection == null) {
            return;
        }
        this.removeAll();
        this.refreshTask = new AbstractCancellableTask("SpatialCacheRefresh_" + name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block13: {
                    SimpleTaskStatus status;
                    Disposable it;
                    FeatureSet fset;
                    block12: {
                        I18nManager i18n = ToolsLocator.getI18nManager();
                        DisposeUtils.bind((Disposable)store);
                        fset = null;
                        it = null;
                        status = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus("SpatialCache " + name);
                        try {
                            status.setAutoremove(true);
                            status.add();
                            Evaluator evaluator = SpatialEvaluatorsFactory.getInstance().intersects(envelope, projection, store);
                            FeatureQuery query = store.createFeatureQuery();
                            query.addFilter(evaluator);
                            query.setLimit((long)SpatialCache.this.getMaxFeatures());
                            status.message(i18n.getTranslation("_Searching_geometries"));
                            fset = store.getFeatureSet(query);
                            status.setRangeOfValues(0L, fset.size64());
                            fset.accept(obj -> {
                                if (this.isCancellationRequested() || status.isCancellationRequested()) {
                                    status.cancel();
                                    throw new VisitCanceledException();
                                }
                                Feature feat = (Feature)obj;
                                Geometry geom = feat.getDefaultGeometry();
                                SpatialCache.this.insert(geom.getEnvelope(), geom);
                                status.incrementCurrentValue();
                                if (status.getCurValue() > (long)SpatialCache.this.getMaxFeatures()) {
                                    status.terminate();
                                    throw new VisitCanceledException();
                                }
                            });
                            status.terminate();
                            if (this != SpatialCache.this.refreshTask) break block12;
                        }
                        catch (VisitCanceledException evaluator) {
                            if (this == SpatialCache.this.refreshTask) {
                                SpatialCache.this.refreshTask = null;
                            }
                            if (status.isRunning()) {
                                status.terminate();
                            }
                            DisposeUtils.disposeQuietly(it);
                            DisposeUtils.disposeQuietly(fset);
                            DisposeUtils.disposeQuietly((Disposable)store);
                            break block13;
                        }
                        catch (Exception ex) {
                            logger.warn("Can't refresh spatial cache of '" + name + "'", (Throwable)ex);
                            status.abort();
                            break block13;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        finally {
                            if (this == SpatialCache.this.refreshTask) {
                                SpatialCache.this.refreshTask = null;
                            }
                            if (status.isRunning()) {
                                status.terminate();
                            }
                            DisposeUtils.disposeQuietly(it);
                            DisposeUtils.disposeQuietly(fset);
                            DisposeUtils.disposeQuietly((Disposable)store);
                        }
                        SpatialCache.this.refreshTask = null;
                    }
                    if (status.isRunning()) {
                        status.terminate();
                    }
                    DisposeUtils.disposeQuietly(it);
                    DisposeUtils.disposeQuietly((Disposable)fset);
                    DisposeUtils.disposeQuietly((Disposable)store);
                }
            }
        };
        this.refreshTask.setPriority(2);
        this.refreshTask.start();
    }
}

