/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontext.layers;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tiling {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(Tiling.class);
    private static final int MIN_SIZE = 50;
    private boolean debug = true;
    private int tileMaxWidth;
    private int tileMaxHeight;
    private int numRows;
    private int numCols;
    private double[][] srcPts;
    private Rectangle2D[] tile;
    private double width = 500.0;
    private double height = 500.0;
    private AffineTransform mat;
    private ViewPort vp;
    ViewPort[] viewPortList = null;

    public Tiling() {
    }

    public Tiling(int tileW, int tileH, Rectangle2D r) {
        int[] size = this.calcMaxTileSize(tileW, tileH, r);
        this.tileMaxWidth = size[0];
        this.tileMaxHeight = size[1];
        this.numCols = 1 + (int)r.getWidth() / this.tileMaxWidth;
        this.numRows = 1 + (int)r.getHeight() / this.tileMaxHeight;
        this.srcPts = new double[this.numCols * this.numRows][8];
        this.tile = new Rectangle2D[this.numCols * this.numRows];
        int yProv = (int)r.getY();
        for (int stepY = 0; stepY < this.numRows; ++stepY) {
            int altoAux = (double)(yProv + this.tileMaxHeight) > r.getMaxY() ? (int)r.getMaxY() - yProv : this.tileMaxHeight;
            int xProv = (int)r.getX();
            for (int stepX = 0; stepX < this.numCols; ++stepX) {
                int anchoAux = (double)(xProv + this.tileMaxWidth) > r.getMaxX() ? (int)r.getMaxX() - xProv : this.tileMaxWidth;
                int tileCnt = stepY * this.numCols + stepX;
                this.srcPts[tileCnt][0] = xProv;
                this.srcPts[tileCnt][1] = yProv;
                this.srcPts[tileCnt][2] = xProv + anchoAux + 1;
                this.srcPts[tileCnt][3] = yProv;
                this.srcPts[tileCnt][4] = xProv + anchoAux + 1;
                this.srcPts[tileCnt][5] = yProv + altoAux + 1;
                this.srcPts[tileCnt][6] = xProv;
                this.srcPts[tileCnt][7] = yProv + altoAux + 1;
                this.tile[tileCnt] = new Rectangle2D.Float(xProv, yProv, anchoAux + 1, altoAux + 1);
                xProv += this.tileMaxWidth;
            }
            yProv += this.tileMaxHeight;
        }
    }

    public int[] calcMaxTileSize(int tileW, int tileH, Rectangle2D r) {
        int h;
        int w;
        if (r.getWidth() < (double)tileW || r.getHeight() < (double)tileH) {
            int[] sizeTiles = new int[]{tileW, tileH};
            return sizeTiles;
        }
        int wLastCol = 0;
        tileW += 50;
        do {
            int numCols = (int)(r.getWidth() / (double)(tileW -= 50));
            w = 0;
            for (int i = 0; i < numCols; ++i) {
                w += tileW;
            }
        } while ((wLastCol = (int)r.getWidth() - w) < 50 && tileW > 100);
        int hLastRow = 0;
        tileH += 50;
        do {
            int numRows = (int)(r.getHeight() / (double)(tileH -= 50));
            h = 0;
            for (int i = 0; i < numRows; ++i) {
                h += tileH;
            }
        } while ((hLastRow = (int)r.getHeight() - h) < 50 && tileH > 100);
        this.tileMaxWidth = tileW;
        this.tileMaxHeight = tileH;
        int[] sizeTiles = new int[]{this.tileMaxWidth, this.tileMaxHeight};
        return sizeTiles;
    }

    public double[] getTilePts(int colNr, int rowNr) {
        return this.srcPts[rowNr * this.numCols + colNr];
    }

    public double[] getTilePts(int num) {
        return this.srcPts[num];
    }

    public Rectangle2D getTileSz(int colNr, int rowNr) {
        return this.tile[rowNr * this.numCols + colNr];
    }

    public Rectangle2D getTile(int num) {
        return this.tile[num];
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getNumRows() {
        return this.numRows;
    }

    public int getNumTiles() {
        return this.numRows * this.numCols;
    }

    public int getMaxTileHeight() {
        return this.tileMaxHeight;
    }

    public int getMaxTileWidth() {
        return this.tileMaxWidth;
    }

    private void calcViewPort(ViewPort viewPort) throws NoninvertibleTransformException {
        this.viewPortList = new ViewPort[this.numCols * this.numRows];
        int vpCnt = 0;
        double imgPxX = viewPort.getImageWidth();
        double dWcX = viewPort.getAdjustedExtent().getLength(0);
        double tileWcW = this.getTile(vpCnt).getWidth() * dWcX / imgPxX;
        double imgPxY = viewPort.getImageHeight();
        double dWcY = viewPort.getAdjustedExtent().getLength(1);
        double tileWcH = this.getTile(vpCnt).getHeight() * dWcY / imgPxY;
        try {
            this.viewPortList[0] = (ViewPort)viewPort.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("Error clonning the viewport", (Throwable)e);
            e.printStackTrace();
        }
        int auxw = (int)this.getTile(vpCnt).getWidth();
        int auxh = (int)this.getTile(vpCnt).getHeight();
        Dimension auxdim = new Dimension(auxw, auxh);
        this.viewPortList[0].setImageSize(auxdim);
        Envelope r = viewPort.getAdjustedExtent();
        try {
            this.viewPortList[0].setEnvelope(geomManager.createEnvelope(r.getMinimum(0), r.getMaximum(1) - tileWcH, r.getMinimum(0) + tileWcW, r.getMaximum(1), 0));
        }
        catch (CreateEnvelopeException e) {
            logger.error("Error setting the envelope", (Throwable)e);
            e.printStackTrace();
        }
        this.viewPortList[0].setAffineTransform(this.mat);
        double wt = tileWcW;
        double ht = tileWcH;
        double xt = viewPort.getAdjustedExtent().getMinimum(0);
        double yt = viewPort.getAdjustedExtent().getMaximum(1) - tileWcH;
        for (int stepY = 0; stepY < this.numRows; ++stepY) {
            wt = tileWcW;
            xt = viewPort.getAdjustedExtent().getMinimum(0);
            for (int stepX = 0; stepX < this.numCols; ++stepX) {
                vpCnt = stepY * this.numCols + stepX;
                if (vpCnt <= 0) continue;
                if (stepX > 0) {
                    xt += wt;
                }
                if (xt + wt > viewPort.getAdjustedExtent().getMaximum(0)) {
                    wt = Math.abs(viewPort.getAdjustedExtent().getMaximum(0) - xt);
                }
                try {
                    this.viewPortList[vpCnt] = (ViewPort)viewPort.clone();
                }
                catch (CloneNotSupportedException e) {
                    logger.error("Error clonning the viewport", (Throwable)e);
                    e.printStackTrace();
                }
                auxw = (int)this.getTile(vpCnt).getWidth();
                auxh = (int)this.getTile(vpCnt).getHeight();
                auxdim = new Dimension(auxw, auxh);
                this.viewPortList[vpCnt].setImageSize(auxdim);
                try {
                    this.viewPortList[vpCnt].setEnvelope(geomManager.createEnvelope(xt, yt, xt + wt, yt + ht, 0));
                }
                catch (CreateEnvelopeException e) {
                    logger.error("Error setting the envelope", (Throwable)e);
                    e.printStackTrace();
                }
                this.viewPortList[vpCnt].setAffineTransform(this.mat);
            }
            if (yt - ht < viewPort.getAdjustedExtent().getMinimum(1)) {
                ht = Math.abs(yt - viewPort.getAdjustedExtent().getMinimum(1));
                yt = viewPort.getAdjustedExtent().getMinimum(1);
                continue;
            }
            yt -= ht;
        }
    }

    public ViewPort getTileViewPort(ViewPort viewPort, int tileNr) throws NoninvertibleTransformException {
        if (this.tile.length == 1) {
            return viewPort;
        }
        double[] dstPts = new double[8];
        double[] srcPts = this.getTilePts(tileNr);
        Rectangle2D tile = this.getTile(tileNr);
        this.mat.inverseTransform(srcPts, 0, dstPts, 0, 4);
        double x = dstPts[0];
        double w = dstPts[2] - dstPts[0];
        double y = dstPts[1];
        double h = dstPts[5] - dstPts[3];
        if (w < 0.0) {
            x = dstPts[2];
            w = dstPts[0] - dstPts[2];
        }
        if (h < 0.0) {
            y = dstPts[5];
            h = dstPts[3] - dstPts[5];
        }
        Envelope rectCuadricula = null;
        try {
            rectCuadricula = geomManager.createEnvelope(x, y, x + w, y + h, 0);
        }
        catch (CreateEnvelopeException e) {
            logger.error("Error setting the envelope", (Throwable)e);
            e.printStackTrace();
        }
        ViewPort vp = null;
        try {
            vp = (ViewPort)viewPort.clone();
            int auxw = (int)tile.getWidth();
            int auxh = (int)tile.getHeight();
            Dimension auxdim = new Dimension(auxw, auxh);
            vp.setImageSize(auxdim);
            vp.setOffset(new Point2D.Double(tile.getX(), tile.getY()));
            vp.setEnvelope(rectCuadricula);
            if (this.debug) {
                System.out.println("Tiling.print(): tile " + tileNr + " de " + this.getNumTiles() + "\n, Extent = " + vp.getAdjustedExtent() + " tile: " + tile);
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error("Error clonning the viewport", (Throwable)e);
            e.printStackTrace();
        }
        return vp;
    }

    public AffineTransform getAffineTransform() {
        return this.mat;
    }

    public void setAffineTransform(AffineTransform mat) {
        this.mat = mat;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

