/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.spi;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.AbstractOperation;
import org.gvsig.raster.lib.legend.api.colorinterpretation.ColorInterpretation;
import org.gvsig.raster.lib.legend.api.operations.ColoredOperation;

public abstract class AbstractColoredOperation
extends AbstractOperation
implements ColoredOperation {
    private ColorInterpretation colorInterpretation;
    private ColorInterpretation outputColorInterpretation;

    public AbstractColoredOperation(OperationFactory factory) {
        super(factory);
    }

    protected ColorInterpretation getInputColorInterpretation() {
        return this.colorInterpretation;
    }

    protected ColorInterpretation getOutputColorInterpretation() {
        return this.outputColorInterpretation;
    }

    protected void setOutputColorInterpretation(ColorInterpretation theColorInterpretation) {
        this.outputColorInterpretation = theColorInterpretation;
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        this.colorInterpretation = (ColorInterpretation)this.getParameters().getDynValue("color_interpretation");
    }

    public void process() throws ProcessingOperationException {
        super.process();
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    protected boolean isProcessableBand(int band) {
        return true;
    }

    protected List<String> getProcessableBandColorInterpretations() {
        int bands = this.getInputBuffer().getBandCount();
        ArrayList<String> colorInterpretations = new ArrayList<String>();
        for (int band = 0; band < bands; ++band) {
            if (!this.isProcessableBand(band)) continue;
            colorInterpretations.add(this.colorInterpretation.get(band));
        }
        if (this.colorInterpretation.hasAlphaBand()) {
            colorInterpretations.add("Alpha");
        }
        return colorInterpretations;
    }

    protected String[] getProcessableBandColorInterpretationsAsArray() {
        List<String> l = this.getProcessableBandColorInterpretations();
        String[] colorInterpretations = this.getColorInterpretationsAsArray(l);
        return colorInterpretations;
    }

    private String[] getColorInterpretationsAsArray(List<String> theColorInterpretations) {
        String[] colorInterpretations = theColorInterpretations.toArray(new String[theColorInterpretations.size()]);
        return colorInterpretations;
    }

    protected List<NoData> getProcessableBandNoDatas() {
        int bands = this.getInputBuffer().getBandCount();
        ArrayList<NoData> noDatas = new ArrayList<NoData>();
        for (int band = 0; band < bands; ++band) {
            if (!this.isProcessableBand(band)) continue;
            noDatas.add(this.getInputBuffer().getBandNoData()[band]);
        }
        return noDatas;
    }

    protected NoData[] getProcessableBandNoDatasAsArray() {
        List<NoData> l = this.getProcessableBandNoDatas();
        NoData[] noDatas = this.getNoDatasAsArray(l);
        return noDatas;
    }

    protected NoData[] getNoDatasAsArray(List<NoData> theNoDatas) {
        NoData[] noDatas = theNoDatas.toArray(new NoData[theNoDatas.size()]);
        return noDatas;
    }

    protected List<Integer> getProcessableBandTypes() {
        int bands = this.getInputBuffer().getBandCount();
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (int band = 0; band < bands; ++band) {
            if (!this.isProcessableBand(band)) continue;
            types.add(this.getInputBuffer().getBandTypes()[band]);
        }
        return types;
    }

    protected int[] getProcessableBandTypesAsArray() {
        int[] types = this.getTypesAsArray(this.getProcessableBandTypes());
        return types;
    }

    protected int[] getTypesAsArray(List<Integer> theTypes) {
        int[] types = new int[theTypes.size()];
        int n = 0;
        for (Integer type : theTypes) {
            types[n++] = type;
        }
        return types;
    }
}

