/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportManager;
import org.gvsig.export.ExportParameters;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dynobject.DynObject;

public class ExportHistoryBookmarksExtension
extends Extension {
    public void initialize() {
        this.loadExportHistoryParameters();
        this.loadExportBookmarksParameters();
    }

    public void execute(String actionCommand) {
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void loadExportHistoryParameters() {
        PluginsManager pluginManager = PluginsLocator.getManager();
        final PluginServices plugin = pluginManager.getPlugin((Object)this);
        ExportManager exportManager = ExportLocator.getManager();
        final History history = exportManager.getHistory();
        pluginManager.addShutdownTask("saveExportHistory", new Runnable(){

            @Override
            public void run() {
                DynObject properties = plugin.getPluginProperties();
                ArrayList<ExportParameters> var = new ArrayList<ExportParameters>();
                if (history == null) {
                    return;
                }
                for (ExportParameters historyBookmark : history) {
                    if (historyBookmark != null) {
                        var.add(historyBookmark);
                        continue;
                    }
                    logger.warn("Trying to save history but value is null");
                }
                properties.setDynValue("exportHistory", var);
            }
        }, false, 100);
        DynObject pluginProperties = plugin.getPluginProperties();
        List dynBookmarks = (List)pluginProperties.getDynValue("exportHistory");
        if (dynBookmarks == null) {
            return;
        }
        for (ExportParameters exportParameters : dynBookmarks) {
            history.add((Object)exportParameters);
        }
    }

    private void loadExportBookmarksParameters() {
        PluginsManager pluginManager = PluginsLocator.getManager();
        final PluginServices plugin = pluginManager.getPlugin((Object)this);
        DynObject pluginProperties = plugin.getPluginProperties();
        ExportManager exportManager = ExportLocator.getManager();
        final Bookmarks bookmarks = exportManager.getBookmarks();
        pluginManager.addShutdownTask("saveExportBookmarks", new Runnable(){

            @Override
            public void run() {
                DynObject properties = plugin.getPluginProperties();
                HashMap<String, ExportParameters> var = new HashMap<String, ExportParameters>();
                for (Bookmark exportBookmark : bookmarks) {
                    ExportParameters value = (ExportParameters)exportBookmark.getValue();
                    if (value != null) {
                        var.put(exportBookmark.getName(), value);
                        continue;
                    }
                    logger.warn("Trying to save bookmark but value is null");
                }
                properties.setDynValue("exportBookmarks", var);
            }
        }, false, 100);
        Map dynBookmarks = (Map)pluginProperties.getDynValue("exportBookmarks");
        if (dynBookmarks == null) {
            return;
        }
        for (String key : dynBookmarks.keySet()) {
            ExportParameters bookmarkParameters = (ExportParameters)dynBookmarks.get(key);
            if (bookmarkParameters != null) {
                bookmarks.add(key, (Object)bookmarkParameters);
                continue;
            }
            logger.warn("Trying to add bookmark but value is null");
        }
    }
}

