/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension;

import java.awt.Dimension;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportManager;
import org.gvsig.export.ExportProcess;
import org.gvsig.export.Filter;
import org.gvsig.export.app.extension.ExportStoreFromCatalogAction;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.swing.ExportFinishListenerAdapter;
import org.gvsig.export.swing.ExportSwingLocator;
import org.gvsig.export.swing.ExportSwingManager;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class ExportLayerExtension
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-export", (Object)((Object)this));
    }

    public void postInitialize() {
        super.postInitialize();
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        ViewManager viewManager = (ViewManager)projectManager.getDocumentManager(ViewManager.TYPENAME);
        viewManager.addTOCContextAction("layer-exportto");
        this.registerInCatalog();
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String command, Object[] args) {
        if (!"exportto".equalsIgnoreCase(command)) {
            return;
        }
        Arguments arguments = Arguments.create((Object[])args);
        Object layer = arguments.get(0, FLyrVect.class, null);
        if (layer instanceof FLyrVect) {
            WindowManager.MODE mode = WindowManager.MODE.fromInteger((int)((Integer)arguments.get(1, Integer.class, (Object)0)));
            FLyrVect layervect = (FLyrVect)layer;
            MapContext mapContext = layervect.getMapContext();
            this.showExport(layervect, mapContext.getProjection(), mapContext, mode);
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (view != null) {
            MapContext mapContext = view.getMapContext();
            FLayers layers = mapContext.getLayers();
            FLayer[] actives = layers.getActives();
            try {
                if (actives.length == 1) {
                    if (actives[0] instanceof FLyrVect) {
                        this.showExport((FLyrVect)actives[0], mapContext.getProjection(), mapContext, WindowManager.MODE.WINDOW);
                    }
                } else {
                    for (FLayer theLayer : actives) {
                        if (!(layer instanceof FLyrVect)) continue;
                        this.showExport((FLyrVect)theLayer, mapContext.getProjection(), mapContext, WindowManager.MODE.DIALOG);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Can't run export wizard.", (Throwable)e);
            }
        }
    }

    public void showExport(FLyrVect layer, IProjection contextProjetion, final MapContext mapContext, WindowManager.MODE mode) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ExportManager manager = ExportLocator.getManager();
        ExportSwingManager swingManager = ExportSwingLocator.getSwingManager();
        final ExportProcess process = manager.createProcess();
        process.setContext((Object)mapContext);
        process.setSourceFeatureStore(layer.getFeatureStore());
        process.setContextProjection(contextProjetion);
        process.setSourceProjection(layer.getProjection());
        ICoordTrans ct = layer.getCoordTrans();
        if (ct == null) {
            process.setSourceTransformation(null);
        } else {
            process.setSourceProjection(ct.getPOrig());
            process.setSourceTransformation(ct);
        }
        JExportProcessPanel panel = swingManager.createJExportProcessPanel(process, (Filter)new Filter<ExportServiceFactory>(){

            public boolean apply(ExportServiceFactory factory) {
                return factory.hasVectorialSupport();
            }
        });
        panel.addFinishListener((JExportProcessPanel.ExportFinishListener)new ExportFinishListenerAdapter(){

            public void finished(JExportProcessPanel exportPanel) {
                ExportLayerExtension.this.doAddlayer(process, mapContext);
            }
        });
        JComponent component = panel.asJComponent();
        Dimension screensize = ToolsSwingLocator.getToolsSwingManager().getDesktopPanelSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)component, (int)Math.max(3 * (screensize.height / 4), ToolsSwingUtils.rows2px((int)80)), (int)Math.max(2 * (screensize.width / 4), ToolsSwingUtils.cols2px((int)35)), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        winmgr.showWindow(panel.asJComponent(), i18n.getTranslation("_Export_to"), mode, Collections.singletonMap("align", 10));
    }

    private void doAddlayer(final ExportProcess process, final MapContext mapContext) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExportLayerExtension.this.doAddlayer(process, mapContext);
                }
            });
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (process.getTargetOpenStoreParameters() == null) {
            return;
        }
        int n = application.confirmDialog(i18n.getTranslation("_Add_new_layer_to_current_view"), i18n.getTranslation("_Export"), 0, 3, "AddExportedLayerToView");
        if (n != 0) {
            return;
        }
        try {
            DataManager dataManager = DALLocator.getDataManager();
            MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
            for (OpenDataStoreParameters params : process.getTargetOpenStoreParameters()) {
                DataStore store = dataManager.openStore(params.getDataStoreName(), (DataStoreParameters)params);
                FLayer layer = mapContextManager.createLayer(store.getName(), store);
                mapContext.getLayers().addLayer(layer);
            }
            application.messageDialog(i18n.getTranslation("_Layer_added_to_view"), null, i18n.getTranslation("_Export"), 3, "ExportedLayerAddedToView");
        }
        catch (Exception ex) {
            logger.warn("Can't add exported layer to view", (Throwable)ex);
            application.messageDialog(i18n.getTranslation("_Cant_add_exported_layer_to_view"), null, i18n.getTranslation("_Export"), 2, "CantAddExportedLayerToView");
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (view != null) {
            return view.getMapContext().hasActiveVectorLayers();
        }
        return false;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument view = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        return view != null;
    }

    private void registerInCatalog() {
        final ApplicationManager application = ApplicationLocator.getApplicationManager();
        application.addPropertiesObserver(new Observer(){

            public void update(Observable observable, Object notification) {
                if (!(notification instanceof Notification)) {
                    return;
                }
                String propertyName = (String)((Notification)notification).getValue(0);
                if (!StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"Catalog.Manager")) {
                    return;
                }
                DynObject catalogManager = (DynObject)application.getProperty("Catalog.Manager");
                if (catalogManager == null) {
                    return;
                }
                try {
                    String[] catalogNodes;
                    for (String catalogNode : catalogNodes = new String[]{"STORES_REPOSITORY_TABLE", "DATABASE_TABLE", "FOLDERS_FILE", "BOOKMARKS_BOOKMARK"}) {
                        Object action = catalogManager.invokeDynMethod("getAction", new Object[]{"Export", catalogNode});
                        if (action != null) continue;
                        catalogManager.invokeDynMethod("addAction", new Object[]{"Export", catalogNode, new ExportStoreFromCatalogAction()});
                    }
                }
                catch (Exception ex) {
                    logger.warn("Can't add action to catalog", (Throwable)ex);
                }
            }
        });
    }
}

