/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.app.extension;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.gvsig.export.app.extension.ExportTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportStoreFromCatalogAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportStoreFromCatalogAction.class);
    public static final String NAME = "Export";

    public ExportStoreFromCatalogAction() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", NAME);
        this.putValue("Name", i18n.getTranslation("_Export"));
        this.putValue("SmallIcon", ToolsSwingLocator.getIconThemeManager().getCurrent().get("table-export"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            OpenDataStoreParameters storeParams = (OpenDataStoreParameters)e.getSource();
            DataManager dataManager = DALLocator.getDataManager();
            DataStore store = dataManager.openStore(storeParams.getProviderName(), (DataStoreParameters)storeParams);
            ExportTable exportTable = new ExportTable();
            exportTable.showExport((FeatureStore)store, null);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't export store.", (Throwable)ex);
        }
    }
}

