/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.about.AboutLocator;
import org.gvsig.about.AboutManager;
import org.gvsig.scripting.ScriptingDialog;
import org.gvsig.scripting.ScriptingFolder;
import org.gvsig.scripting.ScriptingLocator;
import org.gvsig.scripting.ScriptingManager;
import org.gvsig.scripting.ScriptingScript;
import org.gvsig.scripting.ScriptingUnit;
import org.gvsig.scripting.swing.api.CreateComponentListener;
import org.gvsig.scripting.swing.api.EditorFactory;
import org.gvsig.scripting.swing.api.JCodeEditor;
import org.gvsig.scripting.swing.api.JDialogEditor;
import org.gvsig.scripting.swing.api.JEditor;
import org.gvsig.scripting.swing.api.JScriptingBrowser;
import org.gvsig.scripting.swing.api.JScriptingComposer;
import org.gvsig.scripting.swing.api.JScriptingConsole;
import org.gvsig.scripting.swing.api.JScriptingLauncher;
import org.gvsig.scripting.swing.api.JThinG;
import org.gvsig.scripting.swing.api.JThinlet;
import org.gvsig.scripting.swing.api.ScriptingUIManager;
import org.gvsig.scripting.swing.api.SyntaxtHighlightTextComponent;
import org.gvsig.scripting.swing.impl.DefaultJScriptingBrowser;
import org.gvsig.scripting.swing.impl.DefaultJScriptingConsole;
import org.gvsig.scripting.swing.impl.DefaultJScriptingLauncher;
import org.gvsig.scripting.swing.impl.DefaultJThinG;
import org.gvsig.scripting.swing.impl.DefaultJThinlet;
import org.gvsig.scripting.swing.impl.composer.DefaultJScriptingComposer;
import org.gvsig.scripting.swing.impl.composer.editors.DialogEditor;
import org.gvsig.scripting.swing.impl.composer.editors.DialogEditorFactory;
import org.gvsig.scripting.swing.impl.composer.editors.ExternalFileEditorFactory;
import org.gvsig.scripting.swing.impl.composer.editors.FolderEditorFactory;
import org.gvsig.scripting.swing.impl.composer.editors.PropertiesEditorFactory;
import org.gvsig.scripting.swing.impl.composer.editors.ScriptUnitEditor;
import org.gvsig.scripting.swing.impl.composer.editors.ScriptUnitEditorFactory;
import org.gvsig.scripting.swing.impl.composer.editors.SimpleScriptEditor;
import org.gvsig.scripting.swing.impl.composer.editors.TextEditorFactory;
import org.gvsig.scripting.swing.impl.syntaxhighlight.JEditorPaneSyntaxHighlighting;
import org.gvsig.scripting.swing.impl.syntaxhighlight.JRSyntaxTextArea;
import org.gvsig.scripting.swing.impl.tools.DefaultScriptChooserPanel;
import org.gvsig.scripting.swing.impl.tools.ScriptListPickerController;
import org.gvsig.scripting.swing.impl.tools.ScriptPickerController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.pickercontroller.PickerController;
import org.gvsig.tools.swing.api.script.ScriptSwingManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptingUIManager
implements ScriptingUIManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultScriptingUIManager.class);
    private final ScriptingManager manager;
    private final Map<String, URL> userHelps = new HashMap<String, URL>();
    private I18nManager i18nManager;
    private WindowManager windowsManager = null;
    private final Map<String, Action> composerTools = new LinkedHashMap<String, Action>();
    private final Map<String, ScriptingUIManager.MenuEntry> composerMenus = new LinkedHashMap<String, ScriptingUIManager.MenuEntry>();
    private JScriptingComposer activeComposer;
    private Set<CreateComponentListener> createComponentListeners;
    private final Map<String, EditorFactory> editorFactories = new HashMap<String, EditorFactory>();
    private List<EditorFactory> editorFactoriesOrderer = null;

    public DefaultScriptingUIManager() {
        this.manager = ScriptingLocator.getManager();
        this.manager.put("ScriptingUIManager", (Object)this);
        this.i18nManager = ToolsLocator.getI18nManager();
        this.init();
    }

    private void init() {
        this.registerEditor((EditorFactory)new DialogEditorFactory());
        this.registerEditor((EditorFactory)new ScriptUnitEditorFactory());
        this.registerEditor((EditorFactory)new PropertiesEditorFactory());
        this.registerEditor((EditorFactory)new TextEditorFactory());
        this.registerEditor((EditorFactory)new ExternalFileEditorFactory());
        this.registerEditor((EditorFactory)new FolderEditorFactory());
    }

    public void addCreatedComponentListener(CreateComponentListener listener) {
        if (this.createComponentListeners == null) {
            this.createComponentListeners = new HashSet<CreateComponentListener>();
        }
        this.createComponentListeners.add(listener);
    }

    public void removeCreatedComponentListener(CreateComponentListener listener) {
        if (this.createComponentListeners == null) {
            return;
        }
        this.createComponentListeners.remove(listener);
    }

    public void fireCreateComponent(Component component) {
        if (this.createComponentListeners == null) {
            return;
        }
        for (CreateComponentListener listener : this.createComponentListeners) {
            try {
                listener.componentCreated(component);
            }
            catch (Throwable th) {
                String s = "unknow";
                try {
                    s = component.getClass().getName();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LOGGER.warn("Problems call listener", th);
            }
        }
    }

    public JScriptingComposer createComposer() {
        DefaultJScriptingComposer composer = new DefaultJScriptingComposer(this);
        this.fireCreateComponent((Component)composer);
        return composer;
    }

    public JPanel createInstaller() {
        return null;
    }

    public JScriptingLauncher createLauncher() {
        DefaultJScriptingLauncher launcher = new DefaultJScriptingLauncher(this);
        this.fireCreateComponent((Component)launcher);
        return launcher;
    }

    public ImageIcon getIcon(String name) {
        return this.getIcon(name, null);
    }

    public ImageIcon getIcon(String name, String size) {
        ClassLoader loader;
        URL url;
        if (name == null) {
            return new ImageIcon();
        }
        String tamanyo = "16x16/";
        if (size != null && size.equals("big")) {
            tamanyo = "32x32/";
        }
        if ((url = (loader = this.getClass().getClassLoader()).getResource("org/gvsig/scripting/images/" + tamanyo + name + ".png")) == null) {
            url = loader.getResource("org/gvsig/scripting/images/" + tamanyo + "scripting-image-missing.png");
        }
        if (url == null) {
            return new ImageIcon();
        }
        return new ImageIcon(url);
    }

    public ScriptingManager getManager() {
        return this.manager;
    }

    public String[] getPrerreferedLanguages() {
        String curr = Locale.getDefault().getLanguage().toLowerCase();
        if (curr.equals("gl")) {
            return new String[]{"gl", "es", "en"};
        }
        if (curr.equals("ca")) {
            return new String[]{"ca", "es", "en"};
        }
        if (curr.equals("eu")) {
            return new String[]{"eu", "es", "en"};
        }
        if (curr.equals("va")) {
            return new String[]{"va", "ca", "es", "en"};
        }
        return new String[]{curr, "en", "es"};
    }

    public AboutManager getAboutManager() {
        return AboutLocator.getManager();
    }

    private void showWindow(JComponent panel, String title, WindowManager.MODE mode) {
        WindowManager winmanager = this.getWindowManager();
        if (winmanager instanceof WindowManager_v2) {
            ((WindowManager_v2)winmanager).showWindow(panel, title, mode, this.getIcon("scripting-icon-python").getImage());
        } else {
            winmanager.showWindow(panel, title, mode);
        }
    }

    public void showDialog(JComponent panel, String title) {
        this.showWindow(panel, title, WindowManager.MODE.DIALOG);
    }

    public void showWindow(JComponent panel, String title) {
        this.showWindow(panel, title, WindowManager.MODE.WINDOW);
    }

    public void showTool(JComponent panel, String title) {
        this.showWindow(panel, title, WindowManager.MODE.TOOL);
    }

    public JScriptingBrowser createBrowser(ScriptingFolder root, boolean foldersOnly) {
        DefaultJScriptingBrowser browser = new DefaultJScriptingBrowser(this, root, foldersOnly);
        this.fireCreateComponent((Component)browser);
        return browser;
    }

    public JScriptingBrowser createBrowser(ScriptingFolder root) {
        return this.createBrowser(root, false);
    }

    public JCodeEditor createJCodeEditor(ScriptingScript script) {
        ScriptUnitEditor editor = new ScriptUnitEditor(this, (Script)script);
        this.fireCreateComponent((Component)editor);
        return editor;
    }

    public JDialogEditor createJDialogEditor(ScriptingDialog script) {
        return new DialogEditor((ScriptingUIManager)this, script);
    }

    public JThinG createJThinG() {
        DefaultJThinG thing = new DefaultJThinG();
        return thing;
    }

    public JThinlet createJThinlet() {
        DefaultJThinlet thinlet = new DefaultJThinlet();
        return thinlet;
    }

    public SyntaxtHighlightTextComponent createSyntaxHighlightingPanel() {
        try {
            return new JRSyntaxTextArea();
        }
        catch (Throwable t) {
            LOGGER.info("Can't create advanced SyntaxHighlightingPanel.", t);
            return new JEditorPaneSyntaxHighlighting();
        }
    }

    public String getTranslation(String key) {
        if (this.i18nManager == null) {
            this.i18nManager = ToolsLocator.getI18nManager();
        }
        return this.i18nManager.getTranslation(key);
    }

    public WindowManager getWindowManager() {
        if (this.windowsManager == null) {
            this.windowsManager = ToolsSwingLocator.getWindowManager();
        }
        return this.windowsManager;
    }

    public void setWindowManager(WindowManager windowsManager) {
        this.windowsManager = windowsManager;
    }

    public JScriptingConsole createJScriptingConsole() {
        return this.createJScriptingConsole(true);
    }

    public JScriptingConsole createJScriptingConsole(boolean captureOutput) {
        DefaultJScriptingConsole console = new DefaultJScriptingConsole(captureOutput);
        this.fireCreateComponent((Component)console);
        return console;
    }

    public void addComposerMenu(String text, Action action) {
        String name = (String)action.getValue("ActionCommandKey");
        this.composerMenus.put(name, new DefaultMenuEntry(text, action));
    }

    public void addComposerTool(Action action) {
        String name = (String)action.getValue("ActionCommandKey");
        this.composerTools.put(name, action);
    }

    public Collection<ScriptingUIManager.MenuEntry> getComposerMenus() {
        return this.composerMenus.values();
    }

    public Collection<Action> getComposerTools() {
        return this.composerTools.values();
    }

    public JEditor createEditor(ScriptingUnit unit) {
        JEditor editor = null;
        for (EditorFactory factory : this.getEditorFactories()) {
            try {
                if (!factory.canCreate(unit)) continue;
                editor = factory.create(unit);
                this.fireCreateComponent((Component)editor);
                break;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't create an editor with factory '" + factory.getClass().getName() + "' for '" + unit.getClass().getName() + "'.", (Throwable)ex);
            }
        }
        return editor;
    }

    public boolean hasEditor(ScriptingUnit unit) {
        if (unit == null) {
            return false;
        }
        for (EditorFactory factory : this.getEditorFactories()) {
            try {
                if (!factory.canCreate(unit)) continue;
                return true;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't check if factory '" + factory.getClass().getName() + "' can create an editor for '" + unit.getClass().getName() + "'.", (Throwable)ex);
            }
        }
        return false;
    }

    public void setActiveComposer(JScriptingComposer composer) {
        this.activeComposer = composer;
    }

    public JScriptingComposer getActiveComposer() {
        return this.activeComposer;
    }

    public void registerEditor(EditorFactory factory) {
        this.editorFactories.put(factory.getName(), factory);
        this.editorFactoriesOrderer = null;
    }

    public List<EditorFactory> getEditorFactories() {
        if (this.editorFactoriesOrderer == null) {
            this.editorFactoriesOrderer = new ArrayList<EditorFactory>(this.editorFactories.values());
            Collections.sort(this.editorFactoriesOrderer, new Comparator<EditorFactory>(){

                @Override
                public int compare(EditorFactory o1, EditorFactory o2) {
                    return o2.getPriority() - o1.getPriority();
                }
            });
        }
        return this.editorFactoriesOrderer;
    }

    public ScriptSwingManager.ScriptChooserPanel createScriptChooserPanel() {
        return new DefaultScriptChooserPanel(this);
    }

    public PickerController<Script> createScriptPickerController(JTextField text, JButton chooser) {
        ScriptPickerController x = new ScriptPickerController(text, chooser);
        return x;
    }

    public PickerController<List<Script>> createListScriptPickerController(JComboBox combo, JButton remove, JButton chooser) {
        ScriptListPickerController x = new ScriptListPickerController(combo, remove, chooser);
        return x;
    }

    public PickerController<List<Script>> createListScriptPickerController(JList list, JButton remove, JButton chooser) {
        ScriptListPickerController x = new ScriptListPickerController(list, remove, chooser);
        return x;
    }

    public SimpleScriptEditor createScriptEditor() {
        SimpleScriptEditor x = new SimpleScriptEditor();
        return x;
    }

    private static class DefaultMenuEntry
    implements ScriptingUIManager.MenuEntry {
        private final Action action;
        private final String text;

        public DefaultMenuEntry(String text, Action action) {
            this.text = text;
            this.action = action;
        }

        public String getText() {
            return this.text;
        }

        public Action getAction() {
            return this.action;
        }
    }
}

