/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.scripting.swing.impl.composer;

import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.Component;

public class MenuBarHelper
implements Component {
    private final JMenuBar menu;

    public MenuBarHelper(JMenuBar menu) {
        this.menu = menu;
    }

    public MenuBarHelper() {
        this(new JMenuBar());
    }

    public JMenuBar getMenuBar() {
        return this.menu;
    }

    public JComponent asJComponent() {
        return this.menu;
    }

    public JMenuItem add(String text) {
        return this.add(text, null, null);
    }

    public JMenuItem add(String parent, Action action, Object context) {
        JMenu entry;
        String[] sparent = parent.split("/");
        for (int i = 0; i < this.menu.getMenuCount(); ++i) {
            entry = this.menu.getMenu(i);
            if (!entry.getText().equalsIgnoreCase(sparent[0])) continue;
            return this.add(entry, sparent, 1, action, context);
        }
        entry = new JMenu(sparent[0]);
        this.menu.add(entry);
        return this.add(entry, sparent, 1, action, context);
    }

    private JMenuItem add(JMenu entry, String parent, Action action, Object context) {
        String[] sparent = parent.split("/");
        return this.add(entry, sparent, 1, action, context);
    }

    private JMenuItem add(JMenu menu, String[] parent, int level, Action action, Object context) {
        JMenuItem entry = null;
        if (parent.length == level) {
            for (int i = 0; i < menu.getItemCount(); ++i) {
                String action_name;
                String entry_name;
                entry = menu.getItem(i);
                if (!(entry instanceof JMenuItemWithContext) || !StringUtils.equalsIgnoreCase((CharSequence)(entry_name = (String)entry.getAction().getValue("Name")), (CharSequence)(action_name = (String)action.getValue("Name")))) continue;
                menu.remove(entry);
            }
            if (action != null) {
                entry = new JMenuItemWithContext(action, context);
                menu.add(entry);
            }
            return entry;
        }
        for (int i = 0; i < menu.getItemCount(); ++i) {
            entry = menu.getItem(i);
            if (!(entry instanceof JMenu) || !entry.getText().equalsIgnoreCase(parent[level])) continue;
            entry = this.add((JMenu)entry, parent, level + 1, action, context);
            return entry;
        }
        if ("-".equals(parent[level])) {
            menu.addSeparator();
        } else {
            entry = new JMenu(parent[level]);
            menu.add(entry);
            entry = this.add((JMenu)entry, parent, level + 1, action, context);
        }
        return entry;
    }

    public static class JMenuItemWithContext
    extends JMenuItem {
        private static final long serialVersionUID = -1147590044079747644L;
        private final Object context;

        private JMenuItemWithContext(Action action, Object context) {
            super(action);
            this.context = context;
        }

        public Object getContext() {
            return this.context;
        }
    }
}

