/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;

public abstract class AbstractLabelingMethodPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 3042343486793818865L;
    public static final String PLACEMENT_CONSTRAINTS = "PLACEMENT_CONSTRAINTS";
    public static final String ALLOW_OVERLAP = "ALLOW_OVERLAP";
    public static final String ZOOM_CONSTRAINTS = "ZOOM_CONSTRAINTS";
    protected FLyrVect layer;
    protected ILabelingMethod method;

    @Override
    public abstract String getName();

    public abstract Class<? extends ILabelingMethod> getLabelingMethodClass();

    public void setModel(ILabelingMethod method, FLyrVect srcLayer) throws ReadException {
        if (srcLayer == null) {
            throw new ReadException("FLyrVect is null", (Throwable)new Exception("FLyrVect is null"));
        }
        this.layer = srcLayer;
        try {
            Class<? extends ILabelingMethod> labelingMethodClass = this.getLabelingMethodClass();
            this.method = method != null && method.getClass().equals(labelingMethodClass) ? method : labelingMethodClass.newInstance();
        }
        catch (Exception e) {
            throw new ReadException(srcLayer.getFeatureStore().getName(), (Throwable)new Exception("Unable to load labeling method. Is it in your classpath?", e));
        }
        this.initializePanel();
        try {
            this.fillPanel(srcLayer.getFeatureStore().getDefaultFeatureType());
        }
        catch (DataException de) {
            throw new ReadException(srcLayer.getFeatureStore().getName(), (Throwable)de);
        }
    }

    protected abstract void initializePanel();

    public abstract void fillPanel(FeatureType var1) throws ReadException;

    @Override
    public String toString() {
        return this.getName();
    }

    public ILabelingMethod getMethod() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.getClass().equals(obj.getClass());
    }
}

