/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.controls.comboscale.ComboScale;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.i18n.Messages;

public class LabelScaleRange
extends JPanel
implements IWindow,
ActionListener {
    private static final long serialVersionUID = -450284029750650479L;
    private static final long[] defaultScales = new long[]{1000L, 2000L, 5000L, 10000L, 50000L, 100000L, 200000L, 500000L};
    private long maxScale;
    private long minScale;
    private ComboScale cmbMaxScale;
    private ComboScale cmbMinScale;
    private JRadioButton rdBtnUseSameRangeThanLayer;
    private JRadioButton rdBtnDontShowLabelWhenZoomed;

    public LabelScaleRange(long minScale, long maxScale) {
        this.setLayout(new BorderLayout());
        this.maxScale = maxScale;
        this.minScale = minScale;
        this.getCmbMinScale().setScale((double)minScale);
        this.getCmbMaxScale().setScale((double)maxScale);
        GridBagLayoutPanel p = new GridBagLayoutPanel();
        p.addComponent((Component)new JLabel(Messages.getText((String)"specify_the_range_of_scales_at_which_labels_will_be_shown") + ":"));
        p.addComponent((Component)new JBlank(10, 10));
        p.addComponent((Component)this.getRdUseSameRangeThanLayer());
        p.addComponent((Component)new JBlank(10, 10));
        p.addComponent((Component)this.getRdDontShowLabelsWhenZoomed());
        p.addComponent((Component)new JBlank(10, 10));
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRdUseSameRangeThanLayer());
        group.add(this.getRdDontShowLabelsWhenZoomed());
        this.getRdUseSameRangeThanLayer().addActionListener(this);
        this.getRdDontShowLabelsWhenZoomed().addActionListener(this);
        this.getRdUseSameRangeThanLayer().setSelected(maxScale == -1L && minScale == -1L);
        this.getRdDontShowLabelsWhenZoomed().setSelected(!this.getRdUseSameRangeThanLayer().isSelected());
        this.getCmbMinScale().setEnabled(this.getRdDontShowLabelsWhenZoomed().isSelected());
        this.getCmbMaxScale().setEnabled(this.getRdDontShowLabelsWhenZoomed().isSelected());
        JLabel l = new JLabel("    " + Messages.getText((String)"out_beyond") + ":", 4);
        JPanel aux = new JPanel();
        aux.add((Component)this.getCmbMaxScale());
        aux.add(new JLabel("(" + Messages.getText((String)"max_scale") + ")"));
        p.addComponent((Component)l, (Component)aux);
        l = new JLabel("    " + Messages.getText((String)"in_beyond") + ":", 4);
        aux = new JPanel();
        aux.add((Component)this.getCmbMinScale());
        aux.add(new JLabel("(" + Messages.getText((String)"min_scale") + ")"));
        p.addComponent((Component)l, (Component)aux);
        this.add((Component)new JBlank(10, 10), "West");
        this.add((Component)new JBlank(10, 10), "East");
        this.add((Component)p, "Center");
        this.add((Component)new AcceptCancelPanel((ActionListener)this, (ActionListener)this), "South");
    }

    private JRadioButton getRdDontShowLabelsWhenZoomed() {
        if (this.rdBtnDontShowLabelWhenZoomed == null) {
            this.rdBtnDontShowLabelWhenZoomed = new JRadioButton(Messages.getText((String)"dont_show_labels_when_zoomed"));
        }
        return this.rdBtnDontShowLabelWhenZoomed;
    }

    private JRadioButton getRdUseSameRangeThanLayer() {
        if (this.rdBtnUseSameRangeThanLayer == null) {
            this.rdBtnUseSameRangeThanLayer = new JRadioButton(Messages.getText((String)"use_the_same_scale_range_as_the_feature_layer"));
        }
        return this.rdBtnUseSameRangeThanLayer;
    }

    public long getMaxScale() {
        return this.maxScale;
    }

    private ComboScale getCmbMaxScale() {
        if (this.cmbMaxScale == null) {
            this.cmbMaxScale = new ComboScale();
            TreeSet<Long> ts = new TreeSet<Long>();
            if (this.maxScale != -1L) {
                ts.add(this.maxScale);
            }
            for (int i = 0; i < defaultScales.length; ++i) {
                ts.add(defaultScales[i]);
            }
            long[] items = new long[ts.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (Long)ts.first();
                ts.remove(ts.first());
            }
            this.cmbMaxScale.setItems(items);
        }
        return this.cmbMaxScale;
    }

    private ComboScale getCmbMinScale() {
        if (this.cmbMinScale == null) {
            this.cmbMinScale = new ComboScale();
            TreeSet<Long> ts = new TreeSet<Long>();
            if (this.minScale != -1L) {
                ts.add(this.minScale);
            }
            for (int i = 0; i < defaultScales.length; ++i) {
                ts.add(defaultScales[i]);
            }
            long[] items = new long[ts.size()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (Long)ts.first();
                ts.remove(ts.first());
            }
            this.cmbMinScale.setItems(items);
        }
        return this.cmbMinScale;
    }

    public long getMinScale() {
        return this.minScale;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo wi = new WindowInfo(9);
        wi.setTitle(Messages.getText((String)"scale_range_window_title"));
        wi.setWidth(480);
        wi.setHeight(200);
        return wi;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Component c = (Component)e.getSource();
        if (this.getRdDontShowLabelsWhenZoomed().equals(c) || this.getRdUseSameRangeThanLayer().equals(c)) {
            this.getCmbMinScale().setEnabled(this.getRdDontShowLabelsWhenZoomed().isSelected());
            this.getCmbMaxScale().setEnabled(this.getRdDontShowLabelsWhenZoomed().isSelected());
        }
        if ("OK".equals(e.getActionCommand())) {
            this.maxScale = this.getRdUseSameRangeThanLayer().isSelected() ? -1L : (long)this.getCmbMaxScale().getScale();
            this.minScale = this.getRdUseSameRangeThanLayer().isSelected() ? -1L : (long)this.getCmbMinScale().getScale();
            ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
        }
        if ("CANCEL".equals(e.getActionCommand())) {
            ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
        }
    }
}

