/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.layerproperties;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import javax.swing.JComponent;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.ISingleSymbolLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingStrategy;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.i18n.Messages;
import org.gvsig.labeling.label.GeneralLabelingStrategy;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.ISimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ISimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IArrowDecoratorStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ILineStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ISimpleLineStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MiniMapContext
extends JComponent {
    private static final Logger minilogger = LoggerFactory.getLogger(MiniMapContext.class);
    private static final long serialVersionUID = 229128782038834443L;
    private MapContext theMapContext;
    private FLyrVect line_layer;
    private FLyrVect bgpoly_layer;
    private int hMargin = 5;
    private int vMargin = 5;
    private FLyrVect poly_layer;
    private int geotype;
    private IPlacementConstraints placement;

    public MiniMapContext(int type) {
        this.setType(type);
    }

    public void setType(int type) {
        GeometryType gtype = null;
        try {
            gtype = GeometryLocator.getGeometryManager().getGeometryType(type, 0);
        }
        catch (Exception e) {
            minilogger.error("While getting geo type", (Throwable)e);
        }
        this.geotype = gtype.isTypeOf(2) || gtype.getType() == 8 ? 2 : (gtype.isTypeOf(3) || gtype.getType() == 9 ? 3 : 0);
    }

    public void setConstraints(IPlacementConstraints constraints) {
        this.placement = constraints;
        try {
            this.getMapContext(null);
        }
        catch (Exception e) {
            minilogger.error("While getting mini map context", (Throwable)e);
        }
        this.repaint();
    }

    private MapContext getMapContext(Dimension img_size) throws Exception {
        Envelope ini_env = null;
        ini_env = GeometryLocator.getGeometryManager().createEnvelope(289600.0, 3973500.0, 291600.0, 3975700.0, 0);
        if (this.theMapContext == null) {
            SymbologyManager symman = SymbologyLocator.getSymbologyManager();
            MapContextManager mcoman = MapContextLocator.getMapContextManager();
            this.line_layer = this.createLayerFromShpDocFile("line.shp", "EPSG:23030");
            ISimpleLineSymbol line_sym = symman.createSimpleLineSymbol();
            line_sym.setColor(Color.red);
            ISimpleLineStyle line_sty = symman.createSimpleLineStyle();
            IArrowDecoratorStyle arrow_style = symman.createArrowDecoratorStyle();
            arrow_style.getMarker().setSize(15.0);
            arrow_style.setArrowMarkerCount(1);
            arrow_style.getMarker().setColor(Color.red);
            line_sty.setArrowDecorator(arrow_style);
            line_sym.setLineStyle((ILineStyle)line_sty);
            line_sym.setLineWidth(2.0);
            ISingleSymbolLegend line_leg = (ISingleSymbolLegend)mcoman.createLegend("SingleSymbol");
            line_leg.setDefaultSymbol((ISymbol)line_sym);
            this.line_layer.setLegend((IVectorLegend)line_leg);
            this.bgpoly_layer = this.createLayerFromShpDocFile("bg-polygon.shp", "EPSG:23030");
            this.poly_layer = this.createLayerFromShpDocFile("polygon.shp", "EPSG:23030");
            ISimpleFillSymbol sym2 = symman.createSimpleFillSymbol();
            sym2.setFillColor(new Color(50, 245, 125));
            ISimpleLineSymbol outline = symman.createSimpleLineSymbol();
            outline.setLineColor(Color.DARK_GRAY);
            outline.setLineWidth(0.5);
            sym2.setOutline((ILineSymbol)outline);
            ISingleSymbolLegend poly_leg = (ISingleSymbolLegend)mcoman.createLegend("SingleSymbol");
            poly_leg.setDefaultSymbol((ISymbol)sym2);
            this.poly_layer.setLegend((IVectorLegend)poly_leg);
            this.bgpoly_layer.setLegend((IVectorLegend)poly_leg);
            GeneralLabelingStrategy labeling1 = new GeneralLabelingStrategy();
            GeneralLabelingStrategy labeling2 = new GeneralLabelingStrategy();
            ILabelingMethod def_method = symman.createDefaultLabelingMethod();
            ILabelClass lc = null;
            if (def_method.getLabelClasses() != null && def_method.getLabelClasses().length > 0) {
                lc = def_method.getLabelClasses()[0];
            } else {
                lc = symman.createDefaultLabel();
                def_method.addLabelClass(lc);
            }
            String[] sampleExpression = new String[]{Messages.getText((String)"text")};
            lc.setLabelExpressions(sampleExpression);
            lc.getTextSymbol().setFontSize(16.0);
            labeling1.setLabelingMethod(def_method);
            labeling2.setLabelingMethod(def_method);
            labeling1.setLayer((FLayer)this.line_layer);
            labeling2.setLayer((FLayer)this.poly_layer);
            this.line_layer.setLabelingStrategy((ILabelingStrategy)labeling1);
            this.line_layer.setIsLabeled(true);
            this.poly_layer.setLabelingStrategy((ILabelingStrategy)labeling2);
            this.poly_layer.setIsLabeled(true);
            ViewPort theViewPort = new ViewPort(CRSFactory.getCRS((String)"EPSG:23030"));
            this.theMapContext = new MapContext(theViewPort);
            if (img_size != null) {
                theViewPort.setImageSize(img_size);
            } else {
                theViewPort.setImageSize(new Dimension(200, 200));
            }
            theViewPort.setEnvelope(ini_env);
            this.theMapContext.getLayers().addLayer((FLayer)this.bgpoly_layer);
            this.theMapContext.getLayers().addLayer((FLayer)this.poly_layer);
            this.theMapContext.getLayers().addLayer((FLayer)this.line_layer);
        } else {
            if (img_size != null) {
                this.theMapContext.getViewPort().setImageSize(img_size);
            } else {
                this.theMapContext.getViewPort().setImageSize(new Dimension(200, 200));
            }
            this.theMapContext.getViewPort().setEnvelope(ini_env);
        }
        this.line_layer.getLabelingStrategy().setPlacementConstraints(this.placement);
        this.poly_layer.getLabelingStrategy().setPlacementConstraints(this.placement);
        Dimension sz = this.getBounds().getSize();
        sz.setSize(sz.width - 2 * this.hMargin, sz.height - 2 * this.vMargin);
        this.theMapContext.getViewPort().setImageSize(sz);
        this.theMapContext.getViewPort().setBackColor(new Color(255, 0, 0));
        this.theMapContext.invalidate();
        return this.theMapContext;
    }

    @Override
    protected void paintComponent(Graphics g) {
        try {
            Rectangle bounds = this.getBounds();
            Dimension sz = bounds.getSize();
            sz.setSize(sz.width - 2 * this.vMargin, sz.height - 2 * this.hMargin);
            Dimension imageSize = sz;
            MapContext mco = this.getMapContext(imageSize);
            if (this.geotype == 2) {
                this.line_layer.setVisible(true);
                this.poly_layer.setVisible(false);
            } else if (this.geotype == 3) {
                this.line_layer.setVisible(false);
                this.poly_layer.setVisible(true);
            }
            this.bgpoly_layer.setVisible(this.line_layer.isVisible());
            BufferedImage bi = new BufferedImage(imageSize.width, imageSize.height, 6);
            mco.invalidate();
            mco.draw(bi, bi.createGraphics(), mco.getScaleView());
            g.setColor(new Color(150, 180, 255));
            g.fillRect(this.vMargin, this.hMargin, bounds.width - 2 * this.hMargin, bounds.height - 2 * this.vMargin);
            g.drawImage(bi, this.vMargin, this.vMargin, null);
            bi = null;
        }
        catch (Exception e) {
            minilogger.error("While painting.", (Throwable)e);
            String noneSelected = "[" + Messages.getText((String)"preview_not_available") + "]";
            int vGap = 5;
            int hGap = 5;
            Rectangle r = this.getBounds();
            FontMetrics fm = g.getFontMetrics();
            int lineWidth = fm.stringWidth(noneSelected);
            float scale = (float)r.getWidth() / (float)lineWidth;
            Font f = g.getFont();
            float fontSize = (float)f.getSize() * scale;
            g.setFont(f.deriveFont(fontSize));
            ((Graphics2D)g).drawString(noneSelected, (float)r.x * scale - (float)(hGap / 2), (float)(r.height / 2) + (float)vGap * scale);
        }
    }

    private FLyrVect createLayerFromShpDocFile(String shp_file_name, String epsg_code) throws Exception {
        File shpfile = this.getDocFolderFile(shp_file_name);
        IProjection proj = CRSFactory.getCRS((String)epsg_code);
        DataStoreParameters ssp = DALLocator.getDataManager().createStoreParameters("Shape");
        ssp.setDynValue("shpfile", (Object)shpfile);
        ssp.setDynValue("CRS", (Object)proj);
        FLyrVect resp = null;
        resp = (FLyrVect)MapContextLocator.getMapContextManager().createLayer(shp_file_name, ssp);
        return resp;
    }

    private File getDocFolderFile(String name) {
        URL resource = this.getClass().getClassLoader().getResource("docs" + File.separator + name);
        File resp = new File(resource.getFile());
        return resp;
    }
}

