/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.styling;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.filechooser.FileFilter;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;

public class JUrlFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1844355534608274984L;
    FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String fName = f.getAbsolutePath();
            if (fName != null) {
                return (fName = fName.toLowerCase()).endsWith(".png") || fName.endsWith(".gif") || fName.endsWith(".jpg") || fName.endsWith(".jpeg") || fName.endsWith(".bmp") || fName.endsWith(".svg");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Messages.getText((String)"bitmap_and_svg_image_files") + "," + Messages.getText((String)"URL");
        }
    };

    public JUrlFileChooser(String fileChooserID, String defaultDirectory) {
        super(fileChooserID, defaultDirectory);
        this.setFileFilter(this.ff);
        this.setFileSelectionMode(0);
        this.setMultiSelectionEnabled(false);
    }

    public URL getSelectedURL() {
        File f = this.getSelectedFile();
        try {
            if (f.canRead()) {
                return f.toURI().toURL();
            }
            String path = f.toString();
            if (!path.startsWith("http") && path.contains("http") && (path.endsWith(".png") || path.endsWith(".gif") || path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".bmp") || path.endsWith(".svg"))) {
                path = path.substring(path.indexOf("http"), path.length());
                path = path.replace('\\', '/');
                path = path.replaceFirst("/", "//");
                return new URL(path);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        return null;
    }
}

