/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.labeling.gui.styling.editortools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.StyleEditor;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IBackgroundFileStyle;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelStyleOpenBackgroundFile
extends EditorTool {
    private static Logger logger = LoggerFactory.getLogger(LabelStyleOpenBackgroundFile.class);
    public static final String LABEL_STYLE_BACKGROUND_FILECHOOSER = "LABEL_STYLE_BACKGROUND_FILECHOOSER";
    public static String DEFAULT_LABEL_BACKGROUND_FOLDER;
    private JButton btnOpenFile;
    private ILabelStyle style;

    public LabelStyleOpenBackgroundFile(JComponent targetEditor) {
        super(targetEditor);
    }

    public AbstractButton getButton() {
        return this.getBtnOpenFile();
    }

    private JButton getBtnOpenFile() {
        if (this.btnOpenFile == null) {
            this.btnOpenFile = new JButton(IconThemeHelper.getImageIcon((String)"edit-add-background-image"));
            this.btnOpenFile.setToolTipText(Messages.getText((String)"_Set_new_background_image"));
            this.btnOpenFile.setSize(EditorTool.SMALL_BTN_SIZE);
            this.btnOpenFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser jfChooser = new JFileChooser(LabelStyleOpenBackgroundFile.LABEL_STYLE_BACKGROUND_FILECHOOSER, DEFAULT_LABEL_BACKGROUND_FOLDER);
                    FileFilter ff = new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            if (pathname.isDirectory()) {
                                return true;
                            }
                            String fileName = pathname.getAbsolutePath().toLowerCase();
                            return fileName.endsWith("jpg") || fileName.endsWith("png") || fileName.endsWith("gif") || fileName.endsWith("svg");
                        }

                        @Override
                        public String getDescription() {
                            return Messages.getText((String)"all_supported_background_image_formats") + " (*.svg, *.jpg, *.png, *.gif)";
                        }
                    };
                    jfChooser.setFileFilter(ff);
                    if (jfChooser.showOpenDialog((Component)LabelStyleOpenBackgroundFile.this.owner) == 0) {
                        File f = jfChooser.getSelectedFile();
                        try {
                            IBackgroundFileStyle bgStyle = SymbologyLocator.getSymbologyManager().createBackgroundFileStyle(f.toURI().toURL());
                            LabelStyleOpenBackgroundFile.this.style.setBackgroundFileStyle(bgStyle);
                        }
                        catch (IOException e1) {
                            logger.error("While getting background style", (Throwable)e1);
                        }
                    }
                    ((StyleEditor)LabelStyleOpenBackgroundFile.this.owner).restorePreviousTool();
                    LabelStyleOpenBackgroundFile.this.owner.repaint();
                }
            });
        }
        return this.btnOpenFile;
    }

    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public String getID() {
        return "4";
    }

    public boolean isSuitableFor(Object obj) {
        return obj instanceof ILabelStyle;
    }

    public void setModel(Object objectToBeEdited) {
        this.style = (ILabelStyle)objectToBeEdited;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }
}

