/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.util.Iterator;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipedIterator<T>
implements DisposableIterable<T>,
DisposableIterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipedIterator.class);
    private T currentElement = null;
    private boolean isClosed = false;
    private final long timeout;

    public PipedIterator(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void put(T element) {
        if (this.isClosed) {
            throw new IllegalStateException("The piped iterator is closed");
        }
        if (this.currentElement != null) {
            try {
                LOGGER.debug("===: put wait");
                for (int retry = 0; retry < 10; ++retry) {
                    this.wait(this.timeout);
                    if (this.currentElement == null) break;
                    LOGGER.warn("Timeout waiting to consume elements on piped iterator (timeout=" + this.timeout + ", retry=" + retry + ").");
                }
                if (this.currentElement != null) {
                    throw new RuntimeException("Timeout waiting to consume elements on piped iterator (timeout=" + this.timeout + ").");
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Can't put element on piped iterator.", ex);
            }
        }
        LOGGER.debug("===: put notifyAll (closed " + this.isClosed + ") " + element.toString());
        this.currentElement = element;
        this.notifyAll();
    }

    public synchronized boolean hasNext() {
        if (this.currentElement != null) {
            LOGGER.debug("===: hasNext true, has currentElement");
            return true;
        }
        if (this.isClosed) {
            LOGGER.debug("===: hasNext false, is closed");
            return false;
        }
        if (this.currentElement == null) {
            try {
                LOGGER.debug("===: hasNext wait");
                for (int retry = 0; retry < 10; ++retry) {
                    this.wait(this.timeout);
                    if (this.currentElement != null) break;
                    LOGGER.warn("Timeout waiting to the next element on piped iterator (timeout=" + this.timeout + ", retry=" + retry + ").");
                }
                if (this.currentElement == null) {
                    throw new RuntimeException("Timeout waiting to the next element on piped iterator (timeout=" + this.timeout + ").");
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Can't get next element on piped iterator.", ex);
            }
        }
        LOGGER.debug("===: hasNext " + (this.currentElement != null));
        return this.currentElement != null;
    }

    public synchronized T next() {
        if (this.currentElement == null) {
            if (this.isClosed) {
                throw new IllegalStateException("The piped iterator is closed");
            }
            try {
                LOGGER.debug("===: next wait");
                this.wait(this.timeout);
                if (this.currentElement == null) {
                    throw new RuntimeException("Timeout waiting to the next element on piped iterator.");
                }
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Can't get next element on piped iterator.", ex);
            }
        }
        T x = this.currentElement;
        this.currentElement = null;
        LOGGER.debug("===: next notifyAll " + x.toString());
        this.notifyAll();
        return x;
    }

    public synchronized void dispose() {
    }

    public synchronized Iterator<T> iterator() {
        return this;
    }

    public synchronized void close() {
        LOGGER.debug("===: close notifyAll");
        this.isClosed = true;
        this.notifyAll();
    }
}

