/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.sql.Timestamp;
import java.util.Objects;
import javax.json.JsonObject;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkingCopyInformation;

public class VCSGisPreparedWorkspaceInformationImpl
implements VCSGisPreparedWorkingCopyInformation {
    private String name;
    private Timestamp date;
    private String location;
    private int numParts;

    public VCSGisPreparedWorkspaceInformationImpl() {
    }

    public VCSGisPreparedWorkspaceInformationImpl(JsonObject jsonData) {
        this.name = jsonData.getString("Name", null);
        this.date = (Timestamp)DataTypeUtils.toTimestamp((Object)jsonData.getString("Date", null), null);
        this.location = jsonData.getString("Location", null);
    }

    public String getName() {
        return this.name;
    }

    public Timestamp getDate() {
        return this.date;
    }

    public String getLocation() {
        return this.location;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDate(Timestamp date) {
        this.date = date;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getNumParts() {
        return this.numParts;
    }

    public void setNumParts(int numParts) {
        this.numParts = numParts;
    }

    public void copyFrom(VCSGisPreparedWorkingCopyInformation other) {
        this.name = other.getName();
        this.date = other.getDate();
        this.location = other.getLocation();
        this.numParts = other.getNumParts();
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Name", this.getName());
        builder.add("Date", Objects.toString(this.getDate(), null));
        builder.add("Location", this.getLocation());
        builder.add("NumParts", this.getNumParts());
        return builder;
    }

    public String toString() {
        return this.name;
    }
}

