/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.identityControllerLDAP;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.vcsgis.lib.SupportError;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisIdentityController;
import org.gvsig.vcsgis.lib.repository.localdb.AbstractIdentityController;
import org.gvsig.vcsgis.lib.repository.localdb.CryptUtils;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.identityControllerLDAP.LDAPUtils;
import org.gvsig.vcsgis.lib.repository.localdb.tables.ConfigRepoTable;

public class IdentityControllerLDAP
extends AbstractIdentityController
implements VCSGisIdentityController {
    private static final String CRYPTKEY = "private Pair<String,VCSGisUser> getAuthenticationToken(VCSGisUser user, String jwt)";
    private final String ldap_url;
    private final String ldap_user_template;
    private final String ldap_search_filter_template;
    private final String ldap_search_operations_name;
    private final String ldap_search_roles_name;

    public IdentityControllerLDAP(VCSGisRepositoryLocaldbImpl repo) {
        super(repo);
        ConfigRepoTable varsTable = new ConfigRepoTable();
        Map<String, String> vars = varsTable.getVars(repo, "LDAP_URL", "LDAP_USER_TEMPLATE", "LDAP_SEARCH_FILTER_TEMPLATE", "LDAP_SEARCH_OPERATIONS_NAME", "LDAP_SEARCH_ROLES_NAME");
        this.ldap_url = vars.get("LDAP_URL");
        this.ldap_user_template = vars.get("LDAP_USER_TEMPLATE");
        this.ldap_search_filter_template = vars.get("LDAP_SEARCH_FILTER_TEMPLATE");
        this.ldap_search_operations_name = vars.get("LDAP_SEARCH_OPERATIONS_NAME");
        this.ldap_search_roles_name = vars.get("LDAP_SEARCH_ROLES_NAME");
    }

    @Override
    public Pair<String, VCSGisUser> getAuthenticationToken(String userName, String password, SupportError error) {
        LDAPUtils.LDAPContext ldapcontext = LDAPUtils.createLDAPContext(this.ldap_url, this.ldap_user_template, this.ldap_search_filter_template);
        boolean n = LDAPUtils.authenticate(ldapcontext, userName, password);
        if (!n) {
            error.error(19, "Can't autheticate user '" + userName + "'.");
            return null;
        }
        List<String> operations = LDAPUtils.groups(ldapcontext, this.ldap_search_operations_name);
        List<String> roles = LDAPUtils.groups(ldapcontext, this.ldap_search_roles_name);
        JsonObjectBuilder jsoninfobuilder = Json.createObjectBuilder();
        jsoninfobuilder.add("Identifier", userName);
        jsoninfobuilder.add("AllowedOperations", StringUtils.join(operations, (String)","));
        jsoninfobuilder.add("Roles", StringUtils.join(roles, (String)","));
        jsoninfobuilder.add("expireTime", DataTypeUtils.toTimestamp((ChronoLocalDateTime)LocalDateTime.now().plusMinutes(480L)).getTime());
        JsonObject jsoninfo = jsoninfobuilder.build();
        VCSGisUserImpl user = new VCSGisUserImpl(jsoninfo);
        return new ImmutablePair((Object)this.getAuthenticationToken(jsoninfo), (Object)user);
    }

    @Override
    public Pair<String, VCSGisUser> getGuestAuthenticationToken() {
        VCSGisUser user = VCSGisUser.GUEST;
        JsonObjectBuilder jsoninfo = Json.createObjectBuilder();
        jsoninfo.add("Identifier", user.getIdentifier());
        jsoninfo.add("AllowedOperations", user.getAllowedOperations());
        jsoninfo.add("Roles", user.getRoles());
        jsoninfo.add("expireTime", DataTypeUtils.toTimestamp((ChronoLocalDateTime)LocalDateTime.now().plusMinutes(480L)).getTime());
        return new ImmutablePair((Object)this.getAuthenticationToken(jsoninfo.build()), (Object)user);
    }

    private String getAuthenticationToken(JsonObject jsoninfo) {
        String s = jsoninfo.toString();
        String jt = CryptUtils.base64encrypt(s, CRYPTKEY);
        return jt;
    }

    @Override
    protected VCSGisUser getUser(String authenticationToken, String userCode) {
        try {
            String s = CryptUtils.base64decrypt(authenticationToken, CRYPTKEY);
            JsonObject jsoninfo = Json.createObject((String)s);
            VCSGisUserImpl user = new VCSGisUserImpl(jsoninfo);
            return user;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    protected int checkToken(String authenticationToken, String userCode, SupportError error) {
        try {
            long now_l;
            String s = CryptUtils.base64decrypt(authenticationToken, CRYPTKEY);
            JsonObject jsoninfo = Json.createObject((String)s);
            long expireTime_l = jsoninfo.getJsonNumber("expireTime").longValue();
            if (expireTime_l > 0L && (now_l = new Date().getTime()) > expireTime_l) {
                error.error(22, "User '" + userCode + "' is not authenticated (token expired).");
                return 22;
            }
            Date d = new Date(expireTime_l);
            Date now = new Date();
            LOGGER.debug("Repository authentication for user with userCode '" + userCode + "' expire at '" + d.toString() + "' (now is '" + now.toString() + "'.");
            return 0;
        }
        catch (Exception ex) {
            return 20;
        }
    }
}

