/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.identityControllerLocaldb;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Date;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.vcsgis.lib.SupportError;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUserImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisIdentityController;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.AbstractIdentityController;
import org.gvsig.vcsgis.lib.repository.localdb.CryptUtils;
import org.gvsig.vcsgis.lib.repository.localdb.tables.UsersRepoTable;

public class IdentityControllerImpl
extends AbstractIdentityController
implements VCSGisIdentityController {
    private static final String CRYPTKEY = "private Pair<String,VCSGisUser> getAuthenticationToken(VCSGisUser user, String jwt)";

    public IdentityControllerImpl(VCSGisRepositoryLocaldb repo) {
        super(repo);
    }

    @Override
    public Pair<String, VCSGisUser> getAuthenticationToken(String userName, String password, SupportError error) {
        VCSGisUser user = this.repository.getUserByName(userName);
        if (user == null || user == VCSGisUser.GUEST) {
            error.error(19, "Can't autheticate user '" + userName + "'.");
            return null;
        }
        if (!StringUtils.equals((CharSequence)password, (CharSequence)((UsersRepoTable.UserRepoRow)user).getPassword())) {
            error.error(19, "Can't autheticate user '" + userName + "', password incorrect.");
            return null;
        }
        JsonObjectBuilder jsoninfobuilder = Json.createObjectBuilder();
        jsoninfobuilder.add("Identifier", userName);
        jsoninfobuilder.add("AllowedOperations", user.getAllowedOperations());
        jsoninfobuilder.add("Roles", user.getRoles());
        jsoninfobuilder.add("expireTime", DataTypeUtils.toTimestamp((ChronoLocalDateTime)LocalDateTime.now().plusMinutes(480L)).getTime());
        JsonObject jsoninfo = jsoninfobuilder.build();
        return new ImmutablePair((Object)this.getAuthenticationToken(jsoninfo), (Object)user);
    }

    @Override
    public Pair<String, VCSGisUser> getGuestAuthenticationToken() {
        VCSGisUser user = VCSGisUser.GUEST;
        JsonObjectBuilder jsoninfo = Json.createObjectBuilder();
        jsoninfo.add("Identifier", user.getIdentifier());
        jsoninfo.add("AllowedOperations", user.getAllowedOperations());
        jsoninfo.add("Roles", user.getRoles());
        jsoninfo.add("expireTime", DataTypeUtils.toTimestamp((ChronoLocalDateTime)LocalDateTime.now().plusMinutes(480L)).getTime());
        return new ImmutablePair((Object)this.getAuthenticationToken(jsoninfo.build()), (Object)user);
    }

    private String getAuthenticationToken(JsonObject jsoninfo) {
        String s = jsoninfo.toString();
        String jt = CryptUtils.base64encrypt(s, CRYPTKEY);
        return jt;
    }

    @Override
    protected VCSGisUser getUser(String authenticationToken, String userCode) {
        try {
            String s = CryptUtils.base64decrypt(authenticationToken, CRYPTKEY);
            JsonObject jsoninfo = Json.createObject((String)s);
            VCSGisUserImpl user = new VCSGisUserImpl(jsoninfo);
            return user;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    protected int checkToken(String authenticationToken, String userCode, SupportError error) {
        try {
            long now_l;
            String s = CryptUtils.base64decrypt(authenticationToken, CRYPTKEY);
            JsonObject jsoninfo = Json.createObject((String)s);
            long expireTime_l = jsoninfo.getJsonNumber("expireTime").longValue();
            if (expireTime_l > 0L && (now_l = new Date().getTime()) > expireTime_l) {
                error.error(22, "User '" + userCode + "' is not authenticated (token expired).");
                return 22;
            }
            Date d = new Date(expireTime_l);
            Date now = new Date();
            LOGGER.debug("Repository authentication for user with userCode '" + userCode + "' expire at '" + d.toString() + "' (now is '" + now.toString() + "'.");
            return 0;
        }
        catch (Exception ex) {
            return 20;
        }
    }
}

