/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisAuthenticateRequest;
import org.gvsig.vcsgis.lib.requests.AuthenticateRequestHelper;

public class AuthenticateRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisAuthenticateRequest {
    public AuthenticateRequestLocaldb(VCSGisRepositoryLocaldbImpl repository) {
        super(new AuthenticateRequestHelper(repository));
    }

    @Override
    public AuthenticateRequestHelper helper() {
        return (AuthenticateRequestHelper)super.helper();
    }

    public String getUserName() {
        return this.helper().getUserName();
    }

    public String getPassword() {
        return this.helper().getPassword();
    }

    public void setUserName(String name) {
        this.helper().setUserName(name);
    }

    public void setPassword(String password) {
        this.helper().setPassword(password);
    }

    public int execute() {
        try {
            Pair<String, VCSGisUser> tokenAndUser;
            if (!this.getRepository().isAuthenticationRequired()) {
                String userid = "guest";
                tokenAndUser = this.getRepository().getGuestAuthenticationToken();
                LOGGER.info("Process request: " + this.getRequestName() + " user='" + this.helper().getUserCode() + "' token='" + (String)tokenAndUser.getLeft() + "' OK");
            } else {
                String userid = this.helper().getUserName();
                tokenAndUser = this.getRepository().getAuthenticationToken(this.helper().getUserName(), this.helper().getPassword(), this);
                if (tokenAndUser == null) {
                    LOGGER.info("Process request: " + this.getRequestName() + " user='" + this.helper().getUserName() + "' Error");
                    return this.getLastErrorCode();
                }
            }
            this.helper().setAuthenticationToken((String)tokenAndUser.getLeft());
            this.helper().setUserCode(((VCSGisUser)tokenAndUser.getRight()).getUserCode());
            LOGGER.info("Process request: " + this.getRequestName() + " user='" + this.helper().getUserCode() + "' token='" + (String)tokenAndUser.getLeft() + "' OK");
            return this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't autheticate user '" + this.helper().getUserCode() + "'.", (Throwable)ex);
            return this.error(19, "Can't autheticate user '" + this.helper().getUserCode() + "'.");
        }
    }
}

